/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.morebuckets.item;

import com.blakebr0.cucumber.fluid.FluidHolderItemWrapper;
import com.blakebr0.cucumber.helper.BucketHelper;
import com.blakebr0.cucumber.helper.FluidHelper;
import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.iface.IFluidHolder;
import com.blakebr0.cucumber.iface.IModelHelper;
import com.blakebr0.cucumber.item.ItemBase;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.morebuckets.MoreBuckets;
import com.blakebr0.morebuckets.lib.DispenseBucketBehavior;
import com.blakebr0.morebuckets.lib.RecipeFixer;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class ItemMoreBucket
extends ItemBase
implements IFluidHolder,
IModelHelper,
IEnableable {
    private final String name;
    private final int capacity;
    private final boolean requiredMods;

    public ItemMoreBucket(String name, int capacity) {
        this(name, capacity, true, true);
    }

    public ItemMoreBucket(String name, int capacity, boolean requiredMods) {
        this(name, capacity, true, requiredMods);
    }

    public ItemMoreBucket(String name, int capacity, boolean recipeReplacement, boolean requiredMods) {
        super("morebuckets." + name);
        this.name = name;
        this.capacity = capacity;
        this.requiredMods = requiredMods;
        this.func_77625_d(1);
        this.func_77637_a(MoreBuckets.CREATIVE_TAB);
        if (this.isEnabled()) {
            BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DispenseBucketBehavior.getInstance());
            if (recipeReplacement) {
                RecipeFixer.VALID_BUCKETS.add(this);
            }
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return BucketHelper.getFluidAmount((ItemStack)stack) > 0;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack copy = new ItemStack((Item)this);
        copy.func_77982_d(stack.func_77978_p());
        this.drain(copy, 1000, true);
        return copy;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCapacity(stack) > 1000;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int capacity = this.getCapacity(stack);
        double stored = capacity - BucketHelper.getFluidAmount((ItemStack)stack);
        return stored / (double)capacity;
    }

    public int getItemBurnTime(ItemStack stack) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.isFluidEqual(new FluidStack(FluidRegistry.LAVA, 1000)) && BucketHelper.getFluidAmount((ItemStack)stack) >= 1000) {
            return 20000;
        }
        return -1;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        String fluidName;
        int capacity = this.getCapacity(stack) / 1000;
        int buckets = BucketHelper.getFluidAmount((ItemStack)stack) / 1000;
        FluidStack fluid = this.getFluid(stack);
        String string = fluidName = fluid == null ? Utils.localize((String)"tooltip.morebuckets.empty") : fluid.getLocalizedName();
        if (fluid != null && FluidHelper.getFluidRarity((FluidStack)fluid) != EnumRarity.COMMON) {
            fluidName = FluidHelper.getFluidRarity((FluidStack)fluid).field_77937_e.toString() + fluidName;
        }
        tooltip.add(Utils.localize((String)"tooltip.morebuckets.buckets", (Object[])new Object[]{buckets, capacity, fluidName}));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        FluidStack fluid = this.getFluid(stack);
        ActionResult<ItemStack> pickup = this.tryPickupFluid(stack, world, player, hand);
        if (pickup.func_188397_a() == EnumActionResult.SUCCESS) {
            return pickup;
        }
        if (fluid != null && fluid.amount >= 1000) {
            return this.tryPlaceFluid(stack, world, player, hand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (target instanceof EntityCow) {
            EntityCow cow = (EntityCow)target;
            if (!player.field_71075_bZ.field_75098_d && !cow.func_70631_g_()) {
                Fluid milk = FluidRegistry.getFluid((String)"milk");
                return milk != null && this.fill(stack, new FluidStack(milk, 1000), true) > 0;
            }
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound tag) {
        return new FluidHolderItemWrapper(stack, (IFluidHolder)this, true, true);
    }

    public int getCapacity(ItemStack stack) {
        return this.capacity;
    }

    public FluidStack getFluid(ItemStack stack) {
        return BucketHelper.getFluid((ItemStack)stack);
    }

    public int fill(ItemStack stack, FluidStack fluid, boolean canFill) {
        NBTHelper.validateCompound((ItemStack)stack);
        FluidStack bucketFluid = this.getFluid(stack);
        if (bucketFluid != null && !fluid.isFluidEqual(bucketFluid)) {
            return 0;
        }
        int capacity = this.getCapacity(stack);
        if (!canFill) {
            if (bucketFluid == null) {
                return BucketHelper.toBuckets((int)Math.min(capacity, fluid.amount));
            }
            return BucketHelper.toBuckets((int)Math.min(capacity - bucketFluid.amount, fluid.amount));
        }
        int filled = BucketHelper.toBuckets((int)Math.min(fluid.amount, capacity));
        if (bucketFluid == null) {
            NBTTagCompound fluidTag = fluid.writeToNBT(new NBTTagCompound());
            fluidTag.func_74768_a("Amount", filled);
            stack.func_77982_d(fluidTag);
            return filled;
        }
        filled = BucketHelper.toBuckets((int)(capacity - bucketFluid.amount));
        int amount = BucketHelper.toBuckets((int)fluid.amount);
        if (amount < filled) {
            bucketFluid.amount += amount;
            filled = amount;
        } else {
            bucketFluid.amount = capacity;
        }
        bucketFluid.writeToNBT(stack.func_77978_p());
        return filled;
    }

    public FluidStack drain(ItemStack stack, int amount, boolean canDrain) {
        NBTHelper.validateCompound((ItemStack)stack);
        if (amount == 0) {
            return null;
        }
        FluidStack fluid = this.getFluid(stack);
        if (fluid == null) {
            return null;
        }
        int drained = BucketHelper.toBuckets((int)Math.min(fluid.amount, amount));
        if (canDrain) {
            if (amount >= fluid.amount) {
                NBTHelper.removeTag((ItemStack)stack, (String)"FluidName");
                NBTHelper.removeTag((ItemStack)stack, (String)"Amount");
                return fluid;
            }
            fluid.amount -= drained;
            fluid.writeToNBT(stack.func_77978_p());
        }
        fluid.amount = drained;
        return fluid;
    }

    public void initModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> ResourceHelper.getModelResource((String)"morebuckets", (String)this.name, (String)"inventory"));
    }

    public int getSpaceLeft(ItemStack stack) {
        return this.getCapacity(stack) - BucketHelper.getFluidAmount((ItemStack)stack);
    }

    private ActionResult<ItemStack> tryPlaceFluid(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        FluidActionResult result;
        BlockPos targetPos;
        if (BucketHelper.getFluidAmount((ItemStack)stack) < 1000) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult trace = this.func_77621_a(world, player, false);
        if (trace == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos = trace.func_178782_a();
        if (world.func_175660_a(player, pos) && player.func_175151_a(targetPos = pos.func_177972_a(trace.field_178784_b), trace.field_178784_b.func_176734_d(), stack) && (result = FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)targetPos, (ItemStack)stack, (FluidStack)new FluidStack(this.getFluid(stack), 1000))).isSuccess() && !player.field_71075_bZ.field_75098_d) {
            player.func_71029_a(StatList.func_188057_b((Item)this));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)result.getResult());
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    private ActionResult<ItemStack> tryPickupFluid(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        FluidActionResult result;
        if (this.getSpaceLeft(stack) < 1000) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult trace = this.func_77621_a(world, player, true);
        if (trace == null || trace.field_178784_b == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos = trace.func_178782_a();
        if (world.func_175660_a(player, pos) && player.func_175151_a(pos, trace.field_178784_b, stack) && (result = FluidUtil.tryPickUpFluid((ItemStack)stack, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)trace.field_178784_b)).isSuccess() && !player.field_71075_bZ.field_75098_d) {
            player.func_71029_a(StatList.func_188057_b((Item)this));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)result.getResult());
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public boolean isEnabled() {
        return this.requiredMods;
    }
}

