/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.morebuckets.lib;

import com.blakebr0.cucumber.helper.BucketHelper;
import com.blakebr0.morebuckets.item.ItemMoreBucket;
import com.blakebr0.morebuckets.lib.RecipeFixer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidIngredient
extends Ingredient {
    private final Ingredient parent;

    public FluidIngredient(Ingredient parent) {
        super(FluidIngredient.makeMatchingStacksArray(parent));
        this.parent = parent;
    }

    public boolean apply(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluid != null && stack.func_77973_b() instanceof ItemMoreBucket) {
            for (ItemStack itemstack : this.func_193365_a()) {
                FluidStack fluidstack = FluidUtil.getFluidContained((ItemStack)itemstack);
                if ((fluidstack == null || !fluidstack.isFluidEqual(fluid)) && (itemstack.func_77973_b() != Items.field_151117_aB || !fluid.getFluid().getName().equals("milk"))) continue;
                return true;
            }
        }
        return this.parent.apply(stack);
    }

    public boolean isSimple() {
        return false;
    }

    private static ItemStack[] makeMatchingStacksArray(Ingredient ingredient) {
        FluidStack fluid = FluidIngredient.findFluid(ingredient);
        if (fluid != null) {
            ItemStack[] parentStacks = ingredient.func_193365_a();
            ItemStack[] bucketStacks = (ItemStack[])RecipeFixer.VALID_BUCKETS.stream().map(e -> BucketHelper.getFilledBucket((FluidStack)fluid, (Item)e, (int)e.getCapacity(ItemStack.field_190927_a))).toArray(ItemStack[]::new);
            ItemStack[] matchingStacks = new ItemStack[parentStacks.length + bucketStacks.length];
            for (int i = 0; i < parentStacks.length; ++i) {
                matchingStacks[i] = parentStacks[i];
            }
            for (int j = parentStacks.length; j < matchingStacks.length; ++j) {
                matchingStacks[j] = bucketStacks[j - parentStacks.length];
            }
            return matchingStacks;
        }
        return ingredient.func_193365_a();
    }

    private static FluidStack findFluid(Ingredient ingredient) {
        for (ItemStack stack : ingredient.func_193365_a()) {
            if (stack.func_77973_b() == Items.field_151131_as) {
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            if (stack.func_77973_b() == Items.field_151129_at) {
                return new FluidStack(FluidRegistry.LAVA, 1000);
            }
            if (stack.func_77973_b() == Items.field_151117_aB) {
                if (FluidRegistry.isFluidRegistered((String)"milk")) {
                    return new FluidStack(FluidRegistry.getFluid((String)"milk"), 1000);
                }
                return null;
            }
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluid == null) continue;
            return fluid;
        }
        return null;
    }
}

