/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.morebuckets.lib;

import com.blakebr0.morebuckets.MoreBuckets;
import com.blakebr0.morebuckets.item.ItemMoreBucket;
import com.blakebr0.morebuckets.lib.FluidIngredient;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeFixer {
    public static final ArrayList<ItemMoreBucket> VALID_BUCKETS = new ArrayList();

    public static void fixRecipes() {
        ForgeRegistries.RECIPES.forEach(recipe -> {
            ItemStack output = recipe.func_77571_b();
            if (output.func_77973_b() instanceof UniversalBucket || output.func_77973_b() == Items.field_151129_at || output.func_77973_b() == Items.field_151131_as || output.func_77973_b() == Items.field_151117_aB) {
                return;
            }
            NonNullList ing = recipe.func_192400_c();
            boolean shapeless = false;
            boolean shapelessOre = false;
            block0: for (int i = 0; i < ing.size(); ++i) {
                Ingredient ingredient = (Ingredient)ing.get(i);
                if (!ingredient.getClass().equals(Ingredient.class) && !ingredient.getClass().equals(IngredientNBT.class)) continue;
                for (ItemStack stack : ingredient.func_193365_a()) {
                    if (!(stack.func_77973_b() instanceof UniversalBucket) && stack.func_77973_b() != Items.field_151129_at && stack.func_77973_b() != Items.field_151131_as && stack.func_77973_b() != Items.field_151117_aB) continue;
                    ing.set(i, (Object)new FluidIngredient(ingredient));
                    if (recipe instanceof ShapelessRecipes) {
                        shapeless = true;
                    }
                    if (!(recipe instanceof ShapelessOreRecipe)) continue block0;
                    shapelessOre = true;
                    continue block0;
                }
            }
            if (shapeless) {
                RecipeFixer.setNotSimple((ShapelessRecipes)recipe);
            }
            if (shapelessOre) {
                RecipeFixer.setNotSimple((ShapelessOreRecipe)recipe);
            }
        });
    }

    private static void setNotSimple(ShapelessRecipes recipe) {
        block2: {
            try {
                Field isSimple = recipe.getClass().getDeclaredField("isSimple");
                isSimple.setAccessible(true);
                isSimple.setBoolean(recipe, false);
            }
            catch (Exception e) {
                if (recipe == null || recipe.getRegistryName() == null) break block2;
                MoreBuckets.LOGGER.info("Unable to set recipe {} to not simple.", (Object)recipe.getRegistryName().toString());
            }
        }
    }

    private static void setNotSimple(ShapelessOreRecipe recipe) {
        block2: {
            try {
                Field isSimple = recipe.getClass().getDeclaredField("isSimple");
                isSimple.setAccessible(true);
                isSimple.setBoolean(recipe, false);
            }
            catch (Exception e) {
                if (recipe == null || recipe.getRegistryName() == null) break block2;
                MoreBuckets.LOGGER.info("Unable to set recipe {} to not simple.", (Object)recipe.getRegistryName().toString());
            }
        }
    }
}

