/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.client.gui;

import com.bloodnbonesgaming.topography.IOHelper;
import com.bloodnbonesgaming.topography.client.gui.GuiButtonAlpha;
import com.bloodnbonesgaming.topography.client.gui.element.EnumGuiLocation;
import com.bloodnbonesgaming.topography.client.gui.element.GuiElementText;
import com.bloodnbonesgaming.topography.client.gui.element.GuiElementTexture;
import com.bloodnbonesgaming.topography.client.gui.element.GuiElementTextureStretch;
import com.bloodnbonesgaming.topography.client.gui.newstuff.GuiOptionsListNew;
import com.bloodnbonesgaming.topography.config.ConfigPreset;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiCreateWorldTopography
extends GuiCreateWorld {
    private GuiOptionsListNew list;
    private List<ConfigPreset> presets;
    private GuiElementTexture texture;
    private final List<GuiElementText> description = new ArrayList<GuiElementText>();
    GuiButtonAlpha create;

    public GuiCreateWorldTopography(GuiScreen parent) {
        super(parent);
        ConfigurationManager.setup();
        this.presets = new ArrayList<ConfigPreset>(ConfigurationManager.getInstance().getPresets().values());
    }

    public void func_73876_c() {
        this.field_146333_g.func_146178_a();
        this.field_146335_h.func_146178_a();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.create = (GuiButtonAlpha)this.func_189646_b(new GuiButtonAlpha(0, 0, this.field_146295_m - 20, 100, 20, I18n.func_135052_a((String)"selectWorld.create", (Object[])new Object[0]), 0.8f));
        this.field_146292_n.add(new GuiButtonAlpha(1, 100, this.field_146295_m - 20, 100, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), 0.8f));
        this.field_146343_z = this.func_189646_b(new GuiButtonAlpha(2, 0, 46, 150, 20, I18n.func_135052_a((String)"selectWorld.gameMode", (Object[])new Object[0]), 0.8f));
        this.field_146325_B = this.func_189646_b(new GuiButtonAlpha(4, 0, 112, 150, 20, I18n.func_135052_a((String)"selectWorld.mapFeatures", (Object[])new Object[0]), 0.8f));
        this.field_146325_B.field_146125_m = true;
        this.field_146326_C = this.func_189646_b(new GuiButtonAlpha(7, 0, 90, 150, 20, I18n.func_135052_a((String)"selectWorld.bonusItems", (Object[])new Object[0]), 0.8f));
        this.field_146326_C.field_146125_m = true;
        this.field_146320_D = this.func_189646_b(new GuiButtonAlpha(5, 0, 134, 150, 20, I18n.func_135052_a((String)"selectWorld.mapType", (Object[])new Object[0]), 0.8f));
        this.field_146320_D.field_146125_m = true;
        this.field_146321_E = this.func_189646_b(new GuiButtonAlpha(6, 0, 68, 150, 20, I18n.func_135052_a((String)"selectWorld.allowCommands", (Object[])new Object[0]), 0.8f));
        this.field_146321_E.field_146125_m = true;
        this.field_146322_F = this.func_189646_b(new GuiButtonAlpha(8, 0, 156, 150, 20, I18n.func_135052_a((String)"selectWorld.customizeType", (Object[])new Object[0]), 0.8f));
        this.field_146322_F.field_146125_m = WorldType.field_77139_a[this.field_146331_K].isCustomizable();
        this.field_146333_g = new GuiTextField(9, this.field_146289_q, 1, 1, 200, 20);
        this.field_146333_g.func_146195_b(true);
        this.field_146333_g.func_146180_a(this.field_146330_J);
        this.field_146335_h = new GuiTextField(10, this.field_146289_q, 1, 24, 200, 20);
        if (this.field_146329_I.isEmpty()) {
            this.field_146329_I = Long.toString(new Random().nextLong());
        }
        this.field_146335_h.func_146180_a(this.field_146329_I);
        this.showMoreWorldOptions(this.field_146344_y);
        this.calcSaveDirName();
        this.updateDisplayState();
        if (this.list == null) {
            int listSize = 0;
            for (ConfigPreset preset : this.presets) {
                int name = this.field_146289_q.func_78256_a(preset.getName());
                if (preset.locked()) {
                    name += 9;
                }
                listSize = name > listSize ? name : listSize;
            }
            this.list = new GuiOptionsListNew(Minecraft.func_71410_x(), this.field_146289_q, listSize += 12, this.field_146295_m - 50, 0, this.field_146295_m, this.field_146294_l - listSize, this.field_146294_l, this.field_146295_m, this.presets, this);
        }
        if (WorldType.field_77139_a[this.field_146331_K].func_77127_a().equals("topography")) {
            int currentIndex = this.list.getIndex();
            int listSize = 0;
            for (ConfigPreset preset : this.presets) {
                int name = this.field_146289_q.func_78256_a(preset.getName());
                if (preset.locked()) {
                    name += 9;
                }
                listSize = name > listSize ? name : listSize;
            }
            this.list = new GuiOptionsListNew(Minecraft.func_71410_x(), this.field_146289_q, listSize += 12, this.field_146295_m - 50, 0, this.field_146295_m, this.field_146294_l - listSize, this.field_146294_l, this.field_146295_m, this.presets, this);
            this.list.elementClicked(currentIndex, false);
        }
    }

    private void calcSaveDirName() {
        this.field_146336_i = this.field_146333_g.func_146179_b().trim();
        for (char c0 : ChatAllowedCharacters.field_71567_b) {
            this.field_146336_i = this.field_146336_i.replace(c0, '_');
        }
        if (StringUtils.isEmpty((CharSequence)this.field_146336_i)) {
            this.field_146336_i = "World";
        }
        this.field_146336_i = GuiCreateWorldTopography.getUncollidingSaveDirName(this.field_146297_k.func_71359_d(), this.field_146336_i);
    }

    private void updateDisplayState() {
        this.field_146343_z.field_146126_j = I18n.func_135052_a((String)"selectWorld.gameMode", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("selectWorld.gameMode." + this.field_146342_r), (Object[])new Object[0]);
        this.field_146325_B.field_146126_j = I18n.func_135052_a((String)"selectWorld.mapFeatures", (Object[])new Object[0]) + " ";
        this.field_146325_B.field_146126_j = this.field_146341_s ? this.field_146325_B.field_146126_j + I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : this.field_146325_B.field_146126_j + I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
        this.field_146326_C.field_146126_j = I18n.func_135052_a((String)"selectWorld.bonusItems", (Object[])new Object[0]) + " ";
        this.field_146326_C.field_146126_j = this.field_146338_v && !this.field_146337_w ? this.field_146326_C.field_146126_j + I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : this.field_146326_C.field_146126_j + I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
        this.field_146320_D.field_146126_j = I18n.func_135052_a((String)"selectWorld.mapType", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)WorldType.field_77139_a[this.field_146331_K].func_77128_b(), (Object[])new Object[0]);
        this.field_146321_E.field_146126_j = I18n.func_135052_a((String)"selectWorld.allowCommands", (Object[])new Object[0]) + " ";
        this.field_146321_E.field_146126_j = this.field_146340_t && !this.field_146337_w ? this.field_146321_E.field_146126_j + I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : this.field_146321_E.field_146126_j + I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
    }

    public static String getUncollidingSaveDirName(ISaveFormat saveLoader, String name) {
        name = name.replaceAll("[\\./\"]", "_");
        for (String s : field_146327_L) {
            if (!name.equalsIgnoreCase(s)) continue;
            name = "_" + name + "_";
        }
        while (saveLoader.func_75803_c(name) != null) {
            name = name + "-";
        }
        return name;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                this.field_146297_k.func_147108_a(this.field_146332_f);
            } else if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
                if (this.field_146345_x) {
                    return;
                }
                this.field_146345_x = true;
                long i = new Random().nextLong();
                String s = this.field_146335_h.func_146179_b();
                if (!StringUtils.isEmpty((CharSequence)s)) {
                    try {
                        long j = Long.parseLong(s);
                        if (j != 0L) {
                            i = j;
                        }
                    }
                    catch (NumberFormatException var7) {
                        i = s.hashCode();
                    }
                }
                WorldType.field_77139_a[this.field_146331_K].onGUICreateWorldPress();
                WorldSettings worldsettings = new WorldSettings(i, GameType.func_77142_a((String)this.field_146342_r), this.field_146341_s, this.field_146337_w, WorldType.field_77139_a[this.field_146331_K]);
                worldsettings.func_82750_a(this.field_146334_a);
                if (this.field_146338_v && !this.field_146337_w) {
                    worldsettings.func_77159_a();
                }
                if (this.field_146340_t && !this.field_146337_w) {
                    worldsettings.func_77166_b();
                }
                this.field_146297_k.func_71371_a(this.field_146336_i, this.field_146333_g.func_146179_b().trim(), worldsettings);
            } else if (button.field_146127_k == 3) {
                this.toggleMoreWorldOptions();
            } else if (button.field_146127_k == 2) {
                if ("survival".equals(this.field_146342_r)) {
                    if (!this.field_146339_u) {
                        this.field_146340_t = false;
                    }
                    this.field_146337_w = false;
                    this.field_146342_r = "hardcore";
                    this.field_146337_w = true;
                    this.field_146321_E.field_146124_l = false;
                    this.field_146326_C.field_146124_l = false;
                    this.updateDisplayState();
                } else if ("hardcore".equals(this.field_146342_r)) {
                    if (!this.field_146339_u) {
                        this.field_146340_t = true;
                    }
                    this.field_146337_w = false;
                    this.field_146342_r = "creative";
                    this.updateDisplayState();
                    this.field_146337_w = false;
                    this.field_146321_E.field_146124_l = true;
                    this.field_146326_C.field_146124_l = true;
                } else {
                    if (!this.field_146339_u) {
                        this.field_146340_t = false;
                    }
                    this.field_146342_r = "survival";
                    this.updateDisplayState();
                    this.field_146321_E.field_146124_l = true;
                    this.field_146326_C.field_146124_l = true;
                    this.field_146337_w = false;
                }
                this.updateDisplayState();
            } else if (button.field_146127_k == 4) {
                this.field_146341_s = !this.field_146341_s;
                this.updateDisplayState();
            } else if (button.field_146127_k == 7) {
                this.field_146338_v = !this.field_146338_v;
                this.updateDisplayState();
            } else if (button.field_146127_k == 5) {
                ++this.field_146331_K;
                if (this.field_146331_K >= WorldType.field_77139_a.length) {
                    this.field_146331_K = 0;
                }
                while (!this.canSelectCurWorldType()) {
                    ++this.field_146331_K;
                    if (this.field_146331_K < WorldType.field_77139_a.length) continue;
                    this.field_146331_K = 0;
                }
                this.field_146334_a = "";
                this.updateDisplayState();
                this.showMoreWorldOptions(this.field_146344_y);
                if (WorldType.field_77139_a[this.field_146331_K].func_77127_a().equals("topography")) {
                    this.onListSelected(this.presets.get(this.list.getIndex()));
                }
            } else if (button.field_146127_k == 6) {
                this.field_146339_u = true;
                this.field_146340_t = !this.field_146340_t;
                this.updateDisplayState();
            } else if (button.field_146127_k == 8) {
                WorldType.field_77139_a[this.field_146331_K].onCustomizeButton(this.field_146297_k, (GuiCreateWorld)this);
            }
        }
    }

    private boolean canSelectCurWorldType() {
        WorldType worldtype = WorldType.field_77139_a[this.field_146331_K];
        if (worldtype != null && worldtype.func_77126_d()) {
            return worldtype == WorldType.field_180272_g ? GuiCreateWorldTopography.func_146272_n() : true;
        }
        return false;
    }

    private void toggleMoreWorldOptions() {
        this.showMoreWorldOptions(!this.field_146344_y);
    }

    private void showMoreWorldOptions(boolean toggle) {
        this.field_146344_y = toggle;
        if (WorldType.field_77139_a[this.field_146331_K] == WorldType.field_180272_g) {
            this.field_146343_z.field_146125_m = true;
            this.field_146343_z.field_146124_l = true;
            if (this.field_175300_s == null) {
                this.field_175300_s = this.field_146342_r;
            }
            this.field_146342_r = "spectator";
            this.field_146325_B.field_146125_m = true;
            this.field_146326_C.field_146125_m = true;
            this.field_146320_D.field_146125_m = true;
            this.field_146321_E.field_146125_m = true;
            this.field_146322_F.field_146125_m = true;
        } else {
            this.field_146343_z.field_146125_m = true;
            this.field_146343_z.field_146124_l = true;
            if (this.field_175300_s != null) {
                this.field_146342_r = this.field_175300_s;
                this.field_175300_s = null;
            }
            this.field_146325_B.field_146125_m = true;
            this.field_146326_C.field_146125_m = true;
            this.field_146320_D.field_146125_m = true;
            this.field_146321_E.field_146125_m = true;
            this.field_146322_F.field_146125_m = WorldType.field_77139_a[this.field_146331_K].isCustomizable();
        }
        this.updateDisplayState();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.field_146333_g.func_146206_l()) {
            this.field_146333_g.func_146201_a(typedChar, keyCode);
            this.field_146330_J = this.field_146333_g.func_146179_b();
        } else if (this.field_146335_h.func_146206_l()) {
            this.field_146335_h.func_146201_a(typedChar, keyCode);
            this.field_146329_I = this.field_146335_h.func_146179_b();
        }
        if (keyCode == 28 || keyCode == 156) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = !this.field_146333_g.func_146179_b().isEmpty();
        this.calcSaveDirName();
        if (keyCode == 1) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(1));
        }
        if (keyCode == 200) {
            this.list.up();
        }
        if (keyCode == 208) {
            this.list.down();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.field_146335_h.func_146192_a(mouseX, mouseY, mouseButton);
        this.field_146333_g.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (WorldType.field_77139_a[this.field_146331_K].func_77127_a().equals("topography")) {
            if (this.texture != null) {
                this.texture.render(Minecraft.func_71410_x(), this.field_146294_l, this.field_146295_m);
            } else {
                this.func_146276_q_();
            }
        } else {
            this.func_146276_q_();
        }
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get(i)).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
        for (int j = 0; j < this.field_146293_o.size(); ++j) {
            ((GuiLabel)this.field_146293_o.get(j)).func_146159_a(this.field_146297_k, mouseX, mouseY);
        }
        if (WorldType.field_77139_a[this.field_146331_K].func_77127_a().equals("topography")) {
            this.list.drawScreen(mouseX, mouseY, partialTicks);
            if (!this.description.isEmpty()) {
                GuiUtils.drawGradientRect((int)0, (int)0, (int)(149 + this.field_146289_q.field_78288_b - 2), (int)200, (int)Math.min(this.field_146295_m - 20, 149 + this.description.size() * this.field_146289_q.field_78288_b + this.field_146289_q.field_78288_b + 2), (int)-1072689136, (int)-804253680);
                for (GuiElementText text : this.description) {
                    text.render(this.field_146289_q, this.field_146294_l, this.field_146295_m);
                }
            }
        }
        this.field_146335_h.func_146194_f();
        if (WorldType.field_77139_a[this.field_146331_K].func_151357_h()) {
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)WorldType.field_77139_a[this.field_146331_K].func_151359_c(), (Object[])new Object[0]), this.field_146320_D.field_146128_h + 2, this.field_146320_D.field_146129_i + 22, this.field_146320_D.func_146117_b(), 0xA0A0A0);
        }
        this.field_146333_g.func_146194_f();
        this.func_73731_b(this.field_146289_q, this.field_146323_G, this.field_146294_l / 2 - 100, 137, -6250336);
        this.func_73731_b(this.field_146289_q, this.field_146328_H, this.field_146294_l / 2 - 100, 149, -6250336);
    }

    public void func_146318_a(WorldInfo original) {
        JsonObject obj;
        JsonElement member;
        JsonParser parser;
        JsonElement element;
        this.field_146330_J = I18n.func_135052_a((String)"selectWorld.newWorld.copyOf", (Object[])new Object[]{original.func_76065_j()});
        this.field_146329_I = original.func_76063_b() + "";
        this.field_146335_h.func_146180_a(this.field_146329_I);
        this.field_146331_K = original.func_76067_t().func_82747_f();
        this.field_146334_a = original.func_82571_y();
        if (WorldType.field_77139_a[this.field_146331_K].func_77127_a().equals("topography") && !this.field_146334_a.isEmpty() && (element = (parser = new JsonParser()).parse(this.field_146334_a)).isJsonObject() && (member = (obj = (JsonObject)element).get("Topography-Preset")) != null) {
            String presetString = member.getAsString();
            for (int i = 0; i < this.presets.size(); ++i) {
                ConfigPreset preset = this.presets.get(i);
                if (!preset.getName().equals(presetString)) continue;
                this.list.elementClicked(i, false);
            }
        }
        this.field_146341_s = original.func_76089_r();
        this.field_146340_t = original.func_76086_u();
        if (original.func_76093_s()) {
            this.field_146342_r = "hardcore";
        } else if (original.func_76077_q().func_77144_e()) {
            this.field_146342_r = "survival";
        } else if (original.func_76077_q().func_77145_d()) {
            this.field_146342_r = "creative";
        }
        this.updateDisplayState();
    }

    public void onListSelected(ConfigPreset preset) {
        this.description.clear();
        String description = preset.getDescription();
        if (description != null && !description.isEmpty()) {
            List list = Minecraft.func_71410_x().field_71466_p.func_78271_c(description, 196);
            int index = 0;
            int totalHeight = (list.size() + 1) * this.field_146289_q.field_78288_b;
            for (String string : list) {
                GuiElementText text = new GuiElementText(EnumGuiLocation.TOP_LEFT, string);
                text.setAbsXOffset(2);
                text.setAbsYOffset(149 + ++index * this.field_146289_q.field_78288_b);
                this.description.add(text);
            }
        }
        this.texture = null;
        String imageName = preset.getImage();
        if (!imageName.isEmpty()) {
            BufferedImage image = IOHelper.loadImage(imageName);
            if (image != null) {
                this.texture = new GuiElementTextureStretch(EnumGuiLocation.TOP_LEFT, this.field_146297_k.func_110434_K().func_110578_a("presetImage", new DynamicTexture(image)), image.getWidth(), image.getHeight());
                this.texture.setRelRender(1.0, 1.0);
            } else {
                this.texture = null;
            }
        } else {
            this.texture = null;
        }
        this.create.field_146124_l = !preset.locked();
        this.field_146334_a = "{\"Topography-Preset\":\"" + this.presets.get(this.list.getIndex()).getName() + "\"}";
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.handleMouseInput(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c, this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1);
    }
}

