/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.client.gui.element;

import com.bloodnbonesgaming.topography.Topography;
import com.bloodnbonesgaming.topography.client.gui.element.EnumGuiLocation;
import com.bloodnbonesgaming.topography.client.gui.element.GuiElementBase;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public abstract class GuiElementTexture
extends GuiElementBase {
    protected final ResourceLocation texture;
    protected int imageWidth;
    protected int imageHeight;
    protected int absRenderWidth = 0;
    protected int absRenderHeight = 0;
    protected double relRenderWidth = 0.0;
    protected double relRenderHeight = 0.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GuiElementTexture(EnumGuiLocation location, ResourceLocation texture) {
        super(location);
        this.texture = texture;
        int width = 0;
        int height = 0;
        IResource iresource = null;
        try {
            iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(texture);
            BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
            width = bufferedimage.getWidth();
            height = bufferedimage.getHeight();
        }
        catch (IOException e) {
            try {
                Topography.instance.getLog().error((Object)("Could not load texture for " + texture.toString()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(iresource);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)iresource);
        }
        IOUtils.closeQuietly((Closeable)iresource);
        this.imageWidth = width;
        this.imageHeight = height;
    }

    public GuiElementTexture(EnumGuiLocation location, ResourceLocation texture, int imageWidth, int imageHeight) {
        super(location);
        this.texture = texture;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    public void setAbsRenderWidth(int width) {
        this.absRenderWidth = width;
    }

    public void setAbsRenderHeight(int height) {
        this.absRenderHeight = height;
    }

    public void setAbsRender(int width, int height) {
        this.absRenderWidth = width;
        this.absRenderHeight = height;
    }

    public void setRelRenderWidth(double width) {
        this.relRenderWidth = width;
    }

    public void setRelRenderHeight(double height) {
        this.relRenderHeight = height;
    }

    public void setRelRender(double width, double height) {
        this.relRenderWidth = width;
        this.relRenderHeight = height;
    }

    public void render(Minecraft minecraft, int guiWidth, int guiHeight) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179106_n();
        minecraft.func_110434_K().func_110577_a(this.texture);
        this.drawTexture(this.location.getX(guiWidth, (int)(this.relRenderWidth * (double)guiWidth)), this.location.getY(guiHeight, (int)(this.relRenderHeight * (double)guiHeight)), this.imageWidth, this.imageHeight, (int)(this.relRenderWidth * (double)guiWidth), (int)(this.relRenderHeight * (double)guiHeight), 0.0, 0.0, this.imageWidth, this.imageHeight);
    }

    abstract void drawTexture(int var1, int var2, int var3, int var4, int var5, int var6, double var7, double var9, double var11, double var13);
}

