/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.client.gui.newstuff;

import com.bloodnbonesgaming.topography.client.gui.GuiCreateWorldTopography;
import com.bloodnbonesgaming.topography.client.gui.GuiScrollingList;
import com.bloodnbonesgaming.topography.config.ConfigPreset;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiOptionsListNew
extends GuiScrollingList {
    final FontRenderer fontRenderer;
    private int selectedIndex = 0;
    final List<ConfigPreset> presets;
    final GuiCreateWorldTopography parent;

    public GuiOptionsListNew(Minecraft client, FontRenderer fontRenderer, int width, int height, int top, int bottom, int left, int screenWidth, int screenHeight, List<ConfigPreset> presets, GuiCreateWorldTopography parent) {
        super(client, width, height, top, bottom, left, fontRenderer.field_78288_b + 11, screenWidth, screenHeight);
        this.fontRenderer = fontRenderer;
        this.presets = presets;
        this.parent = parent;
    }

    public int getIndex() {
        return this.selectedIndex;
    }

    @Override
    protected int getSize() {
        return this.presets.size();
    }

    @Override
    public void elementClicked(int index, boolean doubleClick) {
        this.selectedIndex = index;
        this.parent.onListSelected(this.presets.get(index));
    }

    public void down() {
        ++this.selectedIndex;
        if (this.scrollDistance < (float)(this.slotHeight * (this.selectedIndex + 1) - (this.bottom - this.top))) {
            this.scrollDistance += (float)this.slotHeight;
        }
        if (this.presets.size() <= this.selectedIndex) {
            this.selectedIndex = 0;
            this.scrollDistance = 0.0f;
        }
        if (this.presets.get(this.selectedIndex).locked()) {
            this.down();
        } else {
            this.elementClicked(this.selectedIndex, false);
        }
    }

    public void up() {
        --this.selectedIndex;
        if (this.scrollDistance > (float)(this.slotHeight * this.selectedIndex)) {
            this.scrollDistance -= (float)this.slotHeight;
        }
        if (this.selectedIndex < 0) {
            this.selectedIndex = this.presets.size() - 1;
            this.scrollDistance = this.slotHeight * this.presets.size();
        }
        if (this.presets.get(this.selectedIndex).locked()) {
            this.up();
        } else {
            this.elementClicked(this.selectedIndex, false);
        }
    }

    @Override
    protected boolean isSelected(int index) {
        return index == this.selectedIndex;
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        String text = this.presets.get(slotIdx).getName();
        this.fontRenderer.func_175063_a(text, (float)(this.left + 3), (float)(slotTop + 4), 0xFFFFFF);
        if (this.presets.get(slotIdx).locked()) {
            this.fontRenderer.func_175063_a("X", (float)(this.right - 15), (float)(slotTop + 4), 0xFF0000);
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        if (this.presets.size() < 2) {
            return;
        }
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.drawBackground();
        boolean isHovering = mouseX >= this.left && mouseX <= this.left + this.listWidth && mouseY >= this.top && mouseY <= this.bottom;
        int listLength = this.getSize();
        int scrollBarWidth = 6;
        int scrollBarRight = this.left + this.listWidth;
        int scrollBarLeft = scrollBarRight - scrollBarWidth;
        int entryLeft = this.left;
        int entryRight = scrollBarLeft - 1;
        int viewHeight = this.bottom - this.top;
        int border = 4;
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialMouseClickY == -1.0f) {
                if (isHovering) {
                    int mouseListY = mouseY - this.top - this.headerHeight + (int)this.scrollDistance - border;
                    int slotIndex = mouseListY / this.slotHeight;
                    if (mouseX >= entryLeft && mouseX <= entryRight && slotIndex >= 0 && mouseListY >= 0 && slotIndex < listLength) {
                        this.elementClicked(slotIndex, slotIndex == this.selectedIndex && System.currentTimeMillis() - this.lastClickTime < 250L);
                        this.selectedIndex = slotIndex;
                        this.lastClickTime = System.currentTimeMillis();
                    } else if (mouseX >= entryLeft && mouseX <= entryRight && mouseListY < 0) {
                        this.clickHeader(mouseX - entryLeft, mouseY - this.top + (int)this.scrollDistance - border);
                    }
                    if (mouseX >= scrollBarLeft && mouseX <= scrollBarRight) {
                        int var13;
                        this.scrollFactor = -1.0f;
                        int scrollHeight = this.getContentHeight() - viewHeight - border;
                        if (scrollHeight < 1) {
                            scrollHeight = 1;
                        }
                        if ((var13 = (int)((float)(viewHeight * viewHeight) / (float)this.getContentHeight())) < 32) {
                            var13 = 32;
                        }
                        if (var13 > viewHeight - border * 2) {
                            var13 = viewHeight - border * 2;
                        }
                        this.scrollFactor /= (float)(viewHeight - var13) / (float)scrollHeight;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.initialMouseClickY = mouseY;
                } else {
                    this.initialMouseClickY = -2.0f;
                }
            } else if (this.initialMouseClickY >= 0.0f) {
                this.scrollDistance -= ((float)mouseY - this.initialMouseClickY) * this.scrollFactor;
                this.initialMouseClickY = mouseY;
            }
        } else {
            this.initialMouseClickY = -1.0f;
        }
        this.applyScrollLimits();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldr = tess.func_178180_c();
        ScaledResolution res = new ScaledResolution(this.client);
        double scaleW = (double)this.client.field_71443_c / res.func_78327_c();
        double scaleH = (double)this.client.field_71440_d / res.func_78324_d();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scaleW)), (int)((int)((double)this.client.field_71440_d - (double)this.bottom * scaleH)), (int)((int)((double)this.listWidth * scaleW)), (int)((int)((double)viewHeight * scaleH)));
        this.drawGradientRect(this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        int baseY = this.top + border - (int)this.scrollDistance;
        if (this.hasHeader) {
            this.drawHeader(entryRight, baseY, tess);
        }
        for (int slotIdx = 0; slotIdx < listLength; ++slotIdx) {
            int slotTop = baseY + slotIdx * this.slotHeight + this.headerHeight;
            int slotBuffer = this.slotHeight - border;
            if (slotTop > this.bottom || slotTop + slotBuffer < this.top) continue;
            if (this.highlightSelected && this.isSelected(slotIdx)) {
                int min = this.left;
                int max = entryRight;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179090_x();
                worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                worldr.func_181662_b((double)min, (double)(slotTop + slotBuffer + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                worldr.func_181662_b((double)max, (double)(slotTop + slotBuffer + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                worldr.func_181662_b((double)max, (double)(slotTop - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                worldr.func_181662_b((double)min, (double)(slotTop - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                worldr.func_181662_b((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                worldr.func_181662_b((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                worldr.func_181662_b((double)(max - 1), (double)(slotTop - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                worldr.func_181662_b((double)(min + 1), (double)(slotTop - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179098_w();
            }
            this.drawSlot(slotIdx, entryRight, slotTop, slotBuffer, tess);
        }
        GlStateManager.func_179097_i();
        int extraHeight = this.getContentHeight() + border - viewHeight;
        if (extraHeight > 0) {
            int barTop;
            int height = viewHeight * viewHeight / this.getContentHeight();
            if (height < 32) {
                height = 32;
            }
            if (height > viewHeight - border * 2) {
                height = viewHeight - border * 2;
            }
            if ((barTop = (int)this.scrollDistance * (viewHeight - height) / extraHeight + this.top) < this.top) {
                barTop = this.top;
            }
            GlStateManager.func_179090_x();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)scrollBarLeft, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarLeft, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)scrollBarLeft, (double)(barTop + height), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)(barTop + height), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarRight, (double)barTop, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarLeft, (double)barTop, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            tess.func_78381_a();
            worldr.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            worldr.func_181662_b((double)scrollBarLeft, (double)(barTop + height - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            worldr.func_181662_b((double)(scrollBarRight - 1), (double)(barTop + height - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            worldr.func_181662_b((double)(scrollBarRight - 1), (double)barTop, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            worldr.func_181662_b((double)scrollBarLeft, (double)barTop, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            tess.func_78381_a();
        }
        this.drawScreen(mouseX, mouseY);
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GL11.glDisable((int)3089);
    }
}

