/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.client.renderer;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.IRenderHandler;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/WeatherRenderer", classExplaination="A customizeable weather renderer. Can force the appearance of rain/snow. Can be accessed by calling `overrideWeatherRenderer()`.")
public class TopographyWeatherRenderer
extends IRenderHandler {
    private boolean persistentSnow = false;
    private boolean persistentRain = false;
    private boolean persistentClear = false;
    private boolean overrideBiomeRestrictions = false;
    private boolean replaceRainWithSnow = false;
    private boolean replaceSnowWithRain = false;
    private float persistentStrength = -1.0f;
    private ResourceLocation snowTexture = EntityRenderer.field_110923_r;
    private ResourceLocation rainTexture = EntityRenderer.field_110924_q;
    private float redSnow = 1.0f;
    private float greenSnow = 1.0f;
    private float blueSnow = 1.0f;
    private float redRain = 1.0f;
    private float greenRain = 1.0f;
    private float blueRain = 1.0f;

    @ScriptMethodDocumentation(usage="", notes="Makes all rain render as snow.")
    public void replaceRainWithSnow() {
        this.replaceRainWithSnow = true;
    }

    @ScriptMethodDocumentation(usage="", notes="Makes all snow render as rain.")
    public void replaceSnowWithRain() {
        this.replaceRainWithSnow = true;
    }

    @ScriptMethodDocumentation(usage="", notes="Allows weather to render in biomes which normally do not allow it, such as the desert.")
    public void overrideBiomeRestrictions() {
        this.overrideBiomeRestrictions = true;
    }

    @ScriptMethodDocumentation(usage="", notes="Makes snowfall permanently render, regardless of whether or not it's actually snowing, or if the biome allows snow.")
    public void persistentSnow() {
        this.persistentSnow = true;
        this.persistentStrength = 100.0f;
    }

    public void persistentSnow(float strength) {
        this.persistentSnow = true;
        this.persistentStrength = strength;
    }

    @ScriptMethodDocumentation(usage="", notes="Makes rainfall permanently render, regardless of whether or not it's actually raining, or if the biome allows rain.")
    public void persistentRain() {
        this.persistentRain = true;
        this.persistentStrength = 100.0f;
    }

    public void persistentRain(float strength) {
        this.persistentRain = true;
        this.persistentStrength = strength;
    }

    public void persistentClear() {
        this.persistentClear = true;
    }

    @ScriptMethodDocumentation(args="int", usage="color hex", notes="Sets the color to render rain.")
    public void setRainColor(int color) {
        this.redRain = (float)(color >> 16 & 0xFF) / 255.0f;
        this.greenRain = (float)(color >> 8 & 0xFF) / 255.0f;
        this.blueRain = (float)(color & 0xFF) / 255.0f;
    }

    @ScriptMethodDocumentation(args="int", usage="color hex", notes="Sets the color to render snow.")
    public void setSnowColor(int color) {
        this.redSnow = (float)(color >> 16 & 0xFF) / 255.0f;
        this.greenSnow = (float)(color >> 8 & 0xFF) / 255.0f;
        this.blueSnow = (float)(color & 0xFF) / 255.0f;
    }

    @ScriptMethodDocumentation(args="String", usage="texture resource location", notes="Sets the texture to use for rendering rain.")
    public void setRainTexture(String string) {
        this.rainTexture = new ResourceLocation(string);
    }

    @ScriptMethodDocumentation(args="String", usage="texture resource location", notes="Sets the texture to use for rendering snow.")
    public void setSnowTexture(String string) {
        this.snowTexture = new ResourceLocation(string);
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        float f = mc.field_71441_e.func_72867_j(partialTicks);
        if (this.persistentStrength >= 0.0f) {
            f = this.persistentStrength;
        }
        if (!this.persistentClear && f > 0.0f) {
            mc.field_71460_t.func_180436_i();
            Entity entity = mc.func_175606_aa();
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            int l = MathHelper.func_76128_c((double)d1);
            int i1 = 5;
            if (mc.field_71474_y.field_74347_j) {
                i1 = 10;
            }
            int j1 = -1;
            float f1 = (float)mc.field_71460_t.field_78529_t + partialTicks;
            bufferbuilder.func_178969_c(-d0, -d1, -d2);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)mc.field_71460_t.field_175076_N[i2] * 0.5;
                    double d4 = (double)mc.field_71460_t.field_175077_O[i2] * 0.5;
                    blockpos$mutableblockpos.func_181079_c(l1, 0, k1);
                    Biome biome = world.func_180494_b((BlockPos)blockpos$mutableblockpos);
                    if (!this.overrideBiomeRestrictions && !biome.func_76738_d() && !biome.func_76746_c() && !this.persistentSnow && !this.persistentRain) continue;
                    int j2 = world.func_175725_q((BlockPos)blockpos$mutableblockpos).func_177956_o();
                    int k2 = j - i1;
                    int l2 = j + i1;
                    if (k2 < j2) {
                        k2 = j2;
                    }
                    if (l2 < j2) {
                        l2 = j2;
                    }
                    int i3 = j2;
                    if (j2 < l) {
                        i3 = l;
                    }
                    if (k2 == l2) continue;
                    mc.field_71460_t.field_78537_ab.setSeed(l1 * l1 * 3121 + l1 * 45238971 ^ k1 * k1 * 418711 + k1 * 13761);
                    blockpos$mutableblockpos.func_181079_c(l1, k2, k1);
                    float f2 = biome.func_180626_a((BlockPos)blockpos$mutableblockpos);
                    if (this.replaceSnowWithRain || this.persistentRain || world.func_72959_q().func_76939_a(f2, j2) >= 0.15f && !this.persistentSnow && !this.replaceRainWithSnow) {
                        if (j1 != 0) {
                            if (j1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            j1 = 0;
                            mc.func_110434_K().func_110577_a(this.rainTexture);
                            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        double d5 = -((double)(mc.field_71460_t.field_78529_t + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + mc.field_71460_t.field_78537_ab.nextDouble());
                        double d6 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                        double d7 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                        float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                        float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                        int j3 = world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
                        int k3 = j3 >> 16 & 0xFFFF;
                        int l3 = j3 & 0xFFFF;
                        bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(this.redRain, this.greenRain, this.blueRain, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(this.redRain, this.greenRain, this.blueRain, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)l2 * 0.25 + d5).func_181666_a(this.redRain, this.greenRain, this.blueRain, f4).func_187314_a(k3, l3).func_181675_d();
                        bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)l2 * 0.25 + d5).func_181666_a(this.redRain, this.greenRain, this.blueRain, f4).func_187314_a(k3, l3).func_181675_d();
                        continue;
                    }
                    if (j1 != 1) {
                        if (j1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        j1 = 1;
                        mc.func_110434_K().func_110577_a(this.snowTexture);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    double d8 = -((float)(mc.field_71460_t.field_78529_t & 0x1FF) + partialTicks) / 512.0f;
                    double d9 = mc.field_71460_t.field_78537_ab.nextDouble() + (double)f1 * 0.01 * (double)((float)mc.field_71460_t.field_78537_ab.nextGaussian());
                    double d10 = mc.field_71460_t.field_78537_ab.nextDouble() + (double)(f1 * (float)mc.field_71460_t.field_78537_ab.nextGaussian()) * 0.001;
                    double d11 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                    double d12 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                    float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)i1;
                    float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                    int i4 = (world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0) * 3 + 0xF000F0) / 4;
                    int j4 = i4 >> 16 & 0xFFFF;
                    int k4 = i4 & 0xFFFF;
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(this.redSnow, this.greenSnow, this.blueSnow, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(this.redSnow, this.greenSnow, this.blueSnow, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(this.redSnow, this.greenSnow, this.blueSnow, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(this.redSnow, this.greenSnow, this.blueSnow, f5).func_187314_a(j4, k4).func_181675_d();
                }
            }
            if (j1 >= 0) {
                tessellator.func_78381_a();
            }
            bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            mc.field_71460_t.func_175072_h();
        }
    }
}

