/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.command;

import com.bloodnbonesgaming.topography.config.ConfigPreset;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import com.bloodnbonesgaming.topography.event.EventSubscriber;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.server.permission.PermissionAPI;

public class Spawn
extends CommandBase {
    final List<String> aliases = new ArrayList<String>();

    public String func_71517_b() {
        return "spawn";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Use /topography spawn [player]";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player;
        if (args.length == 0) {
            if (!(sender instanceof EntityPlayerMP)) throw new CommandException("Command must have a target argument if not run by a player.", new Object[0]);
            player = (EntityPlayerMP)sender;
        } else {
            player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            if (player == null) {
                throw new CommandException("The entity selected (%s) is not a valid player.", new Object[]{args[0]});
            }
        }
        WorldServer world = DimensionManager.getWorld((int)0);
        ConfigurationManager manager = ConfigurationManager.getInstance();
        if (manager == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
        ConfigPreset preset = manager.getPreset();
        if (preset == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
        DimensionDefinition dimensionDef = preset.getDefinition(world.field_73011_w.getDimension());
        if (dimensionDef == null) {
            throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
        }
        player.func_145747_a((ITextComponent)new TextComponentString("Teleporting you to world spawn."));
        this.teleportPlayer(player, 0, Spawn.getTopSolidOrLiquidBlock((World)world, world.func_175694_M()));
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return !(sender instanceof EntityPlayerMP) || PermissionAPI.hasPermission((EntityPlayer)((EntityPlayerMP)sender), (String)"topography.world.spawn");
    }

    private void teleportPlayer(EntityPlayerMP player, int dimension, BlockPos pos) {
        if (player.field_70170_p.field_73011_w.getDimension() != dimension) {
            player.changeDimension(0, (ITeleporter)new EventSubscriber.ReTeleporter(pos));
        } else {
            player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
    }

    public static BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && !(state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76230_c()) {
            blockpos = blockpos1;
        }
        return blockpos;
    }
}

