/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.command.island;

import com.bloodnbonesgaming.topography.IOHelper;
import com.bloodnbonesgaming.topography.StructureHelper;
import com.bloodnbonesgaming.topography.command.island.IslandNew;
import com.bloodnbonesgaming.topography.config.ConfigPreset;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import com.bloodnbonesgaming.topography.event.EventSubscriber;
import com.bloodnbonesgaming.topography.util.SpawnStructure;
import com.bloodnbonesgaming.topography.util.capabilities.ITopographyPlayerData;
import com.bloodnbonesgaming.topography.util.capabilities.TopographyPlayerData;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import com.bloodnbonesgaming.topography.world.generator.SkyIslandGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.server.permission.PermissionAPI;

public class IslandAccept
extends CommandBase {
    final List<String> aliases = new ArrayList<String>();
    public static final Map<String, Map<String, Long>> identifiers = new HashMap<String, Map<String, Long>>();

    public String func_71517_b() {
        return "accept";
    }

    public String func_71518_a(ICommandSender sender) {
        return "This isn't meant to be used except from clickable chat.";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 0) {
            Map<String, Long> inner;
            EntityPlayerMP inviter = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            if (inviter == null) {
                throw new CommandException("The entity selected (%s) is not valid.", new Object[]{args[0]});
            }
            EntityPlayerMP invitee = (EntityPlayerMP)sender;
            if (identifiers.containsKey(inviter.getDisplayNameString()) && (inner = identifiers.get(inviter.getDisplayNameString())).containsKey(invitee.getDisplayNameString()) && inner.get(invitee.getDisplayNameString()).longValue() == Long.valueOf(args[1]).longValue()) {
                ITopographyPlayerData inviterData;
                inner.remove(invitee.getDisplayNameString());
                if (inner.isEmpty()) {
                    identifiers.remove(inviter.getDisplayNameString());
                }
                if ((inviterData = (ITopographyPlayerData)inviter.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null)) != null) {
                    DimensionDefinition dimensionDef;
                    ConfigPreset preset;
                    WorldServer world = server.func_71218_a(0);
                    ConfigurationManager manager = ConfigurationManager.getInstance();
                    if (manager != null && (preset = manager.getPreset()) != null && (dimensionDef = preset.getDefinition(world.field_73011_w.getDimension())) != null) {
                        SpawnStructure structure = dimensionDef.getSpawnStructure();
                        if (structure != null) {
                            BlockPos spawn;
                            Template template = IOHelper.loadStructureTemplate(structure.getStructure());
                            if (template != null && (spawn = StructureHelper.getSpawn(template)) != null) {
                                spawn = spawn.func_177982_a(inviterData.getIslandX(), structure.getHeight(), inviterData.getIslandZ());
                                invitee.func_180473_a(spawn, true);
                                invitee.func_70634_a((double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p());
                                ITopographyPlayerData inviteeData = (ITopographyPlayerData)invitee.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
                                inviteeData.setIsland(inviterData.getIslandX(), inviterData.getIslandZ());
                                if (invitee.field_70170_p.field_73011_w.getDimension() != 0) {
                                    invitee.changeDimension(0, (ITeleporter)new EventSubscriber.ReTeleporter(spawn.func_177984_a()));
                                }
                                inviter.func_145747_a((ITextComponent)new TextComponentString(invitee.getDisplayNameString() + " has accepted your invite."));
                                return;
                            }
                        } else {
                            for (IGenerator generator : dimensionDef.getGenerators()) {
                                Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> islands;
                                Iterator<Map.Entry<BlockPos, SkyIslandType>> positions;
                                if (!(generator instanceof SkyIslandGenerator)) continue;
                                if (inviterData.getIslandX() != 0 || inviterData.getIslandZ() != 0) {
                                    sender.func_145747_a((ITextComponent)new TextComponentString("Inviter has a sky island."));
                                    BlockPos pos = new BlockPos(inviterData.getIslandX(), 0, inviterData.getIslandZ());
                                    BlockPos topBlock = IslandNew.getTopSolidOrLiquidBlock((World)world, pos);
                                    invitee.func_180473_a(topBlock, true);
                                    invitee.func_70634_a((double)topBlock.func_177958_n(), (double)topBlock.func_177956_o(), (double)topBlock.func_177952_p());
                                    ITopographyPlayerData inviteeData = (ITopographyPlayerData)invitee.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
                                    inviteeData.setIsland(inviterData.getIslandX(), inviterData.getIslandZ());
                                    if (invitee.field_70170_p.field_73011_w.getDimension() != 0) {
                                        invitee.changeDimension(0, (ITeleporter)new EventSubscriber.ReTeleporter(topBlock.func_177984_a()));
                                    }
                                    inviter.func_145747_a((ITextComponent)new TextComponentString(invitee.getDisplayNameString() + " has accepted your invite."));
                                    return;
                                }
                                sender.func_145747_a((ITextComponent)new TextComponentString("Inviter does not have a sky island."));
                                SkyIslandGenerator islandGenerator = (SkyIslandGenerator)generator;
                                Iterator<Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>>> iterator = islandGenerator.getIslandPositions(world.func_72905_C(), 0, 0).entrySet().iterator();
                                if (!iterator.hasNext() || !(positions = (islands = iterator.next()).getValue().entrySet().iterator()).hasNext()) break;
                                Map.Entry<BlockPos, SkyIslandType> island = positions.next();
                                BlockPos pos = island.getKey();
                                BlockPos topBlock = IslandNew.getTopSolidOrLiquidBlock((World)world, pos);
                                invitee.func_180473_a(topBlock, true);
                                invitee.func_70634_a((double)topBlock.func_177958_n(), (double)topBlock.func_177956_o(), (double)topBlock.func_177952_p());
                                ITopographyPlayerData inviteeData = (ITopographyPlayerData)invitee.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
                                inviteeData.setIsland(inviterData.getIslandX(), inviterData.getIslandZ());
                                if (invitee.field_70170_p.field_73011_w.getDimension() != 0) {
                                    invitee.changeDimension(0, (ITeleporter)new EventSubscriber.ReTeleporter(topBlock.func_177984_a()));
                                }
                                inviter.func_145747_a((ITextComponent)new TextComponentString(invitee.getDisplayNameString() + " has accepted your invite."));
                                return;
                            }
                        }
                    }
                }
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("This invite is not valid."));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        return null;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return !(sender instanceof EntityPlayerMP) || PermissionAPI.hasPermission((EntityPlayer)((EntityPlayerMP)sender), (String)"topography.island.accept");
    }
}

