/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.command.island;

import com.bloodnbonesgaming.topography.IOHelper;
import com.bloodnbonesgaming.topography.StructureHelper;
import com.bloodnbonesgaming.topography.Topography;
import com.bloodnbonesgaming.topography.config.ConfigPreset;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import com.bloodnbonesgaming.topography.event.EventSubscriber;
import com.bloodnbonesgaming.topography.util.SpawnStructure;
import com.bloodnbonesgaming.topography.util.capabilities.ITopographyPlayerData;
import com.bloodnbonesgaming.topography.util.capabilities.TopographyPlayerData;
import com.bloodnbonesgaming.topography.world.WorldSavedDataTopography;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import com.bloodnbonesgaming.topography.world.generator.SkyIslandGenerator;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.server.permission.PermissionAPI;

public class IslandHome
extends CommandBase {
    final List<String> aliases = new ArrayList<String>();

    public IslandHome() {
        this.aliases.add("home");
    }

    public String func_71517_b() {
        return "home";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Use /topography island home [player]";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player;
        if (args.length == 0) {
            if (!(sender instanceof EntityPlayerMP)) throw new CommandException("Command must have a target argument if not run by a player.", new Object[0]);
            player = (EntityPlayerMP)sender;
        } else {
            player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            if (player == null) {
                throw new CommandException("The entity selected (%s) is not a valid player.", new Object[]{args[0]});
            }
        }
        WorldServer world = DimensionManager.getWorld((int)0);
        ConfigurationManager manager = ConfigurationManager.getInstance();
        if (manager == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
        ConfigPreset preset = manager.getPreset();
        if (preset == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
        DimensionDefinition dimensionDef = preset.getDefinition(world.field_73011_w.getDimension());
        if (dimensionDef == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
        ITopographyPlayerData data = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
        if (data == null || data.getIslandX() == 0 && data.getIslandZ() == 0) {
            if (dimensionDef.getSpawnStructure() != null) {
                player.func_145747_a((ITextComponent)new TextComponentString("Looks like you don't have an island. Let's make you one! This may take a few seconds."));
                BlockPos pos = this.findNextIsland((EntityPlayer)player, dimensionDef);
                this.spawnIslands(player, pos.func_177958_n(), pos.func_177952_p());
                return;
            }
            for (IGenerator generator : dimensionDef.getGenerators()) {
                if (!(generator instanceof SkyIslandGenerator)) continue;
                player.func_145747_a((ITextComponent)new TextComponentString("Looks like you don't have an island. Let's find you one! This may take a few seconds."));
                BlockPos pos = this.findNextIsland((EntityPlayer)player, dimensionDef);
                this.setPlayerSpawn(player, pos);
                return;
            }
            throw new CommandException("This preset does not appear to have spawn structures or sky islands islands in dimension 0.", new Object[0]);
        }
        this.teleportPlayerHome(player, world, dimensionDef);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return !(sender instanceof EntityPlayerMP) || PermissionAPI.hasPermission((EntityPlayer)((EntityPlayerMP)sender), (String)"topography.island.home");
    }

    private void teleportPlayerHome(EntityPlayerMP player, WorldServer world, DimensionDefinition definition) throws CommandException {
        BlockPos blockpos = player.getBedLocation(0);
        boolean forced = player.isSpawnForced(0);
        if (blockpos != null && (blockpos = EntityPlayer.func_180467_a((World)world, (BlockPos)blockpos, (boolean)forced)) != null) {
            player.func_145747_a((ITextComponent)new TextComponentString("Teleporting you to your spawn."));
            this.teleportPlayer(player, 0, blockpos);
            return;
        }
        SpawnStructure structure = definition.getSpawnStructure();
        if (structure != null) {
            BlockPos spawn;
            Template template = IOHelper.loadStructureTemplate(structure.getStructure());
            if (template != null && (spawn = StructureHelper.getSpawn(template)) != null) {
                ITopographyPlayerData data = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
                spawn = spawn.func_177982_a(data.getIslandX(), 0, data.getIslandZ());
                blockpos = spawn.func_177982_a(0, structure.getHeight(), 0);
                player.func_145747_a((ITextComponent)new TextComponentString("Teleporting you to your structure."));
                this.teleportPlayer(player, 0, blockpos);
                return;
            }
        } else {
            for (IGenerator generator : definition.getGenerators()) {
                if (!(generator instanceof SkyIslandGenerator)) continue;
                ITopographyPlayerData data = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
                blockpos = new BlockPos(data.getIslandX(), 0, data.getIslandZ());
                blockpos = IslandHome.getTopSolidOrLiquidBlock((World)world, blockpos).func_177984_a();
                player.func_145747_a((ITextComponent)new TextComponentString("Teleporting you to your sky island."));
                this.teleportPlayer(player, 0, blockpos);
                return;
            }
        }
        throw new CommandException("This preset does not appear to have spawn structures or islands in dimension 0.", new Object[0]);
    }

    private void teleportPlayer(EntityPlayerMP player, int dimension, BlockPos pos) {
        if (player.field_70170_p.field_73011_w.getDimension() != dimension) {
            player.changeDimension(0, (ITeleporter)new EventSubscriber.ReTeleporter(pos));
        } else {
            player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
    }

    private BlockPos findNextIsland(EntityPlayer player, DimensionDefinition definition) throws CommandException {
        Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> islands;
        Iterator<Map.Entry<BlockPos, SkyIslandType>> positions;
        Iterator<Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>>> iterator;
        WorldServer world = DimensionManager.getWorld((int)0);
        SkyIslandGenerator skyIslands = null;
        int x = 0;
        int z = 0;
        for (IGenerator generator : definition.getGenerators()) {
            if (!(generator instanceof SkyIslandGenerator)) continue;
            skyIslands = (SkyIslandGenerator)generator;
            break;
        }
        if (definition.getSpawnStructure() != null || skyIslands != null) {
            int islandIndex = WorldSavedDataTopography.getIslandIndex((World)world);
            int index = 0;
            int ring = 0;
            int posInRing = 0;
            for (int i = 1; i < 10000; ++i) {
                if ((index += i * 8) < islandIndex) continue;
                ring = i;
                posInRing = islandIndex - (index - i * 8);
                break;
            }
            int ringSideLength = (ring - 1) * 2 + 1;
            x = ring;
            z = ring + 1;
            for (int i = 0; i <= (ringSideLength + 1) * 4; ++i) {
                if (i <= ringSideLength + 1) {
                    --z;
                } else if (i <= (ringSideLength + 1) * 2) {
                    --x;
                } else if (i <= (ringSideLength + 1) * 3) {
                    ++z;
                } else {
                    ++x;
                }
                if (i == posInRing) break;
            }
            WorldSavedDataTopography.saveIslandIndex(++islandIndex, (World)world);
        }
        if (definition.getSpawnStructure() != null) {
            return new BlockPos(x * definition.getSpawnStructureSpacing(), 0, z * definition.getSpawnStructureSpacing());
        }
        if (skyIslands != null && (iterator = skyIslands.getIslandPositions(world.func_72905_C(), x * skyIslands.getRegionSize(), z * skyIslands.getRegionSize()).entrySet().iterator()).hasNext() && (positions = (islands = iterator.next()).getValue().entrySet().iterator()).hasNext()) {
            Map.Entry<BlockPos, SkyIslandType> island = positions.next();
            BlockPos pos = island.getKey();
            BlockPos topBlock = IslandHome.getTopSolidOrLiquidBlock((World)world, pos);
            return new BlockPos((Vec3i)topBlock.func_177984_a());
        }
        throw new CommandException("This preset does not have spawn structures or sky islands.", new Object[0]);
    }

    private void spawnIslands(EntityPlayerMP player, int xOffset, int zOffset) {
        JsonParser parser;
        JsonElement element;
        WorldServer overworld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        String settings = overworld.func_72912_H().func_82571_y();
        if (!settings.isEmpty() && (element = (parser = new JsonParser()).parse(settings)).isJsonObject() && ((JsonObject)element).has("Topography-Preset")) {
            player.func_145747_a((ITextComponent)new TextComponentString("This may take a few seconds. Please wait."));
            for (int dimension : ConfigurationManager.getInstance().getPreset().getDimensions()) {
                DimensionDefinition definition = ConfigurationManager.getInstance().getPreset().getDefinition(dimension);
                SpawnStructure structure = definition.getSpawnStructure();
                if (structure == null) continue;
                WorldServer dimWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
                Template template = IOHelper.loadStructureTemplate(structure.getStructure());
                if (template == null) continue;
                int preloadArea = template.func_186259_a().func_177958_n();
                preloadArea = template.func_186259_a().func_177952_p() > preloadArea ? template.func_186259_a().func_177952_p() : preloadArea;
                preloadArea /= 16;
                Topography.instance.getLog().info((Object)("Preloading " + ((preloadArea += 2) * 2 + 1) * (preloadArea * 2 + 1) + " chunks for spawn structure in dimension " + dimension));
                for (int x = -preloadArea; x < preloadArea; ++x) {
                    for (int z = -preloadArea; z < preloadArea; ++z) {
                        dimWorld.func_72863_F().func_186025_d(x + xOffset, z + zOffset);
                    }
                }
                BlockPos structurePos = new BlockPos(xOffset * 16, structure.getHeight(), zOffset * 16);
                Topography.instance.getLog().info((Object)("Spawning structure for dimension " + dimension + " at " + structurePos.toString()));
                template.func_189962_a((World)dimWorld, structurePos, new PlacementSettings(), 2);
                if (dimension != 0) continue;
                BlockPos spawn = StructureHelper.getSpawn(template);
                spawn = spawn.func_177982_a(xOffset * 16, structure.getHeight(), zOffset * 16);
                player.func_180473_a(spawn, true);
                player.func_70634_a((double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p());
                ITopographyPlayerData data = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
                if (data == null) continue;
                data.setIsland(structurePos.func_177958_n(), structurePos.func_177952_p());
            }
            player.func_145747_a((ITextComponent)new TextComponentString("Finished spawning structures."));
        }
    }

    private void setPlayerSpawn(EntityPlayerMP player, BlockPos pos) {
        BlockPos spawn = pos.func_177963_a(0.5, 0.0, 0.5);
        player.func_180473_a(spawn, true);
        player.func_70634_a((double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p());
        ITopographyPlayerData data = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
        if (data != null) {
            player.func_145747_a((ITextComponent)new TextComponentString("Setting player island."));
            data.setIsland(pos.func_177958_n(), pos.func_177952_p());
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("Player has no data!"));
        }
    }

    public static BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && !(state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76230_c()) {
            blockpos = blockpos1;
        }
        return blockpos;
    }
}

