/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.command.island;

import com.bloodnbonesgaming.topography.IOHelper;
import com.bloodnbonesgaming.topography.StructureHelper;
import com.bloodnbonesgaming.topography.config.ConfigPreset;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import com.bloodnbonesgaming.topography.util.SpawnStructure;
import com.bloodnbonesgaming.topography.util.capabilities.ITopographyPlayerData;
import com.bloodnbonesgaming.topography.util.capabilities.TopographyPlayerData;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import com.bloodnbonesgaming.topography.world.generator.SkyIslandGenerator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.server.permission.PermissionAPI;

public class IslandInfo
extends CommandBase {
    final List<String> aliases = new ArrayList<String>();

    public String func_71517_b() {
        return "info";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Use /topography island info [player]";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player;
        if (args.length == 0) {
            if (!(sender instanceof EntityPlayerMP)) throw new CommandException("Command must have a target argument if not run by a player.", new Object[0]);
            player = (EntityPlayerMP)sender;
        } else {
            player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            if (player == null) {
                throw new CommandException("The entity selected (%s) is not a valid player.", new Object[]{args[0]});
            }
        }
        WorldServer world = DimensionManager.getWorld((int)0);
        ConfigurationManager manager = ConfigurationManager.getInstance();
        if (manager == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
        ConfigPreset preset = manager.getPreset();
        if (preset == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
        DimensionDefinition dimensionDef = preset.getDefinition(world.field_73011_w.getDimension());
        if (dimensionDef == null) throw new CommandException("Command can only be used if the overworld is created using Topography.", new Object[0]);
        ITopographyPlayerData data = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
        if (data == null) throw new CommandException("No island data found.", new Object[0]);
        if (data.getIslandX() == 0 && data.getIslandZ() == 0) {
            throw new CommandException("Player island is 0, 0.", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(this.findPlayerIsland(player, world, dimensionDef).toString()));
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return !(sender instanceof EntityPlayerMP) || PermissionAPI.hasPermission((EntityPlayer)((EntityPlayerMP)sender), (String)"topography.island.info");
    }

    private BlockPos findPlayerIsland(EntityPlayerMP player, WorldServer world, DimensionDefinition definition) throws CommandException {
        SpawnStructure structure = definition.getSpawnStructure();
        if (structure != null) {
            BlockPos spawn;
            Template template = IOHelper.loadStructureTemplate(structure.getStructure());
            if (template != null && (spawn = StructureHelper.getSpawn(template)) != null) {
                ITopographyPlayerData data = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
                spawn = spawn.func_177982_a(data.getIslandX(), 0, data.getIslandZ());
                BlockPos blockpos = spawn.func_177982_a(0, structure.getHeight(), 0);
                return blockpos;
            }
        } else {
            for (IGenerator generator : definition.getGenerators()) {
                if (!(generator instanceof SkyIslandGenerator)) continue;
                ITopographyPlayerData data = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
                BlockPos blockpos = new BlockPos(data.getIslandX(), 0, data.getIslandZ());
                blockpos = IslandInfo.getTopSolidOrLiquidBlock((World)world, blockpos).func_177984_a();
                return blockpos;
            }
        }
        throw new CommandException("This world does not appear to have spawn structures or sky islands.", new Object[0]);
    }

    public static BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && !(state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76230_c()) {
            blockpos = blockpos1;
        }
        return blockpos;
    }
}

