/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.command.island;

import com.bloodnbonesgaming.topography.IOHelper;
import com.bloodnbonesgaming.topography.StructureHelper;
import com.bloodnbonesgaming.topography.Topography;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import com.bloodnbonesgaming.topography.util.SpawnStructure;
import com.bloodnbonesgaming.topography.util.capabilities.ITopographyPlayerData;
import com.bloodnbonesgaming.topography.util.capabilities.TopographyPlayerData;
import com.bloodnbonesgaming.topography.world.WorldSavedDataTopography;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import com.bloodnbonesgaming.topography.world.generator.SkyIslandGenerator;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.server.permission.PermissionAPI;

public class IslandNew
extends CommandBase {
    final List<String> aliases = new ArrayList<String>();

    public String func_71517_b() {
        return "new";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Use /topography island new <player>";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 0) {
            Entity entity = IslandNew.func_184884_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0], EntityPlayerMP.class);
            if (!IslandNew.checkEntity(entity)) {
                throw new CommandException("The entity selected (%s) is not valid.", new Object[]{entity.func_70005_c_()});
            }
            if (entity.field_70170_p.field_73011_w.getDimension() != 0) {
                throw new CommandException("This command may only be run in dimension 0.", new Object[0]);
            }
            WorldServer world = DimensionManager.getWorld((int)0);
            DimensionDefinition definition = ConfigurationManager.getInstance().getPreset().getDefinition(world.field_73011_w.getDimension());
            if (definition.getSpawnStructure() != null) {
                BlockPos pos = this.findNextIsland((EntityPlayer)((EntityPlayerMP)entity), definition);
                this.spawnIslands((EntityPlayerMP)entity, pos.func_177958_n(), pos.func_177952_p());
                return;
            }
            for (IGenerator generator : definition.getGenerators()) {
                if (!(generator instanceof SkyIslandGenerator)) continue;
                BlockPos pos = this.findNextIsland((EntityPlayer)((EntityPlayerMP)entity), definition);
                this.setPlayerSpawn((EntityPlayerMP)entity, pos);
                return;
            }
            throw new CommandException("This preset does not have spawn structures or sky islands.", new Object[0]);
        }
        throw new SyntaxErrorException(this.func_71518_a(sender), new Object[0]);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public int func_82362_a() {
        return 0;
    }

    private BlockPos findNextIsland(EntityPlayer player, DimensionDefinition definition) throws CommandException {
        Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> islands;
        Iterator<Map.Entry<BlockPos, SkyIslandType>> positions;
        Iterator<Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>>> iterator;
        WorldServer world = DimensionManager.getWorld((int)0);
        SkyIslandGenerator skyIslands = null;
        int x = 0;
        int z = 0;
        for (IGenerator generator : definition.getGenerators()) {
            if (!(generator instanceof SkyIslandGenerator)) continue;
            skyIslands = (SkyIslandGenerator)generator;
            break;
        }
        if (definition.getSpawnStructure() != null || skyIslands != null) {
            int islandIndex = WorldSavedDataTopography.getIslandIndex((World)world);
            int index = 0;
            int ring = 0;
            int posInRing = 0;
            for (int i = 1; i < 10000; ++i) {
                if ((index += i * 8) < islandIndex) continue;
                ring = i;
                posInRing = islandIndex - (index - i * 8);
                break;
            }
            int ringSideLength = (ring - 1) * 2 + 1;
            x = ring;
            z = ring + 1;
            for (int i = 0; i <= (ringSideLength + 1) * 4; ++i) {
                if (i <= ringSideLength + 1) {
                    --z;
                } else if (i <= (ringSideLength + 1) * 2) {
                    --x;
                } else if (i <= (ringSideLength + 1) * 3) {
                    ++z;
                } else {
                    ++x;
                }
                if (i == posInRing) break;
            }
            WorldSavedDataTopography.saveIslandIndex(++islandIndex, (World)world);
        }
        if (definition.getSpawnStructure() != null) {
            return new BlockPos(x * definition.getSpawnStructureSpacing(), 0, z * definition.getSpawnStructureSpacing());
        }
        if (skyIslands != null && (iterator = skyIslands.getIslandPositions(world.func_72905_C(), x * skyIslands.getRegionSize(), z * skyIslands.getRegionSize()).entrySet().iterator()).hasNext() && (positions = (islands = iterator.next()).getValue().entrySet().iterator()).hasNext()) {
            Map.Entry<BlockPos, SkyIslandType> island = positions.next();
            BlockPos pos = island.getKey();
            BlockPos topBlock = IslandNew.getTopSolidOrLiquidBlock((World)world, pos);
            return new BlockPos((Vec3i)topBlock.func_177984_a());
        }
        throw new CommandException("This preset does not have spawn structures or sky islands.", new Object[0]);
    }

    private void spawnIslands(EntityPlayerMP player, int xOffset, int zOffset) {
        JsonParser parser;
        JsonElement element;
        WorldServer overworld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        String settings = overworld.func_72912_H().func_82571_y();
        if (!settings.isEmpty() && (element = (parser = new JsonParser()).parse(settings)).isJsonObject() && ((JsonObject)element).has("Topography-Preset")) {
            player.func_145747_a((ITextComponent)new TextComponentString("This may take a few seconds. Please wait."));
            for (int dimension : ConfigurationManager.getInstance().getPreset().getDimensions()) {
                DimensionDefinition definition = ConfigurationManager.getInstance().getPreset().getDefinition(dimension);
                SpawnStructure structure = definition.getSpawnStructure();
                if (structure == null) continue;
                WorldServer dimWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
                Template template = IOHelper.loadStructureTemplate(structure.getStructure());
                if (template == null) continue;
                int preloadArea = template.func_186259_a().func_177958_n();
                preloadArea = template.func_186259_a().func_177952_p() > preloadArea ? template.func_186259_a().func_177952_p() : preloadArea;
                preloadArea /= 16;
                Topography.instance.getLog().info((Object)("Preloading " + ((preloadArea += 2) * 2 + 1) * (preloadArea * 2 + 1) + " chunks for spawn structure in dimension " + dimension));
                for (int x = -preloadArea; x < preloadArea; ++x) {
                    for (int z = -preloadArea; z < preloadArea; ++z) {
                        dimWorld.func_72863_F().func_186025_d(x + xOffset, z + zOffset);
                    }
                }
                BlockPos structurePos = new BlockPos(xOffset * 16, structure.getHeight(), zOffset * 16);
                Topography.instance.getLog().info((Object)("Spawning structure for dimension " + dimension + " at " + structurePos.toString()));
                template.func_189962_a((World)dimWorld, structurePos, new PlacementSettings(), 2);
                if (dimension != 0) continue;
                BlockPos spawn = StructureHelper.getSpawn(template);
                spawn = spawn.func_177982_a(xOffset * 16, structure.getHeight(), zOffset * 16);
                player.func_180473_a(spawn, true);
                player.func_70634_a((double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p());
                ITopographyPlayerData data = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
                if (data == null) continue;
                data.setIsland(structurePos.func_177958_n(), structurePos.func_177952_p());
            }
            player.func_145747_a((ITextComponent)new TextComponentString("Finished spawning structures."));
        }
    }

    private void setPlayerSpawn(EntityPlayerMP player, BlockPos pos) {
        BlockPos spawn = pos.func_177963_a(0.5, 0.0, 0.5);
        player.func_180473_a(spawn, true);
        player.func_70634_a((double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p());
        ITopographyPlayerData data = (ITopographyPlayerData)player.getCapability(TopographyPlayerData.CAPABILITY_TOPOGRAPHY_PLAYER_DATA, null);
        if (data != null) {
            data.setIsland(pos.func_177958_n(), pos.func_177952_p());
        }
    }

    private static boolean checkEntity(Entity entity) {
        return !entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU();
    }

    public static BlockPos getTopSolidOrLiquidBlock(World world, BlockPos pos) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && !(state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76230_c()) {
            blockpos = blockpos1;
        }
        return blockpos;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return !(sender instanceof EntityPlayerMP) || PermissionAPI.hasPermission((EntityPlayer)((EntityPlayerMP)sender), (String)"topography.island.new");
    }
}

