/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.config;

import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.IOHelper;
import com.bloodnbonesgaming.topography.Topography;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;

public class ConfigPreset {
    private final String name;
    private final String image;
    private final String description;
    private final String worldType;
    private final String generatorSettings;
    private boolean enableHardcore;
    private EnumDifficulty initialDifficulty = null;
    private boolean lockDifficulty = false;
    private List<ResourceLocation> initialPlayerFunctions = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> initialServerFunctions = new ArrayList<ResourceLocation>();
    private final Map<Integer, String> scripts = new HashMap<Integer, String>();
    private final Map<Integer, DimensionDefinition> definitions = new HashMap<Integer, DimensionDefinition>();
    private boolean locked = false;
    private boolean disableNetherPortal = false;

    public ConfigPreset(String name, String image) {
        this(name, image, null);
    }

    public ConfigPreset(String name, String image, String description) {
        this(name, image, description, null, null);
    }

    public ConfigPreset(String name, String image, String description, String worldType) {
        this(name, image, description, worldType, null);
    }

    public ConfigPreset(String name, String image, String description, String worldType, String generatorOptions) {
        this.name = name != null ? name : "";
        this.image = image;
        this.description = description;
        this.worldType = worldType;
        this.generatorSettings = generatorOptions;
    }

    @ScriptMethodDocumentation(args="int, String", usage="dimension ID, script file path", notes="Registers a script file to be used to create a dimension. Script file path is relative to the config/topography folder, and should not include the file extension.")
    public void registerDimension(int dimension, String script) throws Exception {
        this.scripts.put(dimension, script);
    }

    public String getName() {
        return this.name;
    }

    public String getScript(int dimension) {
        return this.scripts.get(dimension);
    }

    public Set<Integer> getDimensions() {
        return this.scripts.keySet();
    }

    public String getImage() {
        return this.image;
    }

    public String getDescription() {
        return this.description;
    }

    public String getWorldType() {
        return this.worldType;
    }

    public String getGeneratorOptions() {
        return this.generatorSettings;
    }

    public boolean hardcore() {
        return this.enableHardcore;
    }

    @ScriptMethodDocumentation(usage="", notes="Sets the preset as hardcore.")
    public void enableHardcore() {
        this.enableHardcore = true;
    }

    @ScriptMethodDocumentation(usage="", notes="Locks the preset from being chosen in the gui. Unlocking the preset is done with the /topography unlock command.")
    public void lock() {
        this.locked = true;
    }

    public boolean locked() {
        return this.locked ? !ConfigurationManager.getInstance().getLockHandler().unlocked(this.name) : false;
    }

    @ScriptMethodDocumentation(args="String", usage="function resource location", notes="Adds a command function to be run on the player when they first log in. Multiple of these can be added.")
    public void addInitialPlayerFunction(String function) {
        this.initialPlayerFunctions.add(new ResourceLocation(function));
    }

    public void setInitialPlayerFunction(String function) {
        this.addInitialPlayerFunction(function);
    }

    public List<ResourceLocation> getInitialPlayerFunctions() {
        return this.initialPlayerFunctions;
    }

    @ScriptMethodDocumentation(args="String", usage="function resource location", notes="Adds a command function to be run on the server at the start of the first dimension 0 world tick. Multiple of these can be added.")
    public void addInitialServerFunction(String function) {
        this.initialServerFunctions.add(new ResourceLocation(function));
    }

    public void setInitialServerFunction(String function) {
        this.addInitialServerFunction(function);
    }

    public List<ResourceLocation> getInitialServerFunctions() {
        return this.initialServerFunctions;
    }

    @ScriptMethodDocumentation(args="int", usage="difficulty value", notes="Sets the initial difficulty of the preset.")
    public void setDifficulty(int difficulty) throws Exception {
        EnumDifficulty e = EnumDifficulty.func_151523_a((int)difficulty);
        if (e == null) {
            throw new Exception(difficulty + " is not a valid difficulty.");
        }
        this.initialDifficulty = e;
    }

    @ScriptMethodDocumentation(args="String", usage="difficulty value", notes="Sets the initial difficulty of the preset.")
    public void setDifficulty(String difficulty) throws Exception {
        EnumDifficulty e = EnumDifficulty.valueOf((String)difficulty.toUpperCase());
        if (e == null) {
            throw new Exception(difficulty + " is not a valid difficulty.");
        }
        this.initialDifficulty = e;
    }

    public EnumDifficulty getDifficulty() {
        return this.initialDifficulty;
    }

    @ScriptMethodDocumentation(usage="", notes="Locks the difficulty of the preset.")
    public void lockDifficulty() {
        this.lockDifficulty = true;
    }

    public boolean shouldLockDifficulty() {
        return this.lockDifficulty;
    }

    @ScriptMethodDocumentation(usage="", notes="Disables the creation of a nether portal in the preset.")
    public void disableNetherPortal() {
        this.disableNetherPortal = true;
    }

    public boolean shouldDisableNetherPortal() {
        return this.disableNetherPortal;
    }

    public DimensionDefinition getDefinition(int dimension) {
        if (!this.definitions.containsKey(dimension)) {
            Topography.instance.getLog().info((Object)("Loading Dimension Definition for " + dimension));
            DimensionDefinition definition = new DimensionDefinition();
            IOHelper.loadDimensionDefinition(this.scripts.get(dimension), definition);
            this.definitions.put(dimension, definition);
        }
        return this.definitions.get(dimension);
    }

    public Map<Integer, DimensionDefinition> getAllDefinitions() {
        return this.definitions;
    }

    public void loadAllDefinitions() {
        for (Map.Entry<Integer, String> entry : this.scripts.entrySet()) {
            Topography.instance.getLog().info((Object)("Loading Dimension Definition for " + entry.getKey()));
            DimensionDefinition definition = new DimensionDefinition();
            IOHelper.loadDimensionDefinition(entry.getValue(), definition);
            this.definitions.put(entry.getKey(), definition);
        }
    }
}

