/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.config;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/sky_islands/SkyIslandDataV2", classExplaination="This file is for the SkyIslandDataV2. This data object is for holding size and type data of islands for the SkyIslandGeneratorV2.")
public class SkyIslandDataV2
extends SkyIslandData {
    private int count = 1;
    private double horizontalRadius = 100.0;
    private double verticalRadius;
    private double topHeight = this.verticalRadius = 100.0;
    private double bottomHeight = this.verticalRadius;
    private double fluidDepth = -1.0;
    private int minHeight = 5;
    private int maxHeight = 220;
    private List<SkyIslandType> types = new ArrayList<SkyIslandType>();
    private boolean randomTypes = true;
    private int minCount = 0;

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    public double getHorizontalRadius() {
        return this.horizontalRadius;
    }

    public void setHorizontalRadius(int radius) {
        this.horizontalRadius = radius;
    }

    public void setVerticalRadius(int radius) {
        this.verticalRadius = radius;
        this.topHeight = radius;
        this.bottomHeight = radius;
    }

    public double getTopHeight() {
        return this.topHeight;
    }

    public void setTopHeight(double height) {
        this.topHeight = height;
    }

    public double getBottomHeight() {
        return this.bottomHeight;
    }

    public void setBottomHeight(double height) {
        this.bottomHeight = height;
    }

    public double getFluidDepth() {
        if (this.fluidDepth < 0.0) {
            this.fluidDepth = Math.floor(this.horizontalRadius / 20.0);
        }
        return this.fluidDepth;
    }

    @ScriptMethodDocumentation(args="double", usage="depth", notes="Sets the fluid depth for lakes on the islands. Default horizontalRadius / 20.")
    public void setFluidDepth(double depth) {
        this.fluidDepth = depth;
    }

    @ScriptMethodDocumentation(args="int, int", usage="min, max", notes="Sets the min/max heights for islands to generate.")
    public void setHeightRange(int min, int max) {
        this.minHeight = min;
        this.maxHeight = max;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    @ScriptMethodDocumentation(args="SkyIslandType", usage="type", notes="Adds a type of sky island to be generated.")
    public void addType(SkyIslandType type) {
        this.types.add(type);
    }

    @Override
    public SkyIslandType getType(int index) {
        return this.types.get(index % this.types.size());
    }

    @Override
    public SkyIslandType getType(Random rand) {
        return this.types.get(rand.nextInt(this.types.size()));
    }

    @Override
    public boolean isRandomIslands() {
        return this.randomTypes;
    }

    @Override
    public void setRandomTypes(boolean randomTypes) {
        this.randomTypes = randomTypes;
    }

    @Override
    public int getMinCount() {
        return this.minCount;
    }

    @Override
    public void setMinCount(int count) {
        this.minCount = count;
    }
}

