/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.config;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.world.decorator.DecorationData;
import com.bloodnbonesgaming.topography.world.decorator.DecoratorScattered;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/sky_islands/SkyIslandType", classExplaination="This file is for the SkyIslandType. This data object is for creating island types for the SkyIslandGeneratorV2. These can be created in a dimension file using 'new SkyIslandType(biomeID)', with the biome id being the biome you want the island to be, or 'new SkyIslandType()' to default to the void biome.")
public class SkyIslandType {
    private IBlockState mainBlock = Blocks.field_150348_b.func_176223_P();
    private boolean genBiomeBlocks = true;
    private boolean genDecorations = true;
    private int biome = Biome.func_185362_a((Biome)Biomes.field_185440_P);
    private final Map<MinMaxBounds, IBlockState> boundsToState = new LinkedHashMap<MinMaxBounds, IBlockState>();
    private boolean genAnimals = true;
    private final List<DecorationData> decorators = new ArrayList<DecorationData>();
    private double fluidPercentage = 0.5;
    private IBlockState fluidBlock = Blocks.field_150355_j.func_176223_P();
    private boolean generateFluid = true;
    private boolean generateMineshafts = false;
    private int mineshaftChance = 4;
    private boolean generateStrongholds = false;
    private int strongholdChance = 4;
    private boolean generateVillages = false;
    private int villageChance = 4;
    private List<IGenerator> generators = new ArrayList<IGenerator>();

    public SkyIslandType() {
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    public SkyIslandType(int biome) {
        this();
        this.biome = biome;
    }

    public IBlockState getMainBlock() {
        return this.mainBlock;
    }

    public void setMainBlock(IBlockState mainBlock) {
        this.mainBlock = mainBlock;
    }

    public boolean isGenBiomeBlocks() {
        return this.genBiomeBlocks;
    }

    public boolean isGenDecorations() {
        return this.genDecorations;
    }

    public boolean genAnimals() {
        return this.genAnimals;
    }

    public int getBiome() {
        return this.biome;
    }

    @ScriptMethodDocumentation(usage="biome id", notes="Sets the biome to be used for the island type.")
    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    public void setBiome(int biome) {
        this.biome = biome;
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="block", notes="Sets the main block for the island type to be made of.")
    public void setMainBlock(ItemBlockData data) throws Exception {
        this.mainBlock = data.buildBlockState();
    }

    @ScriptMethodDocumentation(usage="", notes="Disables biome block replacement for the island type.")
    public void disableBiomeBlockReplacement() {
        this.genBiomeBlocks = false;
    }

    @ScriptMethodDocumentation(usage="", notes="Disables decorations for the island type.")
    public void disableDecorations() {
        this.genDecorations = false;
    }

    @ScriptMethodDocumentation(usage="", notes="Disables initial animal spawning for the island type.")
    public void disableAnimals() {
        this.genAnimals = false;
    }

    @ScriptMethodDocumentation(args="ItemBlockData, MinMaxBounds", usage="block, bounds", notes="Sets a block to be used for generation within a range of distance from the center of the island type. 0.0 being the center of the island, 1.0 being the outermost possible blocks.")
    public void setBlockInRange(ItemBlockData data, MinMaxBounds bounds) throws Exception {
        IBlockState state = data.buildBlockState();
        this.boundsToState.put(bounds, state);
    }

    public Map<MinMaxBounds, IBlockState> getBoundsToStateMap() {
        return this.boundsToState;
    }

    public void addDecorator(DecoratorScattered decorator, int count, int regionSize) {
        this.decorators.add(new DecorationData(decorator, count, regionSize));
    }

    public List<DecorationData> getDecorators() {
        return this.decorators;
    }

    @ScriptMethodDocumentation(args="IGenerator", usage="generator", notes="Adds the provided generator. This generator will only generate in chunks containing islands generated with this type.")
    public void addGenerator(IGenerator generator) {
        this.generators.add(generator);
    }

    public List<IGenerator> getGenerators() {
        return this.generators;
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="block", notes="Sets the fluid block for the lakes on the islands to generate.")
    public void setFluidBlock(ItemBlockData data) throws Exception {
        this.fluidBlock = data.buildBlockState();
    }

    public IBlockState getFluidBlock() {
        return this.fluidBlock;
    }

    @ScriptMethodDocumentation(usage="", notes="Disables lake generation for the island type.")
    public void disableFluid() {
        this.generateFluid = false;
    }

    public boolean generateFluid() {
        return this.generateFluid;
    }

    public boolean shouldGenerateMineshafts() {
        return this.generateMineshafts;
    }

    @ScriptMethodDocumentation(args="int", usage="chance", notes="Sets the 1/chance for mineshafts to generate for the island type. These are centered on the island, and size limited.")
    public void generateMineshafts(int chance) {
        this.mineshaftChance = chance;
        this.generateMineshafts = true;
    }

    public boolean shouldGenerateStrongholds() {
        return this.generateStrongholds;
    }

    @ScriptMethodDocumentation(args="int", usage="chance", notes="Sets the 1/chance for strongholds to generate for the island type. These are centered on the island, and only generate the end portal room.")
    public void generateStrongholds(int chance) {
        this.strongholdChance = chance;
        this.generateStrongholds = true;
    }

    public boolean shouldGenerateVillages() {
        return this.generateVillages;
    }

    @ScriptMethodDocumentation(args="int", usage="chance", notes="Sets the 1/chance for villages to generate for the island type. These are centered on the island, and size limited to avoid floating buildings.")
    public void generateVillages(int chance) {
        this.villageChance = chance;
        this.generateVillages = true;
    }

    public int getMineshaftChance() {
        return this.mineshaftChance;
    }

    public int getStrongholdChance() {
        return this.strongholdChance;
    }

    public int getVillageChance() {
        return this.villageChance;
    }

    @ScriptMethodDocumentation(args="double", usage="percentage", notes="Defaults to 0.5. Higher values increase lake size, lower values decrease.")
    public void setFluidPercentage(double fluidPercentage) {
        this.fluidPercentage = fluidPercentage;
    }

    public double getFluidPercentage() {
        return this.fluidPercentage;
    }
}

