/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.event;

import com.bloodnbonesgaming.topography.Topography;
import com.bloodnbonesgaming.topography.client.gui.GuiCreateWorldTopography;
import com.bloodnbonesgaming.topography.client.gui.GuiWorldSelectionOverride;
import com.bloodnbonesgaming.topography.config.ConfigPreset;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import com.bloodnbonesgaming.topography.world.WorldTypeCustomizable;
import java.util.Map;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientEventSubscriber {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onOpenGui(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiCreateWorld && Minecraft.func_71410_x().field_71462_r instanceof GuiWorldSelection) {
            event.setGui((GuiScreen)new GuiCreateWorldTopography(Minecraft.func_71410_x().field_71462_r));
            WorldTypeCustomizable.gui = (GuiCreateWorld)event.getGui();
            if (ConfigurationManager.getInstance().defaultWorldType()) {
                for (int i = 0; i < WorldType.field_77139_a.length; ++i) {
                    if (!(WorldType.field_77139_a[i] instanceof WorldTypeCustomizable)) continue;
                    ((GuiCreateWorld)event.getGui()).field_146331_K = i;
                    break;
                }
            }
        }
        if (!Topography.worldbook && event.getGui() instanceof GuiWorldSelection && !(event.getGui() instanceof GuiWorldSelectionOverride)) {
            event.setGui((GuiScreen)new GuiWorldSelectionOverride(((GuiWorldSelection)event.getGui()).field_184864_a));
        }
    }

    @SubscribeEvent
    public void getFogColors(EntityViewRenderEvent.FogColors event) {
        Map<Integer, Map<MinMaxBounds, MinMaxBounds>> fogMap;
        DimensionDefinition dimensionDef;
        ConfigPreset preset;
        ConfigurationManager manager = ConfigurationManager.getInstance();
        if (manager != null && (preset = manager.getPreset()) != null && (dimensionDef = preset.getDefinition(event.getEntity().field_70170_p.field_73011_w.getDimension())) != null && (fogMap = dimensionDef.getFog()) != null && !fogMap.isEmpty()) {
            float angle = event.getEntity().field_70170_p.func_72826_c((float)event.getRenderPartialTicks());
            Vec3d color = new Vec3d(0.0, 0.0, 0.0);
            for (Map.Entry<Integer, Map<MinMaxBounds, MinMaxBounds>> fog : fogMap.entrySet()) {
                float alpha = 0.0f;
                for (Map.Entry<MinMaxBounds, MinMaxBounds> entry : fog.getValue().entrySet()) {
                    float alphaDiff;
                    if (!entry.getKey().func_192514_a(angle)) continue;
                    MinMaxBounds key = entry.getKey();
                    MinMaxBounds value = entry.getValue();
                    if (value.field_192517_b == null || value.field_192518_c == null) continue;
                    float diff = key.field_192518_c.floatValue() - key.field_192517_b.floatValue();
                    float distIntoRange = angle - key.field_192517_b.floatValue();
                    float percent = distIntoRange / diff;
                    if (value.field_192517_b.floatValue() > value.field_192518_c.floatValue()) {
                        alphaDiff = value.field_192517_b.floatValue() - value.field_192518_c.floatValue();
                        alpha = value.field_192517_b.floatValue() - alphaDiff * percent;
                        break;
                    }
                    alphaDiff = value.field_192518_c.floatValue() - value.field_192517_b.floatValue();
                    alpha = value.field_192517_b.floatValue() + alphaDiff * percent;
                    break;
                }
                float alphaOpposite = 1.0f - alpha;
                color = new Vec3d((double)((float)(fog.getKey() >> 16 & 0xFF) / 255.0f * alpha) + color.field_72450_a * (double)alphaOpposite, (double)((float)(fog.getKey() >> 8 & 0xFF) / 255.0f * alpha) + color.field_72448_b * (double)alphaOpposite, (double)((float)(fog.getKey() & 0xFF) / 255.0f * alpha) + color.field_72449_c * (double)alphaOpposite);
            }
            event.setRed((float)color.field_72450_a);
            event.setGreen((float)color.field_72448_b);
            event.setBlue((float)color.field_72449_c);
        }
    }
}

