/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.event;

import com.bloodnbonesgaming.bnbgamingcore.events.StructureVillageFillBlocksDownEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.StructureVillageGetAverageGroundLevelEvent;
import com.bloodnbonesgaming.topography.config.ConfigPreset;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandDataV2;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import com.bloodnbonesgaming.topography.util.MathUtil;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import com.bloodnbonesgaming.topography.world.generator.SkyIslandGeneratorV2;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CoreEventHandler {
    @SubscribeEvent
    public void onVillageGetAverageGroundLevel(StructureVillageGetAverageGroundLevelEvent event) {
        DimensionDefinition dimensionDef;
        ConfigPreset preset;
        Map<SkyIslandData, Map<BlockPos, SkyIslandType>> islandPositions = null;
        ConfigurationManager manager = ConfigurationManager.getInstance();
        if (manager != null && (preset = manager.getPreset()) != null && (dimensionDef = preset.getDefinition(event.world.field_73011_w.getDimension())) != null) {
            for (IGenerator generator : dimensionDef.getGenerators()) {
                if (!(generator instanceof SkyIslandGeneratorV2)) continue;
                SkyIslandGeneratorV2 islandGenerator = (SkyIslandGeneratorV2)generator;
                islandPositions = islandGenerator.getIslandPositions(event.world.func_72905_C(), event.piece.func_74874_b().field_78897_a, event.piece.func_74874_b().field_78896_c);
                break;
            }
            if (islandPositions != null) {
                int highestHeight = 0;
                int i = 0;
                int j = 0;
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int k = event.piece.func_74874_b().field_78896_c; k <= event.piece.func_74874_b().field_78892_f; ++k) {
                    for (int l = event.piece.func_74874_b().field_78897_a; l <= event.piece.func_74874_b().field_78893_d; ++l) {
                        int islandMid = 0;
                        double shortestDistance = 9.9999999E7;
                        BlockPos closestIsland = null;
                        blockpos$mutableblockpos.func_181079_c(l, 64, k);
                        block3: for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> set : islandPositions.entrySet()) {
                            for (Map.Entry<BlockPos, SkyIslandType> innerSet : set.getValue().entrySet()) {
                                if (!(set.getKey() instanceof SkyIslandDataV2)) continue;
                                SkyIslandDataV2 data = (SkyIslandDataV2)set.getKey();
                                double distance = MathUtil.getDistance((BlockPos)blockpos$mutableblockpos, innerSet.getKey());
                                if (!(distance < data.getHorizontalRadius() * 2.0 + 25.0) || !(distance < shortestDistance)) continue;
                                shortestDistance = distance;
                                closestIsland = innerSet.getKey();
                                islandMid = innerSet.getKey().func_177956_o() + (int)((SkyIslandDataV2)set.getKey()).getFluidDepth();
                                if (!(shortestDistance <= 25.0)) continue;
                                break block3;
                            }
                        }
                        if (!event.boundingBox.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                        int topSolid = event.world.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o();
                        if (topSolid > highestHeight) {
                            highestHeight = topSolid;
                        }
                        i += Math.max(topSolid, islandMid);
                        ++j;
                    }
                }
                if (j == 0) {
                    event.averageGroundLevel = -2;
                    return;
                }
                event.averageGroundLevel = i / j;
                return;
            }
        }
    }

    @SubscribeEvent
    public void onVillageBuildBlocksDown(StructureVillageFillBlocksDownEvent event) {
        int k;
        int j;
        StructureVillagePieces.Village piece = event.piece;
        StructureBoundingBox box = event.boundingBox;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        World world = event.world;
        int i = this.getXWithOffset(piece, x, z);
        if (box.func_175898_b((Vec3i)new BlockPos(i, j = this.getYWithOffset(piece, y), k = this.getZWithOffset(piece, x, z)))) {
            while (world.func_175623_d(new BlockPos(i, j, k)) && j > 1) {
                --j;
            }
        }
        if (j <= 1) {
            event.setCanceled(true);
        }
    }

    protected int getXWithOffset(StructureVillagePieces.Village piece, int x, int z) {
        EnumFacing enumfacing = piece.func_186165_e();
        if (enumfacing == null) {
            return x;
        }
        switch (enumfacing) {
            case NORTH: 
            case SOUTH: {
                return piece.func_74874_b().field_78897_a + x;
            }
            case WEST: {
                return piece.func_74874_b().field_78893_d - z;
            }
            case EAST: {
                return piece.func_74874_b().field_78897_a + z;
            }
        }
        return x;
    }

    protected int getYWithOffset(StructureVillagePieces.Village piece, int y) {
        return piece.func_186165_e() == null ? y : y + piece.func_74874_b().field_78895_b;
    }

    protected int getZWithOffset(StructureVillagePieces.Village piece, int x, int z) {
        EnumFacing enumfacing = piece.func_186165_e();
        if (enumfacing == null) {
            return z;
        }
        switch (enumfacing) {
            case NORTH: {
                return piece.func_74874_b().field_78892_f - z;
            }
            case SOUTH: {
                return piece.func_74874_b().field_78896_c + z;
            }
            case WEST: 
            case EAST: {
                return piece.func_74874_b().field_78896_c + x;
            }
        }
        return z;
    }
}

