/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.util.noise;

import com.bloodnbonesgaming.lib.util.noise.OpenSimplexNoiseGeneratorOctaves;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;

public class RunnableSimplexNoise
implements Runnable {
    protected OpenSimplexNoiseGeneratorOctaves noise;
    final int startX;
    final int startY;
    final int startZ;
    final int octaves;
    final double persistence;
    final double coordinateScale;
    final double[] layerArray;
    private static double[] array = null;

    public RunnableSimplexNoise(OpenSimplexNoiseGeneratorOctaves noise, int startX, int startY, int startZ, double coordinateScale, int octaves, double persistence) {
        this.noise = noise;
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.coordinateScale = coordinateScale;
        this.octaves = octaves;
        this.persistence = persistence;
        this.layerArray = new double[75];
    }

    @Override
    public void run() {
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                for (int y = 0; y < 3; ++y) {
                    this.layerArray[(x * 5 + z) * 3 + y] = this.noise.eval((double)(this.startX + x * 4) / this.coordinateScale, (double)((this.startY + y) * 8) / this.coordinateScale, (double)(this.startZ + z * 4) / this.coordinateScale, this.octaves, this.persistence);
                }
            }
        }
        RunnableSimplexNoise.addToArray(this.layerArray, this.startY);
    }

    public static synchronized void addToArray(double[] layerArray, int startY) {
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                for (int y = 0; y < 3; ++y) {
                    RunnableSimplexNoise.array[(x * 5 + z) * 33 + startY + y] = layerArray[(x * 5 + z) * 3 + y];
                }
            }
        }
    }

    public static void getNoise(double[] array, OpenSimplexNoiseGeneratorOctaves generator, int startX, int startZ, double coordinateScale, int octaves, double persistence) {
        RunnableSimplexNoise.array = array;
        ArrayList<Callable<Object>> callables = new ArrayList<Callable<Object>>();
        for (int y = 0; y < 33; y += 3) {
            callables.add(Executors.callable(new RunnableSimplexNoise(generator, startX, y, startZ, coordinateScale, octaves, persistence)));
        }
        try {
            ConfigurationManager.getInstance().getExecutor().invokeAll(callables);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

