/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.util.noise;

import com.bloodnbonesgaming.lib.util.noise.OpenSimplexNoiseGeneratorOctaves;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;

public class RunnableSimplexNoise1x1
implements Runnable {
    protected OpenSimplexNoiseGeneratorOctaves noise;
    final int startX;
    final int startY;
    final int startZ;
    final int octaves;
    final double persistence;
    final double coordinateScale;
    final double[] layerArray;
    final int layerThickness;
    private static double[] array = null;

    public RunnableSimplexNoise1x1(OpenSimplexNoiseGeneratorOctaves noise, int layerThickness, int startX, int startY, int startZ, double coordinateScale, int octaves, double persistence) {
        this.noise = noise;
        this.layerThickness = layerThickness;
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.coordinateScale = coordinateScale;
        this.octaves = octaves;
        this.persistence = persistence;
        this.layerArray = new double[256 * layerThickness];
    }

    @Override
    public void run() {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < this.layerThickness; ++y) {
                    this.layerArray[(x * 16 + z) * this.layerThickness + y] = this.noise.eval((double)(this.startX + x) / this.coordinateScale, (double)(this.startY + y) / this.coordinateScale, (double)(this.startZ + z) / this.coordinateScale, this.octaves, this.persistence);
                }
            }
        }
        RunnableSimplexNoise1x1.addToArray(this.layerArray, this.layerThickness, this.startY);
    }

    public static synchronized void addToArray(double[] layerArray, int layerThickness, int startY) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < layerThickness; ++y) {
                    RunnableSimplexNoise1x1.array[(x * 16 + z) * 256 + startY + y] = layerArray[(x * 16 + z) * layerThickness + y];
                }
            }
        }
    }

    public static void getNoise(double[] array, OpenSimplexNoiseGeneratorOctaves generator, int firstY, int lastY, int startX, int startZ, double coordinateScale, int octaves, double persistence) {
        int layerThickness = 4;
        RunnableSimplexNoise1x1.array = array;
        ArrayList<Callable<Object>> callables = new ArrayList<Callable<Object>>();
        for (int y = firstY / 4 * 4; y < lastY; y += 4) {
            callables.add(Executors.callable(new RunnableSimplexNoise1x1(generator, 4, startX, y, startZ, coordinateScale, octaves, persistence)));
        }
        try {
            ConfigurationManager.getInstance().getExecutor().invokeAll(callables);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

