/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world;

import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import com.bloodnbonesgaming.topography.world.generator.IStructureHandler;
import com.bloodnbonesgaming.topography.world.generator.vanilla.structure.EndCityGenerator;
import com.bloodnbonesgaming.topography.world.generator.vanilla.structure.MansionGenerator;
import com.bloodnbonesgaming.topography.world.generator.vanilla.structure.MineshaftGenerator;
import com.bloodnbonesgaming.topography.world.generator.vanilla.structure.NetherBridgeGenerator;
import com.bloodnbonesgaming.topography.world.generator.vanilla.structure.OceanMonumentGenerator;
import com.bloodnbonesgaming.topography.world.generator.vanilla.structure.ScatteredFeatureGenerator;
import com.bloodnbonesgaming.topography.world.generator.vanilla.structure.StrongholdGenerator;
import com.bloodnbonesgaming.topography.world.generator.vanilla.structure.VillageGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.WoodlandMansion;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class StructureHandler {
    private NetherBridgeGenerator netherFortress;
    private EndCityGenerator endCity;
    private WoodlandMansion mansion;
    private MapGenMineshaft mineshaft;
    private StructureOceanMonument monument;
    private MapGenScatteredFeature scattered;
    private MapGenStronghold stronghold;
    private MapGenVillage village;
    private final List<IStructureHandler> handlers = new ArrayList<IStructureHandler>();

    public void addStructureHandler(IStructureHandler handler) {
        this.handlers.add(handler);
    }

    public void generateStructures(World world, int chunkX, int chunkZ, ChunkPrimer primer) {
        for (IStructureHandler handler : this.handlers) {
            handler.generateStructures(world, chunkX, chunkZ, primer);
        }
        if (this.netherFortress != null) {
            this.netherFortress.func_186125_a(world, chunkX, chunkZ, primer);
        }
        if (this.endCity != null) {
            this.endCity.func_186125_a(world, chunkX, chunkZ, primer);
        }
        if (this.mineshaft != null) {
            this.mineshaft.func_186125_a(world, chunkX, chunkZ, primer);
        }
        if (this.village != null) {
            this.village.func_186125_a(world, chunkX, chunkZ, primer);
        }
        if (this.stronghold != null) {
            this.stronghold.func_186125_a(world, chunkX, chunkZ, primer);
        }
        if (this.scattered != null) {
            this.scattered.func_186125_a(world, chunkX, chunkZ, primer);
        }
        if (this.monument != null) {
            this.monument.func_186125_a(world, chunkX, chunkZ, primer);
        }
        if (this.mansion != null) {
            this.mansion.func_186125_a(world, chunkX, chunkZ, primer);
        }
    }

    public void populateStructures(World world, Random rand, ChunkPos chunkPos) {
        for (IStructureHandler handler : this.handlers) {
            handler.populateStructures(world, rand, chunkPos);
        }
        if (this.netherFortress != null) {
            this.netherFortress.func_175794_a(world, rand, chunkPos);
        }
        if (this.endCity != null) {
            this.endCity.func_175794_a(world, rand, chunkPos);
        }
        if (this.mineshaft != null) {
            this.mineshaft.func_175794_a(world, rand, chunkPos);
        }
        if (this.village != null) {
            this.village.func_175794_a(world, rand, chunkPos);
        }
        if (this.stronghold != null) {
            this.stronghold.func_175794_a(world, rand, chunkPos);
        }
        if (this.scattered != null) {
            this.scattered.func_175794_a(world, rand, chunkPos);
        }
        if (this.monument != null) {
            this.monument.func_175794_a(world, rand, chunkPos);
        }
        if (this.mansion != null) {
            this.mansion.func_175794_a(world, rand, chunkPos);
        }
    }

    public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType creatureType, World world, BlockPos pos, List<Biome.SpawnListEntry> spawns) {
        for (IStructureHandler handler : this.handlers) {
            List<Biome.SpawnListEntry> list = handler.getPossibleCreatures(creatureType, world, pos, spawns);
            if (list == spawns) continue;
            return list;
        }
        if (creatureType == EnumCreatureType.MONSTER) {
            if (this.netherFortress != null) {
                if (this.netherFortress.func_175795_b(pos)) {
                    return this.netherFortress.func_75059_a();
                }
                if (this.netherFortress.func_175796_a(world, pos) && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150385_bj) {
                    return this.netherFortress.func_75059_a();
                }
            }
            if (this.scattered != null && this.scattered.func_175798_a(pos)) {
                return this.scattered.func_82667_a();
            }
            if (this.monument != null && this.monument.func_175796_a(world, pos)) {
                return this.monument.func_175799_b();
            }
        }
        return spawns;
    }

    @Nullable
    public BlockPos getNearestStructurePos(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        for (IStructureHandler handler : this.handlers) {
            BlockPos pos = handler.getNearestStructurePos(worldIn, structureName, position, findUnexplored);
            if (pos == null) continue;
            return pos;
        }
        switch (structureName) {
            case "Fortress": {
                return this.netherFortress != null ? this.netherFortress.func_180706_b(worldIn, position, findUnexplored) : null;
            }
            case "EndCity": {
                return this.endCity != null ? this.endCity.func_180706_b(worldIn, position, findUnexplored) : null;
            }
            case "Stronghold": {
                return this.stronghold != null ? this.stronghold.func_180706_b(worldIn, position, findUnexplored) : null;
            }
            case "Mansion": {
                return this.mansion != null ? this.mansion.func_180706_b(worldIn, position, findUnexplored) : null;
            }
            case "Monument": {
                return this.monument != null ? this.monument.func_180706_b(worldIn, position, findUnexplored) : null;
            }
            case "Village": {
                return this.village != null ? this.village.func_180706_b(worldIn, position, findUnexplored) : null;
            }
            case "Mineshaft": {
                return this.mineshaft != null ? this.mineshaft.func_180706_b(worldIn, position, findUnexplored) : null;
            }
            case "Temple": {
                return this.scattered != null ? this.scattered.func_180706_b(worldIn, position, findUnexplored) : null;
            }
        }
        return null;
    }

    public boolean isInsideStructure(World worldIn, String structureName, BlockPos pos) {
        for (IStructureHandler handler : this.handlers) {
            boolean bool = handler.isInsideStructure(worldIn, structureName, pos);
            if (!bool) continue;
            return bool;
        }
        switch (structureName) {
            case "Fortress": {
                return this.netherFortress != null ? this.netherFortress.func_175795_b(pos) : false;
            }
            case "EndCity": {
                return this.endCity != null ? this.endCity.func_175795_b(pos) : false;
            }
            case "Stronghold": {
                return this.stronghold != null ? this.stronghold.func_175795_b(pos) : false;
            }
            case "Mansion": {
                return this.mansion != null ? this.mansion.func_175795_b(pos) : false;
            }
            case "Monument": {
                return this.monument != null ? this.monument.func_175795_b(pos) : false;
            }
            case "Village": {
                return this.village != null ? this.village.func_175795_b(pos) : false;
            }
            case "Mineshaft": {
                return this.mineshaft != null ? this.mineshaft.func_175795_b(pos) : false;
            }
            case "Temple": {
                return this.scattered != null ? this.scattered.func_175795_b(pos) : false;
            }
        }
        return false;
    }

    public void recreateStructures(World world, Chunk chunkIn, int x, int z) {
        for (IStructureHandler handler : this.handlers) {
            handler.recreateStructures(world, chunkIn, x, z);
        }
        if (this.netherFortress != null) {
            this.netherFortress.func_186125_a(world, x, z, null);
        }
        if (this.mineshaft != null) {
            this.mineshaft.func_186125_a(world, x, z, (ChunkPrimer)null);
        }
        if (this.village != null) {
            this.village.func_186125_a(world, x, z, (ChunkPrimer)null);
        }
        if (this.stronghold != null) {
            this.stronghold.func_186125_a(world, x, z, (ChunkPrimer)null);
        }
        if (this.scattered != null) {
            this.scattered.func_186125_a(world, x, z, (ChunkPrimer)null);
        }
        if (this.monument != null) {
            this.monument.func_186125_a(world, x, z, (ChunkPrimer)null);
        }
        if (this.mansion != null) {
            this.mansion.func_186125_a(world, x, z, (ChunkPrimer)null);
        }
    }

    public boolean generateStructures(World world, Random rand, Chunk chunkIn, int x, int z) {
        boolean flag = false;
        for (IStructureHandler handler : this.handlers) {
            flag |= handler.generateStructures(world, rand, chunkIn, x, z);
        }
        if (this.monument != null && chunkIn.func_177416_w() < 3600L) {
            flag |= this.monument.func_175794_a(world, rand, new ChunkPos(x, z));
        }
        return flag;
    }

    public void generateNetherFortress(int frequency, int totalArea, int randomArea) {
        this.netherFortress = new NetherBridgeGenerator(frequency, totalArea, randomArea);
    }

    public void generateEndCity(int frequency, int totalArea, int randomArea) {
        this.endCity = new EndCityGenerator(frequency, totalArea, randomArea, new MinMaxBounds(Float.valueOf(0.0f), Float.valueOf(0.0f)));
    }

    public void generateMineshaft() {
        this.mineshaft = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)new MineshaftGenerator(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
    }

    public void generateVillage() {
        this.village = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)new VillageGenerator(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
    }

    public void generateStronghold() {
        this.stronghold = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)new StrongholdGenerator(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
    }

    public void generateTemple() {
        this.scattered = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)new ScatteredFeatureGenerator(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
    }

    public void generateMonument() {
        this.monument = (StructureOceanMonument)TerrainGen.getModdedMapGen((MapGenBase)new OceanMonumentGenerator(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
    }

    public void generateMansion(IGenerator generator) {
        this.mansion = (WoodlandMansion)TerrainGen.getModdedMapGen((MapGenBase)new MansionGenerator(generator), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.WOODLAND_MANSION);
    }
}

