/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.biome.provider;

import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.topography.world.biome.provider.SimpleBiomeProvider;
import com.bloodnbonesgaming.topography.world.biome.provider.layers.BiomeHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.BiomeManager;

public class SimpleBiomeProviderDefinition {
    private final List<BiomeManager.BiomeEntry> biomes = new ArrayList<BiomeManager.BiomeEntry>();
    private final List<BiomeManager.BiomeEntry> oceanBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private final Map<Integer, List<Integer>> hills = new HashMap<Integer, List<Integer>>();
    private final Map<Integer, Integer> rivers = new HashMap<Integer, Integer>();

    public SimpleBiomeProvider buildBiomeProvider(WorldInfo info) {
        return new SimpleBiomeProvider(info.func_76063_b(), info.func_76067_t(), info.func_82571_y(), this.biomes, this.oceanBiomes, this.hills, this.rivers);
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY, ArgType.INT})
    public void addBiomes(int[] biomes) {
        this.addBiomes(biomes, 10);
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY, ArgType.INT})
    public void addBiomes(int[] biomes, int weight) {
        for (int biome : biomes) {
            this.biomes.add(BiomeHelper.generateBiomeEntry(biome, weight));
        }
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY, ArgType.INT})
    public void addOceanBiomes(int[] biomes) {
        this.addOceanBiomes(biomes, 10);
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY, ArgType.INT})
    public void addOceanBiomes(int[] biomes, int weight) {
        for (int biome : biomes) {
            this.oceanBiomes.add(BiomeHelper.generateBiomeEntry(biome, weight));
        }
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY, ArgType.NON_NULL_BIOME_ID_ARRAY})
    public void addHills(int[] biomes, int[] hills) {
        List list = Arrays.stream(hills).boxed().collect(Collectors.toList());
        for (int biome : biomes) {
            if (this.hills.containsKey(biome)) {
                this.hills.get(biome).addAll(list);
                continue;
            }
            this.hills.put(biome, list);
        }
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY, ArgType.NON_NULL_BIOME_ID})
    public void setRiver(int[] biomes, int river) {
        for (int biome : biomes) {
            this.rivers.put(biome, river);
        }
    }
}

