/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.biome.provider.layers;

import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.world.biome.provider.layers.BiomeEdgeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation//biome_providers//genlayers/GenLayerBiomeEdgeDC", classExplaination="A configurable version of the vanilla GenLayerBiomeEdge. Replaces biomes with objectionable neighbors with biomes that make more sense.")
public class GenLayerBiomeEdgeDC
extends GenLayer {
    private List<BiomeEdgeData> edgeDataList = new ArrayList<BiomeEdgeData>();

    @ScriptMethodDocumentation(args="long, GenLayer", usage="base layer seed, parent layer", notes="Constructs the layer with its seed and parent layer.")
    public GenLayerBiomeEdgeDC(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome IDs, edge biome ID", notes="Adds a biome edge for the provided biomes with no whitelist or blacklist.")
    public void addBiomeEdge(int[] biomes, int edge) {
        this.addBiomeEdge(biomes, null, null, edge);
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY, ArgType.BIOME_ID_ARRAY, ArgType.BIOME_ID_ARRAY, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome IDs, whitelist, blacklist, edge biome ID", notes="Adds a biome edge for the provided biomes with a whitelist/blacklist.")
    public void addBiomeEdge(int[] biomes, int[] whitelist, int[] blacklist, int edge) {
        BiomeEdgeData edgeData = new BiomeEdgeData();
        edgeData.setBiomes(biomes);
        edgeData.setWhitelist(whitelist);
        edgeData.setBlacklist(blacklist);
        edgeData.setEdge(edge);
        this.addBiomeEdge(edgeData);
    }

    public void addBiomeEdge(BiomeEdgeData data) {
        this.edgeDataList.add(data);
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int[] parentInts = this.field_75909_a.func_75904_a(chunkX - 1, chunkZ - 1, width + 2, depth + 2);
        int[] returnInts = IntCache.func_76445_a((int)(width * depth));
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                this.func_75903_a(x + chunkX, z + chunkZ);
                int primary = parentInts[x + 1 + (z + 1) * (width + 2)];
                boolean foundEdge = false;
                if (this.edgeDataList != null) {
                    for (BiomeEdgeData data : this.edgeDataList) {
                        if (!data.usedForBiome(primary)) continue;
                        int biome1 = parentInts[x + 1 + (z + 1 - 1) * (width + 2)];
                        int biome2 = parentInts[x + 1 + 1 + (z + 1) * (width + 2)];
                        int biome3 = parentInts[x + 1 - 1 + (z + 1) * (width + 2)];
                        int biome4 = parentInts[x + 1 + (z + 1 + 1) * (width + 2)];
                        if (data.useEdge(biome1)) {
                            returnInts[x + z * width] = data.getEdge();
                            foundEdge = true;
                            break;
                        }
                        if (data.useEdge(biome2)) {
                            returnInts[x + z * width] = data.getEdge();
                            foundEdge = true;
                            break;
                        }
                        if (data.useEdge(biome3)) {
                            returnInts[x + z * width] = data.getEdge();
                            foundEdge = true;
                            break;
                        }
                        if (!data.useEdge(biome4)) continue;
                        returnInts[x + z * width] = data.getEdge();
                        foundEdge = true;
                        break;
                    }
                }
                if (foundEdge) continue;
                returnInts[x + z * width] = primary;
            }
        }
        return returnInts;
    }
}

