/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.NumberHelper;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.util.noise.RunnableSimplexSkewedCellNoise;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.layer.GenLayer;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/CellNoiseGenerator", classExplaination="This file is for the CellNoiseGenerator. This generator generates tendrils of blocks using cell noise skewed with simplex noise. This generator is multithreaded.")
public class CellNoiseGenerator
implements IGenerator {
    double[] smallNoiseArray = new double[825];
    double[] largeNoiseArray = new double[65536];
    IBlockState state = Blocks.field_150350_a.func_176223_P();
    boolean invert = false;
    boolean closeTop = false;
    boolean openTop = true;
    private float frequency = 0.005f;
    private double cutoff = -0.15;
    private final Map<MinMaxBounds, IBlockState> blocks = new LinkedHashMap<MinMaxBounds, IBlockState>();

    @ScriptMethodDocumentation(usage="", notes="This constructs a CellNoiseGenerator that generates air blocks.")
    public CellNoiseGenerator() {
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="block to generate", notes="This constructs a CellNoiseGenerator.")
    public CellNoiseGenerator(ItemBlockData data) throws Exception {
        this();
        this.state = data.buildBlockState();
    }

    public void addBlock(MinMaxBounds bounds, ItemBlockData block) throws Exception {
        this.blocks.put(bounds, block.buildBlockState());
    }

    @ScriptMethodDocumentation(usage="", notes="Sets the generator to scale noise in such a way that a roof will be generated at the top of the dimension.")
    public void closeTop() {
        this.closeTop = true;
    }

    @ScriptMethodDocumentation(usage="", notes="Sets the generator to scale noise in such a way that tendrils will taper off towards the top of the dimension. This is set by default.")
    public void openTop() {
        this.openTop = true;
    }

    @ScriptMethodDocumentation(args="float", usage="frequency", notes="Sets the frequency for the cell noise used for the generator. Higher values = more frequent changes. Default is 0.005.")
    public void setCellFrequency(float frequency) {
        this.frequency = frequency;
    }

    @ScriptMethodDocumentation(args="double", usage="cutoff", notes="Sets the noise cutoff for blocks to be placed. Higher values = more blocks. Default is -0.15.")
    public void setCutoff(double cutoff) {
        this.cutoff = cutoff;
    }

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
        RunnableSimplexSkewedCellNoise.getNoise(this.smallNoiseArray, world.func_72905_C(), chunkX * 16, 0, chunkZ * 16, 5, 33, 4, 8, this.frequency);
        NumberHelper.interpolate((double[])this.smallNoiseArray, (double[])this.largeNoiseArray, (int)5, (int)33, (int)5, (int)4, (int)8, (int)4);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 256; ++y) {
                    double value = this.largeNoiseArray[(x * 16 + z) * 256 + y];
                    double scale = 0.0;
                    if (this.closeTop) {
                        if (y >= 224) {
                            scale = (double)(32 - (256 - y)) / 32.0;
                        }
                    } else if (this.openTop && y >= 224) {
                        scale = -((double)(32 - (256 - y)) / 64.0);
                    }
                    if (!(value + scale > this.cutoff)) continue;
                    IBlockState block = this.state;
                    primer.func_177855_a(x, y, z, block);
                }
            }
        }
    }

    public void invert() {
        this.invert = true;
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ, Random rand) {
    }

    @Override
    public GenLayer getLayer(World world, GenLayer parent) {
        return null;
    }
}

