/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.NumberHelper;
import com.bloodnbonesgaming.lib.util.data.BlockPredicate;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.noise.OpenSimplexNoiseGeneratorOctaves;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.util.noise.RunnableSimplexNoise;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.layer.GenLayer;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/DeformedSphereGenerator", classExplaination="This file is for the DeformedSphereGenerator. This generator generates spheres of blocks, which are then deformed using simplex noise. These spheres generate within grid regions, and can therefore be any size. ")
public class DeformedSphereGenerator
implements IGenerator {
    final IBlockState state;
    final int regionSize;
    final int radius;
    final int count;
    final int minCount;
    double deformScale = 16.0;
    private int minHeight = 0;
    private int maxHeight = 256;
    boolean populate = false;
    private final List<BlockPredicate> requiredBlocks = new ArrayList<BlockPredicate>();
    protected OpenSimplexNoiseGeneratorOctaves terrainNoise = null;
    double[] smallNoiseArray = new double[825];
    double[] largeNoiseArray = new double[65536];
    double[] smallDeformNoiseArray = new double[825];
    double[] largeDeformNoiseArray = new double[65536];

    @ScriptMethodDocumentation(args="ItemBlockData, int, int, int, int", usage="block to generate, grid region size in chunks, radius, generation attempt count, minimum sphere count", notes="This constructs a DeformedSphereGenerator.")
    public DeformedSphereGenerator(ItemBlockData data, int regionSize, int radius, int count, int minCount) throws Exception {
        this.state = data.buildBlockState();
        this.regionSize = regionSize * 16;
        this.radius = radius;
        this.count = count;
        this.minCount = minCount;
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="required block", notes="Adds a block the generator is allowed to generate a sphere within. By default can generate within block.")
    public void addRequiredBlock(ItemBlockData data) throws Exception {
        this.requiredBlocks.add(data.buildBlockPredicate());
    }

    @ScriptMethodDocumentation(args="double", usage="scale", notes="Sets the noise scale used to deform the spheres. Default is 16.0. The higher the number, the more the sphere can be deformed.")
    public void setDeformScale(double scale) {
        this.deformScale = scale;
    }

    @ScriptMethodDocumentation(args="int, int", usage="min, max", notes="Sets the minimum and maximum heights spheres can generate at. Defaults 0-256.")
    public void setHeightRange(int min, int max) {
        this.minHeight = min;
        this.maxHeight = max;
    }

    public void populate() {
        this.populate = true;
    }

    private void generateNoise(int arraySizeX, int arraySizeY, int arraySizeZ, int x, int y, int z, int xCoordinateScale, int yCoordinateScale, int zCoordinateScale) {
        RunnableSimplexNoise.getNoise(this.smallNoiseArray, this.terrainNoise, x, z, 16.0, 3, 0.75);
        RunnableSimplexNoise.getNoise(this.smallDeformNoiseArray, this.terrainNoise, x, z, this.deformScale, 3, 0.75);
    }

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
        if (this.populate) {
            return;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (this.terrainNoise == null) {
            this.terrainNoise = new OpenSimplexNoiseGeneratorOctaves(world.func_72905_C());
        }
        this.generateNoise(5, 33, 5, chunkX * 16, 0, chunkZ * 16, 4, 8, 4);
        NumberHelper.interpolate((double[])this.smallNoiseArray, (double[])this.largeNoiseArray, (int)5, (int)33, (int)5, (int)4, (int)8, (int)4);
        NumberHelper.interpolate((double[])this.smallDeformNoiseArray, (double[])this.largeDeformNoiseArray, (int)5, (int)33, (int)5, (int)4, (int)8, (int)4);
        int regionX = (int)Math.floor((double)chunkX * 16.0 / (double)this.regionSize);
        int regionZ = (int)Math.floor((double)chunkZ * 16.0 / (double)this.regionSize);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        this.generatePositions(regionX, regionZ, random, mutable, positions);
        this.generateSpheres(chunkX, chunkZ, mutable, positions, primer);
    }

    private void generatePositions(int regionX, int regionZ, Random random, BlockPos.MutableBlockPos mutable, List<BlockPos> positions) {
        int genCount = 0;
        block0: for (int i = 0; i < this.count || genCount < this.minCount && i < this.count * 2; ++i) {
            double maxFeatureRadius = this.radius;
            double midHeight = maxFeatureRadius + (double)random.nextInt((int)((double)(this.maxHeight - this.minHeight) - maxFeatureRadius * 2.0)) + (double)this.minHeight;
            int regionCenterX = regionX * this.regionSize + this.regionSize / 2;
            int regionCenterZ = regionZ * this.regionSize + this.regionSize / 2;
            int randomSpace = (int)((double)this.regionSize - maxFeatureRadius * 2.0);
            int featureCenterX = random.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
            int featureCenterZ = random.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ;
            mutable.func_189532_c((double)featureCenterX, midHeight, (double)featureCenterZ);
            for (BlockPos position : positions) {
                double minDistance = (double)this.radius + maxFeatureRadius;
                if (!(this.Distance3D((BlockPos)mutable, position) < minDistance * minDistance)) continue;
                continue block0;
            }
            positions.add(mutable.func_185334_h());
            ++genCount;
        }
    }

    private void generateSpheres(int chunkX, int chunkZ, BlockPos.MutableBlockPos mutable, List<BlockPos> positions, ChunkPrimer primer) {
        int chunkMinX = chunkX * 16;
        int chunkMinZ = chunkZ * 16;
        SphereGenerationRunnable.GenerateSpheres(primer, this.state, this.requiredBlocks, this.largeNoiseArray, this.largeDeformNoiseArray, chunkMinX, chunkMinZ, positions, this.radius, 32);
    }

    private boolean canBeInChunk(BlockPos center, int chunkMinX, int chunkMinZ) {
        return center.func_177958_n() + this.radius > chunkMinX && center.func_177958_n() - this.radius < chunkMinZ + 16 && center.func_177952_p() + this.radius > chunkMinZ && center.func_177952_p() - this.radius < chunkMinZ + 16;
    }

    private boolean checkDistance(BlockPos.MutableBlockPos mutable, BlockPos center, double deformNoise, int chunkMinX, int chunkMinZ) {
        return this.Distance3D((BlockPos)mutable, center) <= (double)(this.radius * this.radius) * deformNoise;
    }

    private void setBlockState(ChunkPrimer primer, int x, int y, int z) {
        primer.func_177855_a(x, y, z, this.state);
    }

    private boolean isBlockAcceptable(ChunkPrimer primer, int x, int y, int z) {
        if (this.requiredBlocks.isEmpty()) {
            return true;
        }
        IBlockState state = primer.func_177856_a(x, y, z);
        for (BlockPredicate predicate : this.requiredBlocks) {
            if (!predicate.test(state)) continue;
            return true;
        }
        return false;
    }

    public double Distance3D(BlockPos pos, BlockPos pos2) {
        double d0 = pos.func_177958_n() - pos2.func_177958_n();
        double d1 = pos.func_177956_o() - pos2.func_177956_o();
        double d2 = pos.func_177952_p() - pos2.func_177952_p();
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ, Random random) {
        if (this.populate) {
            long seed = world.func_72905_C();
            this.terrainNoise = new OpenSimplexNoiseGeneratorOctaves(seed);
            this.generateNoise(5, 33, 5, chunkX * 16, 0, chunkZ * 16, 4, 8, 4);
            NumberHelper.interpolate((double[])this.smallNoiseArray, (double[])this.largeNoiseArray, (int)5, (int)33, (int)5, (int)4, (int)8, (int)4);
            NumberHelper.interpolate((double[])this.smallDeformNoiseArray, (double[])this.largeDeformNoiseArray, (int)5, (int)33, (int)5, (int)4, (int)8, (int)4);
            int regionX = (int)Math.floor((double)chunkX * 16.0 / (double)this.regionSize);
            int regionZ = (int)Math.floor((double)chunkZ * 16.0 / (double)this.regionSize);
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            int genCount = 0;
            block0: for (int i = 0; i < this.count || genCount < this.minCount; ++i) {
                double maxFeatureRadius = this.radius;
                double midHeight = maxFeatureRadius + (double)random.nextInt((int)(256.0 - maxFeatureRadius * 2.0));
                int regionCenterX = regionX * this.regionSize + this.regionSize / 2;
                int regionCenterZ = regionZ * this.regionSize + this.regionSize / 2;
                int randomSpace = (int)((double)this.regionSize - maxFeatureRadius * 2.0);
                int featureCenterX = random.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
                int featureCenterZ = random.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ;
                BlockPos pos = new BlockPos((double)featureCenterX, midHeight, (double)featureCenterZ);
                for (BlockPos position : positions) {
                    double minDistance = (double)this.radius + maxFeatureRadius;
                    if (!(this.Distance3D(pos, position) < minDistance)) continue;
                    continue block0;
                }
                positions.add(pos);
                ++genCount;
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 256; ++y) {
                        for (BlockPos center : positions) {
                            int chunkMinX = chunkX * 16;
                            int chunkMinZ = chunkZ * 16;
                            int chunkMaxX = chunkX * 16 + 16;
                            int chunkMaxZ = chunkZ * 16 + 16;
                            BlockPos pos = new BlockPos(chunkMinX + x + 2, y, chunkMinZ + z + 2);
                            double noise = this.largeNoiseArray[(x * 16 + z) * 256 + y];
                            double deformNoise = this.largeNoiseArray[(x * 16 + z) * 256 + y] * 0.75 + 0.25;
                            if (!(noise > 0.5) || !(this.Distance3D(pos, center) <= (double)this.radius * deformNoise) || world.func_180495_p(pos) != Blocks.field_150424_aL.func_176223_P()) continue;
                            world.func_175656_a(pos, this.state);
                        }
                    }
                }
            }
        }
    }

    @Override
    public GenLayer getLayer(World world, GenLayer parent) {
        return null;
    }

    @Override
    public int getRegionSize() {
        return this.regionSize;
    }

    public static class SphereGenerationRunnable
    implements Runnable {
        private final Collection<BlockPos> toPlace;
        private final ChunkPrimer primer;
        private final double[] largeNoiseArray;
        private final double[] largeDeformNoiseArray;
        private final int chunkMinX;
        private final int chunkMinZ;
        private final List<BlockPos> positions;
        private final int radius;
        private final int yStart;
        private final int layerSize;
        private final List<BlockPredicate> requiredBlocks;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void GenerateSpheres(ChunkPrimer primer, IBlockState state, List<BlockPredicate> requiredBlocks, double[] largeNoiseArray, double[] largeDeformNoiseArray, int chunkMinX, int chunkMinZ, List<BlockPos> positions, int radius, int layerSize) {
            Collection<BlockPos> toPlace = Collections.synchronizedCollection(new ArrayList());
            ArrayList<Callable<Object>> callables = new ArrayList<Callable<Object>>();
            for (int yStart = 0; yStart < 256; yStart += layerSize) {
                callables.add(Executors.callable(new SphereGenerationRunnable(toPlace, primer, requiredBlocks, largeNoiseArray, largeDeformNoiseArray, yStart, layerSize, chunkMinX, chunkMinZ, positions, radius)));
            }
            try {
                ConfigurationManager.getInstance().getExecutor().invokeAll(callables);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Collection<BlockPos> collection = toPlace;
            synchronized (collection) {
                for (BlockPos pos : toPlace) {
                    primer.func_177855_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), state);
                }
            }
        }

        private SphereGenerationRunnable(Collection<BlockPos> toPlace, ChunkPrimer primer, List<BlockPredicate> requiredBlocks, double[] largeNoiseArray, double[] largeDeformNoiseArray, int yStart, int layerSize, int chunkMinX, int chunkMinZ, List<BlockPos> positions, int radius) {
            this.largeNoiseArray = largeNoiseArray;
            this.largeDeformNoiseArray = largeDeformNoiseArray;
            this.chunkMinX = chunkMinX;
            this.chunkMinZ = chunkMinZ;
            this.positions = positions;
            this.radius = radius;
            this.yStart = yStart;
            this.layerSize = layerSize;
            this.primer = primer;
            this.requiredBlocks = requiredBlocks;
            this.toPlace = toPlace;
        }

        @Override
        public void run() {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int y = this.yStart; y < 256 && y < this.yStart + this.layerSize; ++y) {
                for (int x = 0; x < 16; ++x) {
                    block2: for (int z = 0; z < 16; ++z) {
                        double noise = this.largeNoiseArray[(x * 16 + z) * 256 + y];
                        if (!(noise > 0.5)) continue;
                        double deformNoise = this.largeDeformNoiseArray[(x * 16 + z) * 256 + y];
                        mutable.func_181079_c(this.chunkMinX + x, y, this.chunkMinZ + z);
                        boolean blockAcceptable = false;
                        for (BlockPos center : this.positions) {
                            if (!this.canBeInChunk(center, this.chunkMinX, this.chunkMinZ) || !this.checkDistance(mutable, center, deformNoise, this.chunkMinX, this.chunkMinZ)) continue;
                            if (!blockAcceptable && !this.isBlockAcceptable(this.primer, x, y, z)) continue block2;
                            blockAcceptable = true;
                            this.toPlace.add(new BlockPos(x, y, z));
                            continue block2;
                        }
                    }
                }
            }
        }

        private boolean canBeInChunk(BlockPos center, int chunkMinX, int chunkMinZ) {
            if (center.func_177958_n() - this.radius > chunkMinX + 16) {
                return false;
            }
            if (center.func_177958_n() + this.radius < chunkMinX) {
                return false;
            }
            if (center.func_177952_p() - this.radius > chunkMinZ + 16) {
                return false;
            }
            return center.func_177952_p() + this.radius >= chunkMinZ;
        }

        private boolean checkDistance(BlockPos.MutableBlockPos mutable, BlockPos center, double deformNoise, int chunkMinX, int chunkMinZ) {
            return this.Distance3D((BlockPos)mutable, center) <= (double)(this.radius * this.radius) * deformNoise;
        }

        public double Distance3D(BlockPos pos, BlockPos pos2) {
            double d0 = pos.func_177958_n() - pos2.func_177958_n();
            double d1 = pos.func_177956_o() - pos2.func_177956_o();
            double d2 = pos.func_177952_p() - pos2.func_177952_p();
            return d0 * d0 + d1 * d1 + d2 * d2;
        }

        private boolean isBlockAcceptable(ChunkPrimer primer, int x, int y, int z) {
            if (this.requiredBlocks.isEmpty()) {
                return true;
            }
            IBlockState state = primer.func_177856_a(x, y, z);
            for (BlockPredicate predicate : this.requiredBlocks) {
                if (!predicate.test(state)) continue;
                return true;
            }
            return false;
        }
    }
}

