/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.data.BlockPredicate;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.layer.GenLayer;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/FluidPocketGenerator", classExplaination="This file is for the FluidPocketGenerator. This generator generates pockets of fluid, similar to lava pockets in the nether.")
public class FluidPocketGenerator
implements IGenerator {
    private final int count;
    private final boolean requiresAir;
    private int minHeight = 4;
    private int maxHeight = 250;
    private final IBlockState block;
    private final List<BlockPredicate> requiredBlocks = new ArrayList<BlockPredicate>();

    @ScriptMethodDocumentation(args="ItemBlockData, int, boolean", usage="block to generate, pockets per chunk, whether it requires air", notes="This constructs a FluidPocketGenerator. The boolean is for if one side of the pocket must have air, not counting the top. This is so the fluid flows prettily.")
    public FluidPocketGenerator(ItemBlockData data, int count, boolean requiresAir) throws Exception {
        this.block = data.buildBlockState();
        this.count = count;
        this.requiresAir = requiresAir;
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="required block", notes="Adds a block the generator is allowed to generate a pocket under. By default can generate under any block.")
    public void addRequiredBlock(ItemBlockData data) throws Exception {
        this.requiredBlocks.add(data.buildBlockPredicate());
    }

    @ScriptMethodDocumentation(args="int, int", usage="min height, max height", notes="Sets the min and max heights this generator can generate at. Default is 4 and 250.")
    public void setHeight(int min, int max) {
        this.minHeight = min;
        this.maxHeight = max;
    }

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ, Random rand) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < this.count; ++i) {
            pos.func_181079_c(chunkX * 16 + rand.nextInt(16) + 8, rand.nextInt(this.maxHeight - this.minHeight + 1) + this.minHeight, chunkZ * 16 + rand.nextInt(16) + 8);
            if (!this.isBlockAcceptable(world, pos.func_177984_a())) continue;
            int solid = 0;
            int air = 0;
            if (this.isBlockAcceptable(world, pos.func_177978_c())) {
                ++solid;
            }
            if (this.isBlockAcceptable(world, pos.func_177968_d())) {
                ++solid;
            }
            if (this.isBlockAcceptable(world, pos.func_177974_f())) {
                ++solid;
            }
            if (this.isBlockAcceptable(world, pos.func_177976_e())) {
                ++solid;
            }
            if (this.isBlockAcceptable(world, pos.func_177977_b())) {
                ++solid;
            }
            if (!this.requiresAir && solid == 5) {
                world.func_180501_a((BlockPos)pos, this.block, 2);
                world.func_189507_a((BlockPos)pos, this.block, rand);
                continue;
            }
            if (solid != 4) continue;
            if (world.func_175623_d(pos.func_177978_c())) {
                ++air;
            }
            if (world.func_175623_d(pos.func_177968_d())) {
                ++air;
            }
            if (world.func_175623_d(pos.func_177974_f())) {
                ++air;
            }
            if (world.func_175623_d(pos.func_177976_e())) {
                ++air;
            }
            if (world.func_175623_d(pos.func_177977_b())) {
                ++air;
            }
            if (air != 1) continue;
            world.func_180501_a((BlockPos)pos, this.block, 2);
            world.func_189507_a((BlockPos)pos, this.block, rand);
        }
    }

    private boolean isBlockAcceptable(World world, BlockPos pos) {
        if (this.requiredBlocks.isEmpty() && !world.func_175623_d(pos)) {
            return true;
        }
        for (BlockPredicate predicate : this.requiredBlocks) {
            if (!predicate.test(world.func_180495_p(pos))) continue;
            return true;
        }
        return false;
    }

    @Override
    public GenLayer getLayer(World world, GenLayer parent) {
        return null;
    }
}

