/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.data.BlockPredicate;
import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.layer.GenLayer;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/ScatteredPillarGenerator", classExplaination="This file is for the ScatteredPillarGenerator. This generator generates scattered clusters of block pillars per chunk. Similar to how sugarcane is generated.")
public class ScatteredPillarGenerator
implements IGenerator {
    private final int clusterCount;
    private final int clusterSize;
    private int minHeight = 4;
    private int maxHeight = 250;
    private final IBlockState block;
    private final int minPillarHeight;
    private final int maxPillarHeight;
    private final List<BlockPredicate> requiredBlocks = new ArrayList<BlockPredicate>();
    private final List<BlockPredicate> requiredAdjacentBlocks = new ArrayList<BlockPredicate>();

    @ScriptMethodDocumentation(args="ItemBlockData, int, int, int, int", usage="block to generate, min height, max height, clusters per chunk, blocks per cluster", notes="This constructs a ScatteredPillarGenerator.")
    public ScatteredPillarGenerator(ItemBlockData data, int minHeight, int maxHeight, int clusterCount, int clusterSize) throws Exception {
        this.block = data.buildBlockState();
        this.clusterCount = clusterCount;
        this.clusterSize = clusterSize;
        this.minPillarHeight = minHeight;
        this.maxPillarHeight = maxHeight;
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="required block", notes="Adds a block the generator is allowed to generate pillars on top of.")
    public void addRequiredBlock(ItemBlockData data) throws Exception {
        this.requiredBlocks.add(data.buildBlockPredicate());
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="required block", notes="Adds a block the generator must have adjacent to the block below it to generate. Mostly for generating things next to water or lava.")
    public void addRequiredAdjacentBlock(ItemBlockData data) throws Exception {
        this.requiredAdjacentBlocks.add(data.buildBlockPredicate());
    }

    @ScriptMethodDocumentation(args="int, int", usage="min height, max height", notes="Sets the min and max heights this generator can generate at. Default is 4 and 250.")
    public void setHeight(int min, int max) {
        this.minHeight = min;
        this.maxHeight = max;
    }

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ, Random rand) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < this.clusterCount; ++i) {
            int x = chunkX * 16 + rand.nextInt(15) + 8;
            int y = rand.nextInt(this.maxHeight - this.minHeight + 1 - 4) + this.minHeight;
            int z = chunkZ * 16 + rand.nextInt(15) + 8;
            block1: for (int index = 0; index < this.clusterSize; ++index) {
                pos.func_181079_c(x + rand.nextInt(8) - rand.nextInt(8), y + rand.nextInt(4) - rand.nextInt(4), z + rand.nextInt(8) - rand.nextInt(8));
                if (!world.func_175623_d((BlockPos)pos)) continue;
                block2: for (BlockPredicate predicate : this.requiredBlocks) {
                    BlockPos down;
                    if (!predicate.test(world.func_180495_p(down = pos.func_177977_b()))) continue;
                    if (this.requiredAdjacentBlocks.isEmpty()) {
                        int height = rand.nextInt(Math.max(1, this.maxPillarHeight - this.minPillarHeight + 1)) + this.minPillarHeight;
                        for (int i1 = 0; i1 < height && i1 + height < 255; ++i1) {
                            BlockPos up = pos.func_177967_a(EnumFacing.UP, i1);
                            if (!world.func_175623_d(up)) continue;
                            world.func_180501_a(up, this.block, 2);
                        }
                        continue block1;
                    }
                    for (BlockPredicate adjacent : this.requiredAdjacentBlocks) {
                        if (!adjacent.test(world.func_180495_p(down.func_177974_f())) && !adjacent.test(world.func_180495_p(down.func_177976_e())) && !adjacent.test(world.func_180495_p(down.func_177978_c())) && !adjacent.test(world.func_180495_p(down.func_177968_d()))) continue;
                        int height = rand.nextInt(Math.max(1, this.maxPillarHeight - this.minPillarHeight + 1)) + this.minPillarHeight;
                        for (int i1 = 0; i1 < height && i1 + height < 255; ++i1) {
                            BlockPos up = pos.func_177967_a(EnumFacing.UP, i1);
                            if (!world.func_175623_d(up)) continue;
                            world.func_180501_a(up, this.block, 2);
                        }
                        continue block2;
                    }
                }
            }
        }
    }

    @Override
    public GenLayer getLayer(World world, GenLayer parent) {
        return null;
    }
}

