/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.NumberHelper;
import com.bloodnbonesgaming.lib.util.noise.OpenSimplexNoiseGeneratorOctaves;
import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import com.bloodnbonesgaming.topography.util.MathUtil;
import com.bloodnbonesgaming.topography.world.decorator.DecorationData;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import com.bloodnbonesgaming.topography.world.layer.GenLayerBiomeSkyIslands;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.layer.GenLayer;

public class SkyIslandGenerator
implements IGenerator {
    private final List<SkyIslandData> skyIslandData = new ArrayList<SkyIslandData>();
    private Map<SkyIslandData, Map<BlockPos, SkyIslandType>> islandPositions = new LinkedHashMap<SkyIslandData, Map<BlockPos, SkyIslandType>>();
    private final Random islandPositionRandom = new Random();
    private double regionSize = 464.0;
    private int currentRegionX = -100000000;
    private int currentRegionZ = -100000000;
    final Random rand = new Random();
    protected OpenSimplexNoiseGeneratorOctaves terrainNoise;
    final Random mountainRand = new Random();
    double[] smallNoiseArray = new double[825];
    double[] largeNoiseArray = new double[65536];
    protected NoiseGeneratorPerlin surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
    protected double[] depthBuffer = new double[256];
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    protected static final IBlockState RED_SANDSTONE = Blocks.field_180395_cM.func_176223_P();
    protected static final IBlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
        long seed = world.func_72905_C();
        this.terrainNoise = new OpenSimplexNoiseGeneratorOctaves(seed);
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.mountainRand.setSeed((long)((int)Math.floor((double)chunkX * 16.0 / (double)this.getRegionSize())) * 341873128712L + (long)((int)Math.floor((double)chunkZ * 16.0 / (double)this.getRegionSize())) * 132897987541L + seed);
        this.generateIslands(seed, chunkX, chunkZ, primer);
        this.replaceBiomeBlocks(seed, chunkX, chunkZ, primer);
        this.genDecorations(seed, chunkX, chunkZ, primer);
    }

    private void generateIslandPositions(long worldSeed) {
        this.islandPositionRandom.setSeed((long)this.currentRegionX * 341873128712L + (long)this.currentRegionZ * 132897987541L + worldSeed);
        this.islandPositions = new LinkedHashMap<SkyIslandData, Map<BlockPos, SkyIslandType>>();
        for (SkyIslandData data : this.skyIslandData) {
            int genCount = 0;
            block1: for (int i = 0; i < data.getCount() || genCount < data.getMinCount(); ++i) {
                Map<BlockPos, SkyIslandType> positions;
                double maxFeatureRadius = data.getRadius();
                double midHeight = Math.min(maxFeatureRadius, 110.0) + (double)this.islandPositionRandom.nextInt((int)Math.max(220.0 - maxFeatureRadius * 2.0, 1.0));
                int regionCenterX = (int)((double)this.currentRegionX * this.regionSize + this.regionSize / 2.0);
                int regionCenterZ = (int)((double)this.currentRegionZ * this.regionSize + this.regionSize / 2.0);
                int randomSpace = (int)(this.regionSize - maxFeatureRadius * 2.0);
                int featureCenterX = this.islandPositionRandom.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
                int featureCenterZ = this.islandPositionRandom.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ;
                BlockPos pos = new BlockPos((double)featureCenterX, midHeight, (double)featureCenterZ);
                for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> set : this.islandPositions.entrySet()) {
                    double minDistance = (double)set.getKey().getRadius() + maxFeatureRadius + 25.0;
                    for (Map.Entry<BlockPos, SkyIslandType> islandPos : set.getValue().entrySet()) {
                        if (!(SkyIslandGenerator.getDistance(pos, islandPos.getKey()) < minDistance)) continue;
                        continue block1;
                    }
                }
                if (!this.islandPositions.containsKey(data)) {
                    this.islandPositions.put(data, new LinkedHashMap());
                }
                if (data.isRandomIslands()) {
                    positions = this.islandPositions.get(data);
                    positions.put(pos, data.getType(this.islandPositionRandom.nextInt(128)));
                } else {
                    positions = this.islandPositions.get(data);
                    positions.put(pos, data.getType(genCount));
                }
                ++genCount;
            }
        }
    }

    public Map<SkyIslandData, Map<BlockPos, SkyIslandType>> getIslandPositions(long worldSeed, int x, int z) {
        if ((int)Math.floor(Math.floor((double)x / 16.0) * 16.0 / this.regionSize) != this.currentRegionX || (int)Math.floor(Math.floor((double)z / 16.0) * 16.0 / this.regionSize) != this.currentRegionZ) {
            this.currentRegionX = (int)Math.floor(Math.floor((double)x / 16.0) * 16.0 / this.regionSize);
            this.currentRegionZ = (int)Math.floor(Math.floor((double)z / 16.0) * 16.0 / this.regionSize);
            this.generateIslandPositions(worldSeed);
        }
        return this.islandPositions;
    }

    public static double getDistance(BlockPos pos, BlockPos pos2) {
        double d0 = pos.func_177958_n() - pos2.func_177958_n();
        double d2 = pos.func_177952_p() - pos2.func_177952_p();
        return Math.sqrt(d0 * d0 + d2 * d2);
    }

    @Override
    public int getRegionSize() {
        return (int)this.regionSize;
    }

    public void setRegionSize(int size) {
        this.regionSize = size * 16;
    }

    public SkyIslandData addSkyIslands(int radius, int count, boolean randomTypes) {
        SkyIslandData data = new SkyIslandData();
        data.setRadius(radius);
        data.setCount(count);
        data.setRandomTypes(randomTypes);
        this.skyIslandData.add(data);
        return data;
    }

    public SkyIslandData addSkyIslands(int radius, int count, boolean randomTypes, int minCount) {
        SkyIslandData data = new SkyIslandData();
        data.setRadius(radius);
        data.setCount(count);
        data.setRandomTypes(randomTypes);
        data.setMinCount(minCount);
        this.skyIslandData.add(data);
        return data;
    }

    private void generateNoise(double[] array, int arraySizeX, int arraySizeY, int arraySizeZ, int x, int y, int z, int xCoordinateScale, int yCoordinateScale, int zCoordinateScale) {
        for (int xI = 0; xI < arraySizeX; ++xI) {
            for (int zI = 0; zI < arraySizeZ; ++zI) {
                for (int yI = 0; yI < arraySizeY; ++yI) {
                    double noise;
                    int index = (xI * arraySizeX + zI) * arraySizeY + yI;
                    array[index] = noise = this.terrainNoise.eval((double)(x + xI * xCoordinateScale) / 128.0, (double)(y + yI * yCoordinateScale) / 32.0, (double)(z + zI * zCoordinateScale) / 128.0, 3, 0.5);
                }
            }
        }
    }

    public void flowWaterVertical(ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                boolean water = false;
                for (int y = 255; y >= 0; --y) {
                    IBlockState state = primer.func_177856_a(x, y, z);
                    if (state == Blocks.field_150355_j.func_176223_P()) {
                        water = true;
                        continue;
                    }
                    if (water && state == Blocks.field_150350_a.func_176223_P()) {
                        primer.func_177855_a(x, y, z, Blocks.field_150355_j.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(8)));
                        water = true;
                        continue;
                    }
                    water = false;
                }
            }
        }
    }

    public void generateIslands(long seed, int chunkX, int chunkZ, ChunkPrimer primer) {
        this.generateNoise(this.smallNoiseArray, 5, 33, 5, chunkX * 16, 0, chunkZ * 16, 4, 8, 4);
        NumberHelper.interpolate((double[])this.smallNoiseArray, (double[])this.largeNoiseArray, (int)5, (int)33, (int)5, (int)4, (int)8, (int)4);
        for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> entry : this.getIslandPositions(seed, chunkX * 16, chunkZ * 16).entrySet()) {
            SkyIslandData data = entry.getKey();
            int chunkBlockX = chunkX * 16;
            int chunkBlockZ = chunkZ * 16;
            for (Map.Entry<BlockPos, SkyIslandType> islandPos : entry.getValue().entrySet()) {
                int featureCenterX = islandPos.getKey().func_177958_n();
                int featureCenterZ = islandPos.getKey().func_177952_p();
                int midHeight = islandPos.getKey().func_177956_o();
                int maxFeatureRadius = data.getRadius();
                for (double x = 0.0; x < 16.0; x += 1.0) {
                    double realX = x + (double)chunkBlockX;
                    double xDistance = Math.pow(Math.abs((double)featureCenterX - realX), 2.0);
                    for (double z = 0.0; z < 16.0; z += 1.0) {
                        double realZ = z + (double)chunkBlockZ;
                        double zDistance = Math.pow(Math.abs((double)featureCenterZ - realZ), 2.0);
                        double maxNoiseDistance = ((double)maxFeatureRadius - Math.sqrt(xDistance + zDistance)) * 1.5;
                        double noiseDistance = (double)maxFeatureRadius * 0.32;
                        double noise2 = this.terrainNoise.eval(realX / noiseDistance, realZ / noiseDistance, 3, 0.5);
                        if (!(Math.sqrt(xDistance + zDistance) <= (double)maxFeatureRadius)) continue;
                        SkyIslandType type = islandPos.getValue();
                        Map<MinMaxBounds, IBlockState> boundsToState = type.getBoundsToStateMap();
                        for (double y = 0.0; y < (double)midHeight; y += 1.0) {
                            double skewNoise = this.largeNoiseArray[(int)((x * 16.0 + z) * 256.0 + y)] * 2.0 - 1.0;
                            double skewedNoise = this.terrainNoise.eval((realX + 16.0 * skewNoise) / noiseDistance, (realZ + 16.0 * skewNoise) / noiseDistance, 3, 0.5);
                            double bottomHeight = (double)midHeight - skewedNoise * (maxNoiseDistance - noiseDistance * noise2);
                            double topHeight = skewedNoise * ((maxNoiseDistance - noiseDistance * noise2) / 4.0);
                            int mid = (int)Math.floor((topHeight + (double)midHeight - bottomHeight) / 2.0 + bottomHeight);
                            double distance = Math.floor((topHeight + (double)midHeight - bottomHeight) / 2.0);
                            IBlockState state = type.getMainBlock();
                            for (Map.Entry<MinMaxBounds, IBlockState> bounds : boundsToState.entrySet()) {
                                if (!bounds.getKey().func_192514_a((float)(Math.floor(Math.abs(y - (double)mid) + 1.0) / distance))) continue;
                                state = bounds.getValue();
                            }
                            if (bottomHeight < y) {
                                primer.func_177855_a((int)x, (int)y, (int)z, state);
                            }
                            for (Map.Entry<MinMaxBounds, IBlockState> bounds : boundsToState.entrySet()) {
                                if (!bounds.getKey().func_192514_a((float)(Math.floor(Math.abs(y + (double)midHeight - (double)mid) + 1.0) / distance))) continue;
                                state = bounds.getValue();
                            }
                            if (!(topHeight > y)) continue;
                            primer.func_177855_a((int)x, (int)(y + (double)midHeight), (int)z, state);
                        }
                    }
                }
            }
        }
    }

    public void replaceBiomeBlocks(long seed, int chunkX, int chunkZ, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                BlockPos pos = new BlockPos(chunkX * 16 + x, 0, chunkZ * 16 + z);
                for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> set : this.getIslandPositions(seed, chunkX * 16, chunkZ * 16).entrySet()) {
                    SkyIslandData data = set.getKey();
                    double minDistance = data.getRadius();
                    for (Map.Entry<BlockPos, SkyIslandType> islandPos : set.getValue().entrySet()) {
                        Biome biome;
                        if (!(MathUtil.getDistance(pos, islandPos.getKey()) <= minDistance)) continue;
                        SkyIslandType type = islandPos.getValue();
                        if (!type.isGenBiomeBlocks() || (biome = Biome.func_150568_d((int)type.getBiome())) == Biomes.field_185440_P) continue block1;
                        this.genBiomeTerrainBlocks(biome, this.rand, primer, chunkX * 16 + x, chunkZ * 16 + z, islandPos.getKey().func_177956_o(), 16.0);
                        continue block1;
                    }
                }
            }
        }
    }

    public void genBiomeTerrainBlocks(Biome biome, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, int islandMid, double noiseVal) {
        int i = islandMid;
        IBlockState iblockstate = biome.field_76752_A;
        IBlockState iblockstate1 = biome.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = z & 0xF;
        int i1 = x & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2 != Blocks.field_150348_b.func_176223_P()) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = AIR;
                    iblockstate1 = Blocks.field_150348_b.func_176223_P();
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = biome.field_76752_A;
                    iblockstate1 = biome.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = biome.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? ICE : WATER;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = AIR;
                    iblockstate1 = Blocks.field_150348_b.func_176223_P();
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? RED_SANDSTONE : SANDSTONE;
        }
    }

    private void genDecorations(long seed, int chunkX, int chunkZ, ChunkPrimer primer) {
        BlockPos pos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        block0: for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> set : this.getIslandPositions(seed, chunkX * 16, chunkZ * 16).entrySet()) {
            SkyIslandData data = set.getKey();
            double minDistance = data.getRadius();
            for (Map.Entry<BlockPos, SkyIslandType> islandPos : set.getValue().entrySet()) {
                if (!(SkyIslandGenerator.getDistance(pos, islandPos.getKey()) < minDistance + 16.0)) continue;
                SkyIslandType type = islandPos.getValue();
                for (DecorationData decoration : type.getDecorators()) {
                    decoration.generateForSkyIsland(seed, chunkX, chunkZ, primer, islandPos.getKey(), data, type, this);
                }
                break block0;
            }
        }
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ, Random rand) {
        long seed = world.func_72905_C();
        BlockFalling.field_149832_M = true;
        int i = chunkX * 16;
        int j = chunkZ * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        this.rand.setSeed(seed);
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * k + (long)chunkZ * l ^ seed);
        BlockPos pos = new BlockPos(i, 0, j);
        block0: for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> set : this.getIslandPositions(seed, i, j).entrySet()) {
            SkyIslandData data = set.getKey();
            double minDistance = data.getRadius();
            for (Map.Entry<BlockPos, SkyIslandType> islandPos : set.getValue().entrySet()) {
                if (!(MathUtil.getDistance(pos, islandPos.getKey()) < minDistance + 16.0)) continue;
                SkyIslandType type = islandPos.getValue();
                Biome typeBiome = Biome.func_150568_d((int)type.getBiome());
                if (type.isGenDecorations() && typeBiome != Biomes.field_185440_P) {
                    typeBiome.func_180624_a(world, this.rand, new BlockPos(i, 0, j));
                }
                if (!type.genAnimals()) break block0;
                WorldEntitySpawner.func_77191_a((World)world, (Biome)typeBiome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
                break block0;
            }
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                BlockPos blockpos1 = world.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (world.func_175675_v(blockpos2)) {
                    world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                }
                if (!world.func_175708_f(blockpos1, true)) continue;
                world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
            }
        }
        BlockFalling.field_149832_M = false;
    }

    @Override
    public GenLayer getLayer(World world, GenLayer parent) {
        GenLayerBiomeSkyIslands biomes = new GenLayerBiomeSkyIslands(world.func_72905_C(), this);
        return biomes;
    }
}

