/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.noise.OpenSimplexNoiseGeneratorOctaves;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.Topography;
import com.bloodnbonesgaming.topography.config.ConfigPreset;
import com.bloodnbonesgaming.topography.config.ConfigurationManager;
import com.bloodnbonesgaming.topography.config.DimensionDefinition;
import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandDataV2;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import com.bloodnbonesgaming.topography.util.BWMUtil;
import com.bloodnbonesgaming.topography.util.MathUtil;
import com.bloodnbonesgaming.topography.util.noise.RunnableSimplexNoise1x1;
import com.bloodnbonesgaming.topography.world.decorator.DecorationData;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import com.bloodnbonesgaming.topography.world.generator.IStructureHandler;
import com.bloodnbonesgaming.topography.world.generator.SkyIslandGenerator;
import com.bloodnbonesgaming.topography.world.generator.structure.SkyIslandMineshaftGenerator;
import com.bloodnbonesgaming.topography.world.generator.structure.SkyIslandStrongholdSimpleGenerator;
import com.bloodnbonesgaming.topography.world.generator.structure.SkyIslandVillageGenerator;
import com.bloodnbonesgaming.topography.world.layer.GenLayerBiomeSkyIslands;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/sky_islands/SkyIslandGeneratorV2", classExplaination="This generator generates sky islands in a pseudo-random pattern within grid regions, allowing for a high level of generation control while giving the appearance of randomness. These can be created in a dimension file using 'new SkyIslandGeneratorV2()'. When a player spawns in a dimension with this generator, they will spawn in the center of the first island to be generated.")
public class SkyIslandGeneratorV2
extends SkyIslandGenerator
implements IStructureHandler {
    OpenSimplexNoiseGeneratorOctaves horizontalConeSkewNoise = null;
    private MapGenMineshaft mineshaft;
    private final MapGenStronghold stronghold = new SkyIslandStrongholdSimpleGenerator(this);
    private MapGenVillage village;
    private boolean BWMVillageCompat = false;
    private boolean BWMMineshaftCompat = false;
    double[] islandNoiseArray = new double[65536];
    double[] islandWaterNoiseArray = new double[65536];
    protected final List<SkyIslandDataV2> SkyIslandDataV2 = new ArrayList<SkyIslandDataV2>();
    private Map<SkyIslandData, Map<BlockPos, SkyIslandType>> islandPositions = new LinkedHashMap<SkyIslandData, Map<BlockPos, SkyIslandType>>();
    private final Random islandPositionRandom = new Random();
    private double regionSize = 464.0;
    private int currentRegionX = -100000000;
    private int currentRegionZ = -100000000;
    final Random rand = new Random();
    protected OpenSimplexNoiseGeneratorOctaves terrainNoise = null;
    final Random mountainRand = new Random();
    protected NoiseGeneratorPerlin surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
    protected double[] depthBuffer = new double[256];
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    protected static final IBlockState RED_SANDSTONE = Blocks.field_180395_cM.func_176223_P();
    protected static final IBlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();

    @Override
    public void generate(World world, ChunkPrimer primer, int chunkX, int chunkZ, Random random) {
        if (this.horizontalConeSkewNoise == null) {
            this.horizontalConeSkewNoise = new OpenSimplexNoiseGeneratorOctaves(world.func_72905_C());
        }
        long seed = world.func_72905_C();
        if (this.terrainNoise == null) {
            this.terrainNoise = new OpenSimplexNoiseGeneratorOctaves(seed);
        }
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.mountainRand.setSeed((long)((int)Math.floor((double)chunkX * 16.0 / (double)this.getRegionSize())) * 341873128712L + (long)((int)Math.floor((double)chunkZ * 16.0 / (double)this.getRegionSize())) * 132897987541L + seed);
        this.generateIslands(seed, chunkX, chunkZ, primer);
        this.replaceBiomeBlocks(seed, chunkX, chunkZ, primer);
        this.genDecorations(seed, chunkX, chunkZ, primer);
    }

    @Override
    public void generateIslands(long seed, int chunkX, int chunkZ, ChunkPrimer primer) {
        for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> entry : this.getIslandPositions(seed, chunkX * 16, chunkZ * 16).entrySet()) {
            SkyIslandDataV2 data = (SkyIslandDataV2)entry.getKey();
            int chunkBlockX = chunkX * 16;
            int chunkBlockZ = chunkZ * 16;
            for (Map.Entry<BlockPos, SkyIslandType> islandPos : entry.getValue().entrySet()) {
                if (!this.canBeInChunk(islandPos.getKey(), data.getHorizontalRadius(), chunkBlockX, chunkBlockZ)) continue;
                int featureCenterX = islandPos.getKey().func_177958_n();
                int featureCenterZ = islandPos.getKey().func_177952_p();
                int midHeight = islandPos.getKey().func_177956_o();
                double maxHorizontalRadius = data.getHorizontalRadius();
                double maxConeCoordinateSkewValue = maxHorizontalRadius * 0.6;
                double maxTopHeight = data.getTopHeight();
                double maxBottomHeight = data.getBottomHeight();
                double maxWaterHeight = data.getFluidDepth();
                double waterPercentage = Math.max(1.0 - islandPos.getValue().getFluidPercentage(), 1.0E-4);
                RunnableSimplexNoise1x1.getNoise(this.islandNoiseArray, this.horizontalConeSkewNoise, (int)((double)midHeight - maxBottomHeight), (int)((double)midHeight + maxTopHeight), chunkBlockX, chunkBlockZ, maxConeCoordinateSkewValue, 3, 0.5);
                RunnableSimplexNoise1x1.getNoise(this.islandWaterNoiseArray, this.horizontalConeSkewNoise, (int)((double)midHeight - maxBottomHeight), (int)((double)midHeight + maxTopHeight), chunkBlockX, chunkBlockZ, maxConeCoordinateSkewValue * 1.5, 3, 0.5);
                for (double x = 0.0; x < 16.0; x += 1.0) {
                    double realX = x + (double)chunkBlockX;
                    double xDistance = Math.pow(Math.abs((double)featureCenterX - realX), 2.0);
                    for (double z = 0.0; z < 16.0; z += 1.0) {
                        double realZ = z + (double)chunkBlockZ;
                        double zDistance = Math.pow(Math.abs((double)featureCenterZ - realZ), 2.0);
                        if (!(Math.sqrt(xDistance + zDistance) <= maxHorizontalRadius)) continue;
                        SkyIslandType type = islandPos.getValue();
                        Map<MinMaxBounds, IBlockState> boundsToState = type.getBoundsToStateMap();
                        for (double y = (double)midHeight - maxBottomHeight; y <= (double)midHeight + maxTopHeight; y += 1.0) {
                            double topHeight;
                            double horizontalConeCoordinateSkew = (this.islandNoiseArray[(int)((x * 16.0 + z) * 256.0 + y)] - 0.5) * maxConeCoordinateSkewValue;
                            double skewedXDistance = Math.pow(Math.abs((double)featureCenterX - (realX + horizontalConeCoordinateSkew)), 2.0);
                            double skewedZDistance = Math.pow(Math.abs((double)featureCenterZ - (realZ + horizontalConeCoordinateSkew)), 2.0);
                            double maxTopConeHeightAtPos = maxTopHeight / (maxHorizontalRadius * 0.7) * Math.sqrt(skewedXDistance + skewedZDistance);
                            double maxBottomConeHeightAtPos = maxBottomHeight / (maxHorizontalRadius * 0.7) * Math.sqrt(skewedXDistance + skewedZDistance);
                            double bottomHeight = maxBottomConeHeightAtPos + (double)midHeight - maxBottomHeight;
                            double waterHeightReductionNoise = this.islandWaterNoiseArray[(int)((x * 16.0 + z) * 256.0 + y)];
                            boolean water = false;
                            if (maxTopHeight - maxTopConeHeightAtPos > maxWaterHeight) {
                                if (y < (double)midHeight + maxWaterHeight) {
                                    water = true;
                                }
                                topHeight = (double)midHeight + maxTopHeight - maxTopConeHeightAtPos - (maxTopHeight - maxTopConeHeightAtPos - maxWaterHeight) / waterPercentage * waterHeightReductionNoise;
                            } else {
                                topHeight = (double)midHeight + maxTopHeight - maxTopConeHeightAtPos;
                            }
                            int mid = (int)Math.floor((topHeight - bottomHeight) / 2.0 + bottomHeight);
                            double distance = Math.floor((topHeight - bottomHeight) / 2.0);
                            IBlockState state = type.getMainBlock();
                            if (y < (double)midHeight) {
                                for (Map.Entry<MinMaxBounds, IBlockState> bounds : boundsToState.entrySet()) {
                                    if (!bounds.getKey().func_192514_a((float)(Math.floor(Math.abs(y - (double)mid) + 1.0) / distance))) continue;
                                    state = bounds.getValue();
                                }
                                if (!(bottomHeight <= y)) continue;
                                primer.func_177855_a((int)x, (int)y, (int)z, state);
                                continue;
                            }
                            for (Map.Entry<MinMaxBounds, IBlockState> bounds : boundsToState.entrySet()) {
                                if (!bounds.getKey().func_192514_a((float)(Math.floor(Math.abs(y + (double)midHeight - (double)mid) + 1.0) / distance))) continue;
                                state = bounds.getValue();
                                break;
                            }
                            if (topHeight >= y) {
                                primer.func_177855_a((int)x, (int)y, (int)z, state);
                                continue;
                            }
                            if (!water || !type.generateFluid()) continue;
                            primer.func_177855_a((int)x, (int)y, (int)z, type.getFluidBlock());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void replaceBiomeBlocks(long seed, int chunkX, int chunkZ, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                BlockPos pos = new BlockPos(chunkX * 16 + x, 0, chunkZ * 16 + z);
                for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> set : this.getIslandPositions(seed, chunkX * 16, chunkZ * 16).entrySet()) {
                    SkyIslandDataV2 data = (SkyIslandDataV2)set.getKey();
                    double minDistance = data.getHorizontalRadius();
                    for (Map.Entry<BlockPos, SkyIslandType> islandPos : set.getValue().entrySet()) {
                        Biome biome;
                        if (!(MathUtil.getDistance(pos, islandPos.getKey()) <= minDistance)) continue;
                        SkyIslandType type = islandPos.getValue();
                        if (!type.isGenBiomeBlocks() || (biome = Biome.func_150568_d((int)type.getBiome())) == Biomes.field_185440_P) continue block1;
                        this.genBiomeTerrainBlocks(biome, this.rand, primer, chunkX * 16 + x, chunkZ * 16 + z, islandPos.getKey().func_177956_o(), 2.625, type);
                        continue block1;
                    }
                }
            }
        }
    }

    public void genBiomeTerrainBlocks(Biome biome, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, int islandMid, double noiseVal, SkyIslandType type) {
        int i = islandMid;
        IBlockState iblockstate = biome.field_76752_A;
        IBlockState iblockstate1 = biome.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = z & 0xF;
        int i1 = x & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2 != type.getMainBlock()) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = AIR;
                    iblockstate1 = type.getMainBlock();
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = biome.field_76752_A;
                    iblockstate1 = biome.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = biome.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? ICE : WATER;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate == biome.field_76752_A && chunkPrimerIn.func_177856_a(i1, j1 + 1, l) == Blocks.field_150355_j.func_176223_P() ? biome.field_76753_B : iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = AIR;
                    iblockstate1 = type.getMainBlock();
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? RED_SANDSTONE : SANDSTONE;
        }
    }

    @ScriptMethodDocumentation(args="int, int, int, int, boolean", usage="horizontal radius, top height, bottom height, count, randomTypes", notes="Generates a SkyIslandDataV2 and returns it. Count is the number of times to attempt to generate sky islands, randomTypes is how to use the SkyIslandTypes. If randomTypes is set to true it will randomly choose a SkyIslandType from the list when an island is generated. If it is set to false, then every time an island is generated it will use the next SkyIslandType in the list. This allows you to guarantee certain islands are generated in a region.")
    public SkyIslandDataV2 addSkyIslands(int horizontalRadius, int topHeight, int bottomHeight, int count, boolean randomTypes) {
        SkyIslandDataV2 data = new SkyIslandDataV2();
        data.setHorizontalRadius(horizontalRadius);
        data.setTopHeight(topHeight);
        data.setBottomHeight(bottomHeight);
        data.setCount(count);
        data.setRandomTypes(randomTypes);
        this.SkyIslandDataV2.add(data);
        return data;
    }

    @ScriptMethodDocumentation(args="int, int, int, int, boolean, int", usage="horizontal radius, top height, bottom height, count, randomTypes, minCount", notes="Generates a SkyIslandDataV2 and returns it. Count is the number of times to attempt to generate sky islands, randomTypes is how to use the SkyIslandTypes, minCount is the minimum number of the sky islands which must be generated. If randomTypes is set to true it will randomly choose a SkyIslandType from the list when an island is generated. If it is set to false, then every time an island is generated it will use the next SkyIslandType in the list. This allows you to guarantee certain islands are generated in a region.")
    public SkyIslandDataV2 addSkyIslands(int horizontalRadius, int topHeight, int bottomHeight, int count, boolean randomTypes, int minCount) {
        SkyIslandDataV2 data = new SkyIslandDataV2();
        data.setHorizontalRadius(horizontalRadius);
        data.setTopHeight(topHeight);
        data.setBottomHeight(bottomHeight);
        data.setCount(count);
        data.setRandomTypes(randomTypes);
        data.setMinCount(minCount);
        this.SkyIslandDataV2.add(data);
        return data;
    }

    @ScriptMethodDocumentation(usage="", notes="Sets the generator to use Better With Mods villages when generating villages.")
    public void enableBWMVillageCompat() {
        this.BWMVillageCompat = true;
    }

    @ScriptMethodDocumentation(usage="", notes="Sets the generator to use Better With Mods mineshafts when generating mineshafts.")
    public void enableBWMMineshaftCompat() {
        this.BWMMineshaftCompat = true;
    }

    @Override
    public void generateStructures(World world, int chunkX, int chunkZ, ChunkPrimer primer) {
        if (this.mineshaft == null) {
            this.mineshaft = this.BWMMineshaftCompat && Topography.betterWithMods ? BWMUtil.getMineshaft(this) : new SkyIslandMineshaftGenerator(this);
        }
        this.mineshaft.func_186125_a(world, chunkX, chunkZ, primer);
        if (this.village == null) {
            this.village = this.BWMVillageCompat && Topography.betterWithMods ? BWMUtil.getVillage(this) : new SkyIslandVillageGenerator(this);
        }
        this.village.func_186125_a(world, chunkX, chunkZ, primer);
        if (this.stronghold != null) {
            this.stronghold.func_186125_a(world, chunkX, chunkZ, primer);
        }
    }

    @Override
    public void populateStructures(World world, Random rand, ChunkPos chunkPos) {
        double distance;
        SkyIslandDataV2 data;
        BlockPos componentMid;
        SkyIslandGeneratorV2 islandGenerator;
        DimensionDefinition dimensionDef;
        ConfigPreset preset;
        ConfigurationManager manager;
        Map<SkyIslandData, Map<BlockPos, SkyIslandType>> islandPositions;
        StructureComponent structurecomponent;
        Iterator iterator;
        StructureBoundingBox structurebb;
        int i = (chunkPos.field_77276_a << 4) + 8;
        int j = (chunkPos.field_77275_b << 4) + 8;
        for (StructureStart structurestart : this.mineshaft.field_75053_d.values()) {
            structurebb = new StructureBoundingBox(i, j, i + 15, j + 15);
            structurestart.func_75068_a(world, rand, structurebb);
            iterator = structurestart.func_186161_c().iterator();
            block1: while (iterator.hasNext()) {
                structurecomponent = (StructureComponent)iterator.next();
                islandPositions = null;
                manager = ConfigurationManager.getInstance();
                if (manager == null || (preset = manager.getPreset()) == null || (dimensionDef = preset.getDefinition(world.field_73011_w.getDimension())) == null) continue;
                for (IGenerator iGenerator : dimensionDef.getGenerators()) {
                    if (!(iGenerator instanceof SkyIslandGeneratorV2)) continue;
                    islandGenerator = (SkyIslandGeneratorV2)iGenerator;
                    islandPositions = islandGenerator.getIslandPositions(world.func_72905_C(), (structurecomponent.func_74874_b().field_78893_d - structurecomponent.func_74874_b().field_78897_a) / 2 + structurecomponent.func_74874_b().field_78897_a, (structurecomponent.func_74874_b().field_78892_f - structurecomponent.func_74874_b().field_78896_c) / 2 + structurecomponent.func_74874_b().field_78896_c);
                    break;
                }
                if (islandPositions == null) continue;
                componentMid = new BlockPos((structurecomponent.func_74874_b().field_78893_d - structurecomponent.func_74874_b().field_78897_a) / 2 + structurecomponent.func_74874_b().field_78897_a, 0, (structurecomponent.func_74874_b().field_78892_f - structurecomponent.func_74874_b().field_78896_c) / 2 + structurecomponent.func_74874_b().field_78896_c);
                for (Map.Entry<Object, Object> set : islandPositions.entrySet()) {
                    for (Map.Entry entry : ((Map)set.getValue()).entrySet()) {
                        if (!(set.getKey() instanceof SkyIslandDataV2)) continue;
                        data = (SkyIslandDataV2)set.getKey();
                        distance = MathUtil.getDistance(componentMid, (BlockPos)entry.getKey());
                        if (!(distance < data.getHorizontalRadius() * 0.35)) continue;
                        continue block1;
                    }
                }
                iterator.remove();
            }
        }
        this.mineshaft.func_175794_a(world, rand, chunkPos);
        i = (chunkPos.field_77276_a << 4) + 8;
        j = (chunkPos.field_77275_b << 4) + 8;
        for (StructureStart structurestart : this.village.field_75053_d.values()) {
            structurebb = new StructureBoundingBox(i, j, i + 15, j + 15);
            structurestart.func_75068_a(world, rand, structurebb);
            iterator = structurestart.func_186161_c().iterator();
            block6: while (iterator.hasNext()) {
                structurecomponent = (StructureComponent)iterator.next();
                islandPositions = null;
                manager = ConfigurationManager.getInstance();
                if (manager == null || (preset = manager.getPreset()) == null || (dimensionDef = preset.getDefinition(world.field_73011_w.getDimension())) == null) continue;
                for (IGenerator iGenerator : dimensionDef.getGenerators()) {
                    if (!(iGenerator instanceof SkyIslandGeneratorV2)) continue;
                    islandGenerator = (SkyIslandGeneratorV2)iGenerator;
                    islandPositions = islandGenerator.getIslandPositions(world.func_72905_C(), (structurecomponent.func_74874_b().field_78893_d - structurecomponent.func_74874_b().field_78897_a) / 2 + structurecomponent.func_74874_b().field_78897_a, (structurecomponent.func_74874_b().field_78892_f - structurecomponent.func_74874_b().field_78896_c) / 2 + structurecomponent.func_74874_b().field_78896_c);
                    break;
                }
                if (islandPositions == null) continue;
                componentMid = new BlockPos((structurecomponent.func_74874_b().field_78893_d - structurecomponent.func_74874_b().field_78897_a) / 2 + structurecomponent.func_74874_b().field_78897_a, 0, (structurecomponent.func_74874_b().field_78892_f - structurecomponent.func_74874_b().field_78896_c) / 2 + structurecomponent.func_74874_b().field_78896_c);
                for (Map.Entry<Object, Object> set : islandPositions.entrySet()) {
                    for (Map.Entry entry : ((Map)set.getValue()).entrySet()) {
                        if (!(set.getKey() instanceof SkyIslandDataV2)) continue;
                        data = (SkyIslandDataV2)set.getKey();
                        distance = MathUtil.getDistance(componentMid, (BlockPos)entry.getKey());
                        if (!(distance < data.getHorizontalRadius() * 0.5)) continue;
                        continue block6;
                    }
                }
                iterator.remove();
            }
        }
        this.village.func_175794_a(world, rand, chunkPos);
        this.stronghold.func_175794_a(world, rand, chunkPos);
    }

    @Override
    public BlockPos getNearestStructurePos(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        switch (structureName) {
            case "Stronghold": {
                return this.stronghold != null ? this.stronghold.func_180706_b(worldIn, position, findUnexplored) : null;
            }
            case "Village": {
                return this.village != null ? this.village.func_180706_b(worldIn, position, findUnexplored) : null;
            }
            case "Mineshaft": {
                return this.mineshaft != null ? this.mineshaft.func_180706_b(worldIn, position, findUnexplored) : null;
            }
        }
        return null;
    }

    @Override
    public boolean isInsideStructure(World worldIn, String structureName, BlockPos pos) {
        switch (structureName) {
            case "Stronghold": {
                return this.stronghold != null ? this.stronghold.func_175795_b(pos) : false;
            }
            case "Village": {
                return this.village != null ? this.village.func_175795_b(pos) : false;
            }
            case "Mineshaft": {
                return this.mineshaft != null ? this.mineshaft.func_175795_b(pos) : false;
            }
        }
        return false;
    }

    @Override
    public void recreateStructures(World world, Chunk chunkIn, int x, int z) {
        if (this.mineshaft != null) {
            this.mineshaft.func_186125_a(world, x, z, (ChunkPrimer)null);
        }
        if (this.village != null) {
            this.village.func_186125_a(world, x, z, (ChunkPrimer)null);
        }
        if (this.stronghold != null) {
            this.stronghold.func_186125_a(world, x, z, (ChunkPrimer)null);
        }
    }

    private void generateIslandPositions(long worldSeed) {
        this.islandPositionRandom.setSeed((long)this.currentRegionX * 341873128712L + (long)this.currentRegionZ * 132897987541L + worldSeed);
        this.islandPositions = new LinkedHashMap<SkyIslandData, Map<BlockPos, SkyIslandType>>();
        for (SkyIslandDataV2 data : this.SkyIslandDataV2) {
            int genCount = 0;
            for (int i = 0; i < data.getCount() || genCount < data.getMinCount(); ++i) {
                Map<BlockPos, SkyIslandType> positions;
                int featureCenterZ;
                double maxHorizontalFeatureRadius = data.getHorizontalRadius();
                int minMidHeight = (int)Math.max((double)data.getMinHeight(), data.getBottomHeight());
                int maxMidHeight = (int)Math.min((double)data.getMaxHeight(), 256.0 - data.getTopHeight());
                int randomVerticalSpace = Math.max(maxMidHeight - minMidHeight, 1);
                double midHeight = this.islandPositionRandom.nextInt(randomVerticalSpace) + minMidHeight;
                int regionCenterX = (int)((double)this.currentRegionX * this.regionSize + this.regionSize / 2.0);
                int regionCenterZ = (int)((double)this.currentRegionZ * this.regionSize + this.regionSize / 2.0);
                int randomSpace = (int)(this.regionSize - maxHorizontalFeatureRadius * 2.0);
                int featureCenterX = this.islandPositionRandom.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
                BlockPos pos = new BlockPos((double)featureCenterX, midHeight, (double)(featureCenterZ = this.islandPositionRandom.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ));
                if (!this.islandPostionAcceptable(pos, maxHorizontalFeatureRadius)) continue;
                if (!this.islandPositions.containsKey(data)) {
                    this.islandPositions.put(data, new LinkedHashMap());
                }
                if (data.isRandomIslands()) {
                    positions = this.islandPositions.get(data);
                    positions.put(pos, data.getType(this.islandPositionRandom.nextInt(128)));
                } else {
                    positions = this.islandPositions.get(data);
                    positions.put(pos, data.getType(genCount));
                }
                ++genCount;
            }
        }
    }

    private boolean islandPostionAcceptable(BlockPos pos, double maxHorizontalFeatureRadius) {
        for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> set : this.islandPositions.entrySet()) {
            SkyIslandDataV2 islandData = (SkyIslandDataV2)set.getKey();
            double minDistance = islandData.getHorizontalRadius() + maxHorizontalFeatureRadius + 16.0;
            for (Map.Entry<BlockPos, SkyIslandType> islandPos : set.getValue().entrySet()) {
                if (!(SkyIslandGenerator.getDistance(pos, islandPos.getKey()) < minDistance)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Map<SkyIslandData, Map<BlockPos, SkyIslandType>> getIslandPositions(long worldSeed, int x, int z) {
        if ((int)Math.floor(Math.floor((double)x / 16.0) * 16.0 / this.regionSize) != this.currentRegionX || (int)Math.floor(Math.floor((double)z / 16.0) * 16.0 / this.regionSize) != this.currentRegionZ) {
            this.currentRegionX = (int)Math.floor(Math.floor((double)x / 16.0) * 16.0 / this.regionSize);
            this.currentRegionZ = (int)Math.floor(Math.floor((double)z / 16.0) * 16.0 / this.regionSize);
            this.generateIslandPositions(worldSeed);
        }
        LinkedHashMap<SkyIslandData, Map<BlockPos, SkyIslandType>> positions = new LinkedHashMap<SkyIslandData, Map<BlockPos, SkyIslandType>>();
        for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> entry : this.islandPositions.entrySet()) {
            positions.put(entry.getKey(), entry.getValue());
        }
        return positions;
    }

    public static double getDistance(BlockPos pos, BlockPos pos2) {
        double d0 = pos.func_177958_n() - pos2.func_177958_n();
        double d2 = pos.func_177952_p() - pos2.func_177952_p();
        return Math.sqrt(d0 * d0 + d2 * d2);
    }

    @Override
    public int getRegionSize() {
        return (int)this.regionSize;
    }

    @Override
    @ScriptMethodDocumentation(args="int", usage="size", notes="Sets the grid region size in chunks. Default is 29.")
    public void setRegionSize(int size) {
        this.regionSize = size * 16;
    }

    @Override
    @ScriptMethodDocumentation(args="int, int, boolean", usage="radius, count, randomTypes", notes="Generates a SkyIslandDataV2 and returns it. Radius is the radius of the sky islands to be generated, count is the number of times to attempt to generate sky islands, randomTypes is how to use the SkyIslandTypes. If randomTypes is set to true it will randomly choose a SkyIslandType from the list when an island is generated. If it is set to false, then every time an island is generated it will use the next SkyIslandType in the list. This allows you to guarantee certain islands are generated in a region.")
    public SkyIslandDataV2 addSkyIslands(int radius, int count, boolean randomTypes) {
        SkyIslandDataV2 data = new SkyIslandDataV2();
        data.setHorizontalRadius(radius);
        data.setVerticalRadius(radius);
        data.setCount(count);
        data.setRandomTypes(randomTypes);
        this.SkyIslandDataV2.add(data);
        return data;
    }

    @Override
    @ScriptMethodDocumentation(args="int, int, boolean, int", usage="radius, count, randomTypes, minCount", notes="Generates a SkyIslandDataV2 and returns it. Radius is the radius of the sky islands to be generated, count is the number of times to attempt to generate sky islands, randomTypes is how to use the SkyIslandTypes, minCount is the minimum number of the sky islands which must be generated. If randomTypes is set to true it will randomly choose a SkyIslandType from the list when an island is generated. If it is set to false, then every time an island is generated it will use the next SkyIslandType in the list. This allows you to guarantee certain islands are generated in a region.")
    public SkyIslandDataV2 addSkyIslands(int radius, int count, boolean randomTypes, int minCount) {
        SkyIslandDataV2 data = new SkyIslandDataV2();
        data.setHorizontalRadius(radius);
        data.setVerticalRadius(radius);
        data.setCount(count);
        data.setRandomTypes(randomTypes);
        data.setMinCount(minCount);
        this.SkyIslandDataV2.add(data);
        return data;
    }

    protected void generateNoise(double[] array, int arraySizeX, int arraySizeY, int arraySizeZ, int x, int y, int z, int xCoordinateScale, int yCoordinateScale, int zCoordinateScale) {
        for (int xI = 0; xI < arraySizeX; ++xI) {
            for (int zI = 0; zI < arraySizeZ; ++zI) {
                for (int yI = 0; yI < arraySizeY; ++yI) {
                    double noise;
                    int index = (xI * arraySizeX + zI) * arraySizeY + yI;
                    array[index] = noise = this.terrainNoise.eval((double)(x + xI * xCoordinateScale) / 128.0, (double)(y + yI * yCoordinateScale) / 32.0, (double)(z + zI * zCoordinateScale) / 128.0, 3, 0.5);
                }
            }
        }
    }

    @Override
    public void flowWaterVertical(ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                boolean water = false;
                for (int y = 255; y >= 0; --y) {
                    IBlockState state = primer.func_177856_a(x, y, z);
                    if (state == Blocks.field_150355_j.func_176223_P()) {
                        water = true;
                        continue;
                    }
                    if (water && state == Blocks.field_150350_a.func_176223_P()) {
                        primer.func_177855_a(x, y, z, Blocks.field_150355_j.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(8)));
                        water = true;
                        continue;
                    }
                    water = false;
                }
            }
        }
    }

    @Override
    public void genBiomeTerrainBlocks(Biome biome, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, int islandMid, double noiseVal) {
        int i = islandMid;
        IBlockState iblockstate = biome.field_76752_A;
        IBlockState iblockstate1 = biome.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = z & 0xF;
        int i1 = x & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2 != Blocks.field_150348_b.func_176223_P()) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = AIR;
                    iblockstate1 = Blocks.field_150348_b.func_176223_P();
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = biome.field_76752_A;
                    iblockstate1 = biome.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = biome.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? ICE : WATER;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = AIR;
                    iblockstate1 = Blocks.field_150348_b.func_176223_P();
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? RED_SANDSTONE : SANDSTONE;
        }
    }

    private void genDecorations(long seed, int chunkX, int chunkZ, ChunkPrimer primer) {
        BlockPos pos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        block0: for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> set : this.getIslandPositions(seed, chunkX * 16, chunkZ * 16).entrySet()) {
            SkyIslandDataV2 data = (SkyIslandDataV2)set.getKey();
            double minDistance = data.getHorizontalRadius();
            for (Map.Entry<BlockPos, SkyIslandType> islandPos : set.getValue().entrySet()) {
                if (!this.canBeInChunk(islandPos.getKey(), data.getHorizontalRadius(), chunkX * 16, chunkZ * 16)) continue;
                SkyIslandType type = islandPos.getValue();
                for (DecorationData decoration : type.getDecorators()) {
                    decoration.generateForSkyIsland(seed, chunkX, chunkZ, primer, islandPos.getKey(), data, type, this);
                }
                break block0;
            }
        }
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ, Random rand) {
        long seed = world.func_72905_C();
        BlockFalling.field_149832_M = true;
        int i = chunkX * 16;
        int j = chunkZ * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        this.rand.setSeed(seed);
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * k + (long)chunkZ * l ^ seed);
        BlockPos pos = new BlockPos(i, 0, j);
        block0: for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> set : this.getIslandPositions(seed, i, j).entrySet()) {
            SkyIslandDataV2 data = (SkyIslandDataV2)set.getKey();
            double minDistance = data.getHorizontalRadius();
            for (Map.Entry<BlockPos, SkyIslandType> islandPos : set.getValue().entrySet()) {
                if (!this.canBeInChunk(islandPos.getKey(), data.getHorizontalRadius(), i, j)) continue;
                SkyIslandType type = islandPos.getValue();
                Biome typeBiome = Biome.func_150568_d((int)type.getBiome());
                if (type.isGenDecorations() && typeBiome != Biomes.field_185440_P) {
                    typeBiome.func_180624_a(world, this.rand, new BlockPos(i, 0, j));
                }
                if (!type.genAnimals()) break block0;
                WorldEntitySpawner.func_77191_a((World)world, (Biome)typeBiome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
                break block0;
            }
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                BlockPos blockpos1 = world.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (world.func_175675_v(blockpos2)) {
                    world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                }
                if (!world.func_175708_f(blockpos1, true)) continue;
                world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
            }
        }
        this.genGenerators(world, this.rand, chunkX, chunkZ, seed);
        BlockFalling.field_149832_M = false;
    }

    private void genGenerators(World world, Random random, int chunkX, int chunkZ, long seed) {
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos pos = new BlockPos(x, 0, z);
        block0: for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> set : this.getIslandPositions(seed, x, z).entrySet()) {
            SkyIslandDataV2 data = (SkyIslandDataV2)set.getKey();
            double minDistance = data.getHorizontalRadius();
            for (Map.Entry<BlockPos, SkyIslandType> islandPos : set.getValue().entrySet()) {
                if (!this.canBeInChunk(islandPos.getKey(), data.getHorizontalRadius(), x, z)) continue;
                SkyIslandType type = islandPos.getValue();
                for (IGenerator generator : type.getGenerators()) {
                    generator.populate(world, chunkX, chunkZ, this.rand);
                }
                break block0;
            }
        }
    }

    private boolean canBeInChunk(BlockPos center, double radius, int chunkMinX, int chunkMinZ) {
        if ((double)center.func_177958_n() - radius > (double)(chunkMinX + 16)) {
            return false;
        }
        if ((double)center.func_177958_n() + radius < (double)chunkMinX) {
            return false;
        }
        if ((double)center.func_177952_p() - radius > (double)(chunkMinZ + 16)) {
            return false;
        }
        return !((double)center.func_177952_p() + radius < (double)chunkMinZ);
    }

    @Override
    public GenLayer getLayer(World world, GenLayer parent) {
        GenLayerBiomeSkyIslands biomes = new GenLayerBiomeSkyIslands(world.func_72905_C(), this);
        return biomes;
    }
}

