/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.topography.world.generator.IGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ScriptClassDocumentation(documentationFile="./config/topography/documentation/generators/VineGenerator", classExplaination="This file is for the VineGenerator. This generator generates vines. Made of vines. Incredible, isn't it?")
public class VineGenerator
implements IGenerator {
    private int attemptsPerChunk = 10;
    private int minLength = 3;
    private int maxLength = 20;
    private int minHeight = 0;
    private int maxHeight = 255;
    private IBlockState state = Blocks.field_150395_bd.func_176223_P();

    @Override
    public void populate(World world, int chunkX, int chunkZ, Random random) {
        for (int i = 0; i < this.attemptsPerChunk; ++i) {
            int x = random.nextInt(27) + 3;
            int z = random.nextInt(27) + 3;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(chunkX * 16 + x, 256, chunkZ * 16 + z);
            EnumFacing current = null;
            int length = 0;
            block1: for (int y = this.maxHeight; y > this.minHeight; --y) {
                mutable.func_185336_p(y);
                if (world.func_175623_d((BlockPos)mutable)) {
                    Block block = this.state.func_177230_c();
                    if (current == null) {
                        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL.func_179516_a()) {
                            if (!block.func_176198_a(world, (BlockPos)mutable, enumfacing) || !this.checkSpaceForMinLength(world, (BlockPos)mutable)) continue;
                            current = enumfacing;
                            length = random.nextInt(Math.max(1, this.maxLength - this.minLength + 1)) + this.minLength - 1;
                            IBlockState iblockstate = this.state.func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(current == EnumFacing.NORTH)).func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(current == EnumFacing.EAST)).func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(current == EnumFacing.SOUTH)).func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(current == EnumFacing.WEST));
                            world.func_180501_a((BlockPos)mutable, iblockstate, 2);
                            continue block1;
                        }
                        continue;
                    }
                    if (length > 0) {
                        IBlockState iblockstate = this.state.func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(current == EnumFacing.NORTH)).func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(current == EnumFacing.EAST)).func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(current == EnumFacing.SOUTH)).func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(current == EnumFacing.WEST));
                        world.func_180501_a((BlockPos)mutable, iblockstate, 2);
                        --length;
                        continue;
                    }
                    current = null;
                    continue;
                }
                current = null;
            }
        }
    }

    private boolean checkSpaceForMinLength(World world, BlockPos top) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(top);
        for (int i = 0; i < this.minLength; ++i) {
            if (!world.func_175623_d((BlockPos)pos)) {
                return false;
            }
            pos = pos.func_177977_b();
        }
        return true;
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="block to generate", notes="Sets the block to generate vines out of. Must extend vanilla vines.")
    public void setBlock(ItemBlockData data) throws Exception {
        IBlockState state = data.buildBlockState();
        if (!(state.func_177230_c() instanceof BlockVine)) {
            throw new Exception("The vine generator can only use blocks which extend vanilla vines.");
        }
        this.state = state;
    }

    @ScriptMethodDocumentation(args="int, int", usage="min length, max length", notes="Sets the minimum and maximum length of the vines. Vines will not generate if there is insufficient space for minimum length. Default is 3 and 20.")
    public void setLength(int min, int max) {
        this.minLength = min > 0 ? min : 1;
        this.maxLength = max;
    }

    @ScriptMethodDocumentation(args="int", usage="attempt count", notes="Sets the number of positions on the horizontal plane to attempt to generate vines per chunk. Default is 3 and 20.")
    public void setAttemptsPerChunk(int count) {
        this.attemptsPerChunk = count;
    }

    @ScriptMethodDocumentation(args="int, int", usage="min height(exclusive), max height(inclusive)", notes="Sets the min and max heights the top of vines will generate. Vines can hang below as long as their top is within the range. Default is 0 and 255.")
    public void setHeightRange(int min, int max) {
        this.minHeight = min;
        this.maxHeight = max <= 255 ? max : 255;
    }
}

