/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator.structure;

import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandDataV2;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import com.bloodnbonesgaming.topography.world.generator.SkyIslandGeneratorV2;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class SkyIslandStrongholdGenerator
extends MapGenStronghold {
    protected final SkyIslandGeneratorV2 skyIslandGenerator;

    public SkyIslandStrongholdGenerator(SkyIslandGeneratorV2 generator) {
        this.skyIslandGenerator = generator;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> islands : this.skyIslandGenerator.getIslandPositions(this.field_75039_c.func_72905_C(), chunkX * 16, chunkZ * 16).entrySet()) {
            for (Map.Entry<BlockPos, SkyIslandType> island : islands.getValue().entrySet()) {
                BlockPos pos = island.getKey();
                if (!chunkPos.equals((Object)new ChunkPos(pos))) continue;
                return island.getValue().shouldGenerateStrongholds() && this.field_75038_b.nextInt(Math.max(1, island.getValue().getStrongholdChance())) == 0;
            }
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        StructureStart start = super.func_75049_b(chunkX, chunkZ);
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> islands : this.skyIslandGenerator.getIslandPositions(this.field_75039_c.func_72905_C(), chunkX * 16, chunkZ * 16).entrySet()) {
            SkyIslandDataV2 islandData = (SkyIslandDataV2)islands.getKey();
            for (Map.Entry<BlockPos, SkyIslandType> island : islands.getValue().entrySet()) {
                BlockPos pos = island.getKey();
                if (!chunkPos.equals((Object)new ChunkPos(pos))) continue;
                if (island.getValue().shouldGenerateStrongholds()) {
                    int j = pos.func_177956_o() - start.func_75071_a().field_78894_e + start.func_75071_a().func_78882_c() / 2 - (int)Math.floor(islandData.getBottomHeight() / 2.0);
                    start.func_75071_a().func_78886_a(0, j, 0);
                    for (StructureComponent structurecomponent : start.func_186161_c()) {
                        structurecomponent.func_181138_a(0, j, 0);
                    }
                }
                return start;
            }
        }
        return start;
    }

    public BlockPos func_180706_b(World worldIn, BlockPos startPos, boolean findUnexplored) {
        int i = this.field_75040_a;
        this.field_75039_c = worldIn;
        this.field_75038_b.setSeed(worldIn.func_72905_C());
        long j = this.field_75038_b.nextLong();
        long k = this.field_75038_b.nextLong();
        int x = (int)Math.floor((double)startPos.func_177958_n() / 16.0);
        int z = (int)Math.floor((double)startPos.func_177952_p() / 16.0);
        long j1 = (long)x * j;
        long k1 = (long)z * k;
        this.field_75038_b.setSeed(j1 ^ k1 ^ worldIn.func_72905_C());
        for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> islands : this.skyIslandGenerator.getIslandPositions(this.field_75039_c.func_72905_C(), x * 16, z * 16).entrySet()) {
            SkyIslandDataV2 islandData = (SkyIslandDataV2)islands.getKey();
            for (Map.Entry<BlockPos, SkyIslandType> island : islands.getValue().entrySet()) {
                BlockPos pos = island.getKey();
                if (!island.getValue().shouldGenerateStrongholds() || this.field_75038_b.nextInt(Math.max(1, island.getValue().getStrongholdChance())) != 0) continue;
                return pos.func_177982_a(0, -((int)Math.floor(islandData.getBottomHeight() / 2.0)), 0);
            }
        }
        return null;
    }
}

