/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.generator.structure;

import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandDataV2;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import com.bloodnbonesgaming.topography.world.generator.SkyIslandGeneratorV2;
import com.bloodnbonesgaming.topography.world.generator.structure.SkyIslandStrongholdGenerator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;

public class SkyIslandStrongholdSimpleGenerator
extends SkyIslandStrongholdGenerator {
    public SkyIslandStrongholdSimpleGenerator(SkyIslandGeneratorV2 generator) {
        super(generator);
    }

    @Override
    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        Start start = new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
        while (start.func_186161_c().isEmpty()) {
            start = new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
        }
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> islands : this.skyIslandGenerator.getIslandPositions(this.field_75039_c.func_72905_C(), chunkX * 16, chunkZ * 16).entrySet()) {
            SkyIslandDataV2 islandData = (SkyIslandDataV2)islands.getKey();
            for (Map.Entry<BlockPos, SkyIslandType> island : islands.getValue().entrySet()) {
                BlockPos pos = island.getKey();
                if (!chunkPos.equals((Object)new ChunkPos(pos))) continue;
                if (island.getValue().shouldGenerateStrongholds()) {
                    int j = pos.func_177956_o() - start.func_75071_a().field_78894_e + start.func_75071_a().func_78882_c() / 2 - (int)Math.floor(islandData.getBottomHeight() / 2.0);
                    start.func_75071_a().func_78886_a(0, j, 0);
                    for (StructureComponent structurecomponent : start.func_186161_c()) {
                        structurecomponent.func_181138_a(0, j, 0);
                    }
                }
                return start;
            }
        }
        return start;
    }

    public static class Stairs2
    extends StructureStrongholdPieces.Stairs2 {
        public Stairs2() {
        }

        public Stairs2(int p_i2083_1_, Random p_i2083_2_, int p_i2083_3_, int p_i2083_4_) {
            super(p_i2083_1_, p_i2083_2_, p_i2083_3_, p_i2083_4_);
        }

        public void func_74861_a(StructureComponent componentIn, List<StructureComponent> listIn, Random rand) {
            StructureStrongholdPieces.field_75203_d = StructureStrongholdPieces.PortalRoom.class;
            this.func_74986_a((StructureStrongholdPieces.Stairs2)componentIn, listIn, rand, 1, 1);
        }
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            StructureStrongholdPieces.func_75198_a();
            Stairs2 structurestrongholdpieces$stairs2 = new Stairs2(0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2);
            this.field_75075_a.add(structurestrongholdpieces$stairs2);
            structurestrongholdpieces$stairs2.func_74861_a((StructureComponent)structurestrongholdpieces$stairs2, this.field_75075_a, random);
            List list = structurestrongholdpieces$stairs2.field_75026_c;
            while (!list.isEmpty()) {
                int i = random.nextInt(list.size());
                StructureComponent structurecomponent = (StructureComponent)list.remove(i);
                structurecomponent.func_74861_a((StructureComponent)structurestrongholdpieces$stairs2, this.field_75075_a, random);
            }
            this.func_75072_c();
            this.func_75067_a(worldIn, random, 10);
        }

        static {
            MapGenStructureIO.func_143034_b(Start.class, (String)"TopographySimpleStronghold");
            MapGenStructureIO.func_143031_a(Stairs2.class, (String)"TopographySimpleStrongholdStairs2");
        }
    }
}

