/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.topography.world.layer;

import com.bloodnbonesgaming.topography.config.SkyIslandData;
import com.bloodnbonesgaming.topography.config.SkyIslandDataV2;
import com.bloodnbonesgaming.topography.config.SkyIslandType;
import com.bloodnbonesgaming.topography.util.MathUtil;
import com.bloodnbonesgaming.topography.world.generator.SkyIslandGenerator;
import java.util.Map;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerBiomeSkyIslands
extends GenLayer {
    final SkyIslandGenerator generator;
    final long worldSeed;

    public GenLayerBiomeSkyIslands(long p_i2125_1_, SkyIslandGenerator generator) {
        super(p_i2125_1_);
        this.worldSeed = p_i2125_1_;
        this.generator = generator;
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int[] returnInts = IntCache.func_76445_a((int)(width * depth));
        Map<SkyIslandData, Map<BlockPos, SkyIslandType>> islandPositions = this.generator.getIslandPositions(this.worldSeed, chunkX, chunkZ);
        for (int x = 0; x < width; ++x) {
            block1: for (int z = 0; z < depth; ++z) {
                BlockPos pos = new BlockPos(chunkX + x, 0, chunkZ + z);
                for (Map.Entry<SkyIslandData, Map<BlockPos, SkyIslandType>> set : islandPositions.entrySet()) {
                    SkyIslandData data = set.getKey();
                    double minDistance = data instanceof SkyIslandDataV2 ? ((SkyIslandDataV2)data).getHorizontalRadius() : (double)data.getRadius();
                    for (Map.Entry<BlockPos, SkyIslandType> islandPos : set.getValue().entrySet()) {
                        if (!(MathUtil.getDistance(pos, islandPos.getKey()) <= minDistance)) continue;
                        SkyIslandType type = islandPos.getValue();
                        returnInts[x + z * width] = type.getBiome();
                        continue block1;
                    }
                }
                returnInts[x + z * width] = Biome.func_185362_a((Biome)Biomes.field_185440_P);
            }
        }
        return returnInts;
    }
}

