/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.resourcehogs;

import java.io.IOException;
import net.darkhax.bookshelf.lib.LoggingHelper;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.resourcehogs.CreativeTabResourceHogs;
import net.darkhax.resourcehogs.IngredientNBTStack;
import net.darkhax.resourcehogs.ModConfiguration;
import net.darkhax.resourcehogs.blocks.BlockTruffle;
import net.darkhax.resourcehogs.client.renderer.entity.RenderResourceHog;
import net.darkhax.resourcehogs.compat.tcon.TconCompat;
import net.darkhax.resourcehogs.entity.EntityResourceHog;
import net.darkhax.resourcehogs.items.ItemBacon;
import net.darkhax.resourcehogs.items.ItemMudBucket;
import net.darkhax.resourcehogs.items.ItemPigSpawner;
import net.darkhax.resourcehogs.registry.DynamicTextureManager;
import net.darkhax.resourcehogs.registry.IResourceType;
import net.darkhax.resourcehogs.registry.PigResourceType;
import net.darkhax.resourcehogs.registry.ResourceRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="resourcehogs", name="Resource Hogs", dependencies="after:bookshelf;after:tconstruct", version="1.0.14", acceptedMinecraftVersions="[1.12.2]")
public class ResourceHogs {
    public static final RegistryHelper REGISTRY = new RegistryHelper().setTab((CreativeTabs)new CreativeTabResourceHogs()).enableAutoRegistration();
    public static final LoggingHelper LOG = new LoggingHelper("Resource Hogs");
    public static Block truffle;
    public static Item spawner;
    public static Item mudBucket;
    public static Item bacon;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModConfiguration.syncConfigData();
        ResourceRegistry.loadResourceEntries();
        spawner = REGISTRY.registerItem((Item)new ItemPigSpawner(), "spawner").func_77627_a(true);
        REGISTRY.registerMob(EntityResourceHog.class, "resourcehog", 0, 0x123321, 11207615);
        truffle = REGISTRY.registerBlock((Block)new BlockTruffle(), "truffle");
        bacon = REGISTRY.registerItem((Item)new ItemBacon(), "bacon").func_77627_a(true);
        mudBucket = REGISTRY.registerItem((Item)new ItemMudBucket(), "mud_bucket").func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"tconstruct")) {
            TconCompat.handleTconSupport();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (!PigResourceType.errors.isEmpty()) {
            event.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Found " + PigResourceType.errors.size() + " errors."));
            for (String key : PigResourceType.errors.keySet()) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + key));
                for (String error : PigResourceType.errors.get((Object)key)) {
                    event.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + " - " + error));
                }
            }
        }
        if (ResourceRegistry.RESOURCE_TYPES.isEmpty()) {
            event.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Resource Hogs has not been configured with any valid resource types. Please configure the mod, or resolve any noted errors."));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        ResourceRegistry.constructEntries();
        for (IResourceType type : ResourceRegistry.RESOURCE_TYPES.values()) {
            for (ItemStack stack : type.getInputs()) {
                ItemStack output = new ItemStack(mudBucket);
                ResourceHogs.setResource(output, type);
                ShapelessOreRecipe recipe = new ShapelessOreRecipe(null, output, new Object[]{Items.field_151131_as, "dirt", stack});
                recipe.setRegistryName(new ResourceLocation("resourcehogs", "mud_bucket_" + type.getId() + "_" + StackUtils.getStackIdentifier((ItemStack)stack).replace(':', '_').toLowerCase()));
                registry.register((IForgeRegistryEntry)recipe);
            }
            ItemStack truffleStack = new ItemStack(truffle);
            ResourceHogs.setResource(truffleStack, type);
            IngredientNBTStack truffleInput = new IngredientNBTStack(truffleStack);
            ShapelessOreRecipe truffleDeconstructRecipe = new ShapelessOreRecipe(null, type.getOutput(), new Object[]{truffleInput, truffleInput, truffleInput, truffleInput});
            truffleDeconstructRecipe.setRegistryName(new ResourceLocation("resourcehogs", "deconstruct_truffle_" + type.getId()));
            registry.register((IForgeRegistryEntry)truffleDeconstructRecipe);
            ItemStack baconStack = new ItemStack(bacon);
            ResourceHogs.setResource(baconStack, type);
            IngredientNBTStack baconInput = new IngredientNBTStack(baconStack);
            ItemStack baconOutput = type.getOutput().func_77946_l();
            ShapelessOreRecipe baconDeconstructRecipe = new ShapelessOreRecipe(null, baconOutput, new Object[]{baconInput});
            baconDeconstructRecipe.setRegistryName(new ResourceLocation("resourcehogs", "deconstruct_bacon_" + type.getId()));
            registry.register((IForgeRegistryEntry)baconDeconstructRecipe);
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void clientPreInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityResourceHog.class, manager -> new RenderResourceHog(manager));
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(listener -> {
            try {
                DynamicTextureManager.cleanup();
                DynamicTextureManager.generateDynamicTextures();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static void setResource(ItemStack stack, IResourceType type) {
        if (stack != null && type != null) {
            StackUtils.prepareStackTag((ItemStack)stack).func_74778_a("ResourceType", type.getId());
        }
    }

    public static IResourceType getResource(ItemStack stack) {
        return stack.func_77942_o() ? ResourceRegistry.getType(stack.func_77978_p().func_74779_i("ResourceType")) : ResourceRegistry.MISSING;
    }
}

