/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.resourcehogs.blocks;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.block.BlockTileEntity;
import net.darkhax.bookshelf.block.IColorfulBlock;
import net.darkhax.bookshelf.block.ITileEntityBlock;
import net.darkhax.bookshelf.util.MathsUtils;
import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.resourcehogs.ResourceHogs;
import net.darkhax.resourcehogs.blocks.TileEntityTruffle;
import net.darkhax.resourcehogs.entity.EntityResourceHog;
import net.darkhax.resourcehogs.registry.IResourceType;
import net.darkhax.resourcehogs.registry.ResourceRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTruffle
extends BlockTileEntity
implements IColorfulBlock,
ITileEntityBlock {
    public static final AxisAlignedBB BOUNDS = new AxisAlignedBB(MathsUtils.getPixelDistance((int)4), 0.0, MathsUtils.getPixelDistance((int)4), MathsUtils.getPixelDistance((int)12), MathsUtils.getPixelDistance((int)6), MathsUtils.getPixelDistance((int)12));
    public static final Material GROUND_WITH_TOOL = new Material(MapColor.field_151650_B){

        public boolean func_76229_l() {
            return false;
        }
    };

    public BlockTruffle() {
        super(GROUND_WITH_TOOL);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185849_b);
        this.setHarvestLevel("shovel", 0);
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity collidingEntity, boolean isActualState) {
        if (!(collidingEntity instanceof EntityResourceHog)) {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, collidingEntity, isActualState);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityTruffle tile;
        if (worldIn.func_175625_s(pos) instanceof TileEntityTruffle && (tile = (TileEntityTruffle)worldIn.func_175625_s(pos)) != null) {
            tile.setResource(ResourceHogs.getResource(stack));
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (IResourceType resourcetype : ResourceRegistry.RESOURCE_TYPES.values()) {
            ItemStack itemstack = new ItemStack((Block)this, 1);
            ResourceHogs.setResource(itemstack, resourcetype);
            items.add((Object)itemstack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ChatFormatting.BLUE + "Type: " + ChatFormatting.RESET + ResourceHogs.getResource(stack).getName());
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockColor getColorHandler() {
        return (state, world, pos, tintIndex) -> this.getType(world, pos).getColor();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTruffle();
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityTruffle.class;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getVariant((IBlockAccess)world, pos);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        StackUtils.dropStackInWorld((World)world, (BlockPos)pos, (ItemStack)this.getVariant((IBlockAccess)world, pos));
        world.func_175698_g(pos);
        this.func_180652_a(world, pos, explosion);
    }

    public int func_149745_a(Random rnd) {
        return 0;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.func_184812_l_()) {
            StackUtils.dropStackInWorld((World)world, (BlockPos)pos, (ItemStack)this.getVariant((IBlockAccess)world, pos));
        }
        return world.func_175698_g(pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            StackUtils.dropStackInWorld((World)worldIn, (BlockPos)pos, (ItemStack)this.getVariant((IBlockAccess)worldIn, pos));
            worldIn.func_175698_g(pos);
        }
    }

    public ItemStack getVariant(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityTruffle) {
            ItemStack item = new ItemStack((Block)this, 1);
            IResourceType resource = ((TileEntityTruffle)tile).getResource();
            if (resource != null) {
                ResourceHogs.setResource(item, resource);
                return item;
            }
        }
        return ItemStack.field_190927_a;
    }

    public IResourceType getType(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityTruffle) {
            IResourceType type = ((TileEntityTruffle)tile).getResource();
            return type != null ? type : ResourceRegistry.MISSING;
        }
        return ResourceRegistry.MISSING;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

