/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.resourcehogs.entity;

import net.darkhax.bookshelf.util.MathsUtils;
import net.darkhax.resourcehogs.ModConfiguration;
import net.darkhax.resourcehogs.ResourceHogs;
import net.darkhax.resourcehogs.entity.EntityAIDigTruffle;
import net.darkhax.resourcehogs.registry.IResourceType;
import net.darkhax.resourcehogs.registry.ResourceRegistry;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityResourceHog
extends EntityPig {
    private static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(EntityResourceHog.class, (DataSerializer)DataSerializers.field_187194_d);
    private EntityAIDigTruffle truffleDigAI;

    public EntityResourceHog(World worldIn) {
        super(worldIn);
    }

    public IResourceType getResourceType() {
        return ResourceRegistry.getType((String)this.field_70180_af.func_187225_a(TYPE));
    }

    public void setResourceType(IResourceType type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type.getId());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TYPE, (Object)"MISSING");
        this.setResourceType(ResourceRegistry.getRandomType());
        super.func_70088_a();
    }

    public void func_70636_d() {
        PotionEffect speedEffect;
        super.func_70636_d();
        if (this.truffleDigAI != null && (speedEffect = this.func_70660_b(MobEffects.field_76424_c)) != null) {
            int level = 1 + speedEffect.func_76458_c();
            for (int tick = 0; tick < level; ++tick) {
                this.truffleDigAI.func_75246_d();
            }
        }
    }

    protected void func_184651_r() {
        this.truffleDigAI = new EntityAIDigTruffle(this);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.truffleDigAI);
        super.func_184651_r();
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        IResourceType type = this.getResourceType();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(type.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(type.getMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(type.getArmorAmount());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.getResourceType() != null) {
            compound.func_74778_a("ResourceType", this.getResourceType().getId());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setResourceType(ResourceRegistry.getType(compound.func_74779_i("ResourceType")));
    }

    public EntityPig func_90011_a(EntityAgeable ageable) {
        if (ageable instanceof EntityResourceHog && this.field_70146_Z.nextBoolean()) {
            EntityResourceHog hog = new EntityResourceHog(this.field_70170_p);
            hog.setResourceType(this.field_70146_Z.nextBoolean() ? this.getResourceType() : ((EntityResourceHog)ageable).getResourceType());
            return hog;
        }
        return new EntityPig(this.field_70170_p);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        ItemStack drop = new ItemStack(ResourceHogs.bacon, MathsUtils.nextIntInclusive((int)ModConfiguration.minBacon, (int)ModConfiguration.maxBacon));
        ResourceHogs.setResource(drop, this.getResourceType());
        this.func_70099_a(drop, 0.0f);
    }
}

