/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.resourcehogs.items;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.item.IColorfulItem;
import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.resourcehogs.ResourceHogs;
import net.darkhax.resourcehogs.entity.EntityResourceHog;
import net.darkhax.resourcehogs.registry.IResourceType;
import net.darkhax.resourcehogs.registry.ResourceRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPigSpawner
extends Item
implements IColorfulItem {
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, itemstack)) {
                EntityResourceHog entity = new EntityResourceHog(worldIn);
                entity.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 1.0, (double)blockpos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                entity.field_70759_as = entity.field_70177_z;
                entity.field_70761_aq = entity.field_70177_z;
                entity.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entity)), null);
                worldIn.func_72838_d((Entity)entity);
                entity.func_70642_aH();
                entity.setResourceType(ResourceHogs.getResource(itemstack));
                if (entity instanceof EntityLivingBase && itemstack.func_82837_s()) {
                    entity.func_96094_a(itemstack.func_82833_r());
                }
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                playerIn.func_71029_a(StatList.func_188057_b((Item)this));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IResourceType type = ResourceHogs.getResource(stack);
        if (type != null) {
            tooltip.add(ChatFormatting.BLUE + "Type: " + ChatFormatting.RESET + type.getName());
            tooltip.add(ChatFormatting.BLUE + "Diggable Blocks: " + ChatFormatting.RESET);
            for (IBlockState state : type.getDiggableBlocks()) {
                ItemStack stateStack = StackUtils.getStackFromState((IBlockState)state, (int)1);
                if (stateStack == null || stateStack.func_190926_b()) continue;
                tooltip.add(" - " + stateStack.func_82833_r());
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (IResourceType resourcetype : ResourceRegistry.RESOURCE_TYPES.values()) {
                ItemStack itemstack = new ItemStack((Item)this, 1);
                ResourceHogs.setResource(itemstack, resourcetype);
                items.add((Object)itemstack);
            }
        }
    }

    public IItemColor getColorHandler() {
        return (stack, index) -> index == 0 ? 15771042 : ResourceHogs.getResource(stack).getColor();
    }
}

