/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.resourcehogs.registry;

import java.awt.image.BufferedImage;
import java.io.IOException;
import net.darkhax.bookshelf.util.RenderUtils;
import net.darkhax.resourcehogs.ResourceHogs;
import net.darkhax.resourcehogs.registry.IResourceType;
import net.darkhax.resourcehogs.registry.ResourceRegistry;
import net.darkhax.resourcehogs.util.TextureUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class DynamicTextureManager {
    private static final ResourceLocation TEXTURE_PIG = new ResourceLocation("minecraft", "textures/entity/pig/pig.png");
    private static final ResourceLocation TEXTURE_MASK = new ResourceLocation("resourcehogs", "textures/entity/pig_mask.png");

    public static void generateDynamicTextures() throws IOException {
        ResourceHogs.LOG.info("Generating textures for {} resource hogs!", new Object[]{ResourceRegistry.RESOURCE_TYPES.size()});
        long startTime = System.currentTimeMillis();
        BufferedImage defaultPigBuf = TextureUtils.getResourceAsBuffer(TEXTURE_PIG);
        BufferedImage maskBuf = DynamicTextureManager.getMaskBuffer(defaultPigBuf);
        for (IResourceType entry : ResourceRegistry.RESOURCE_TYPES.values()) {
            TextureAtlasSprite sprite = RenderUtils.getSprite((IBlockState)entry.getRenderState());
            BufferedImage spriteBuf = TextureUtils.getBufferedImage(sprite);
            BufferedImage maskedPigBuf = TextureUtils.maskImage(spriteBuf, TextureUtils.deepCopy(defaultPigBuf), maskBuf);
            DynamicTexture maskedPigTexture = new DynamicTexture(maskedPigBuf);
            ResourceLocation maskedPigLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a("resourcehog_" + entry.getId(), maskedPigTexture);
            entry.setRenderTexture(maskedPigLocation);
            TextureAtlasSprite outSprite = RenderUtils.getParticleTexture((ItemStack)entry.getOutput());
            entry.setColor(TextureUtils.averageColor(TextureUtils.getBufferedImage(outSprite)).getRGB());
        }
        ResourceHogs.LOG.info("Finished in {}ms.", new Object[]{Long.toString(System.currentTimeMillis() - startTime)});
    }

    private static BufferedImage getMaskBuffer(BufferedImage original) throws IOException {
        BufferedImage maskBuf = TextureUtils.getResourceAsBuffer(TEXTURE_MASK);
        int factor = original.getHeight() / 32;
        if (factor > 1) {
            maskBuf = TextureUtils.resizeBuffer(maskBuf, factor);
        }
        return maskBuf;
    }

    public static void cleanup() {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        for (IResourceType entry : ResourceRegistry.RESOURCE_TYPES.values()) {
            manager.func_147645_c(entry.getRenderTexture());
            entry.setRenderTexture(null);
        }
    }
}

