/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.resourcehogs.registry;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.resourcehogs.registry.IResourceType;
import net.darkhax.resourcehogs.registry.ResourceEntry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class PigResourceType
implements IResourceType {
    public static final Multimap<String, String> errors = HashMultimap.create();
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation renderTexture;
    @SideOnly(value=Side.CLIENT)
    private int color;
    private final String id;
    private final String name;
    private final double maxHealth;
    private final double movementSpeed;
    private final double armorAmount;
    private final int digTickDelay;
    private final IBlockState renderState;
    private final List<ItemStack> inputs = new ArrayList<ItemStack>();
    private final ItemStack output;
    private final List<IBlockState> diggables = new ArrayList<IBlockState>();
    private final List<Integer> validDimensions;

    public PigResourceType(ResourceEntry entry) throws Exception {
        this.id = entry.getId();
        this.maxHealth = entry.getMaxHealth();
        this.movementSpeed = entry.getMovementSpeed();
        this.armorAmount = entry.getArmorAmount();
        this.digTickDelay = entry.getDigTickDelay();
        this.renderState = this.getStatesFromString(entry.getRenderBlock());
        for (String input : entry.getInputs()) {
            this.inputs.addAll(this.getStacksFromString(input));
        }
        List<ItemStack> outputs = this.getStacksFromString(entry.getOutputs());
        this.output = outputs.isEmpty() ? ItemStack.field_190927_a : outputs.get(0);
        for (String digBlock : entry.getDiggableBlocks()) {
            this.diggables.add(this.getStatesFromString(digBlock));
        }
        this.validDimensions = Ints.asList((int[])entry.getValidDimensopns());
        this.name = entry.getTypeName().isEmpty() ? this.output.func_82833_r() : entry.getTypeName();
    }

    public void validate() {
        if (this.inputs.isEmpty()) {
            errors.put((Object)this.id, (Object)"No valid inputs.");
        }
        if (this.output == null || this.output.func_190926_b()) {
            errors.put((Object)this.id, (Object)"No valid output.");
        }
        if (this.validDimensions.isEmpty()) {
            errors.put((Object)this.id, (Object)"No valid dimensions.");
        }
        if (this.diggables.isEmpty()) {
            errors.put((Object)this.id, (Object)"No diggable blocks.");
        }
        if (this.renderState == null) {
            errors.put((Object)this.id, (Object)"No render state found.");
        }
    }

    private IBlockState getStatesFromString(String input) throws Exception {
        String[] parts = input.split(":");
        if (parts.length >= 2) {
            ResourceLocation blockID = new ResourceLocation(parts[0], parts[1]);
            int meta = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockID);
            if (block != null && meta >= 0 && meta <= 15) {
                return block.func_176203_a(meta);
            }
        }
        throw new RuntimeException("No block state found for " + input);
    }

    private List<ItemStack> getStacksFromString(String input) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        String[] parts = input.split(":");
        if (parts.length > 0) {
            if ("ore".equalsIgnoreCase(parts[0]) && parts.length == 2) {
                for (ItemStack oredictItem : OreDictionary.getOres((String)parts[1])) {
                    items.add(oredictItem);
                }
            } else if (parts.length > 1) {
                ResourceLocation itemId = new ResourceLocation(parts[0], parts[1]);
                int meta = parts.length > 2 ? ("*".equals(parts[2]) ? Short.MAX_VALUE : Integer.parseInt(parts[2])) : 0;
                int amount = parts.length > 3 ? Integer.parseInt(parts[3]) : 1;
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
                if (item != null) {
                    if (meta == Short.MAX_VALUE) {
                        for (ItemStack variant : StackUtils.getAllItems((Item)item)) {
                            items.add(variant);
                        }
                    } else {
                        items.add(new ItemStack(item, amount, meta));
                    }
                }
            }
        }
        return items;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    @Override
    public List<IBlockState> getDiggableBlocks() {
        return this.diggables;
    }

    @Override
    public List<Integer> getValidDimensions() {
        return this.validDimensions;
    }

    @Override
    public double getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public double getMovementSpeed() {
        return this.movementSpeed;
    }

    @Override
    public double getArmorAmount() {
        return this.armorAmount;
    }

    @Override
    public IBlockState getRenderState() {
        return this.renderState;
    }

    @Override
    public ResourceLocation getRenderTexture() {
        return this.renderTexture;
    }

    @Override
    public void setRenderTexture(ResourceLocation textureLoc) {
        this.renderTexture = textureLoc;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int getDigTickDelay() {
        return this.digTickDelay;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

