/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.resourcehogs.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.resourcehogs.ResourceHogs;
import net.darkhax.resourcehogs.registry.IResourceType;
import net.darkhax.resourcehogs.registry.PigResourceType;
import net.darkhax.resourcehogs.registry.ResourceEntry;
import net.darkhax.resourcehogs.registry.ResourceTypeMissing;

public class ResourceRegistry {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File DIR_TYPES = new File("config/resourcehogs/types");
    public static final Map<String, ResourceEntry> RESOURCE_ENTRIES = new HashMap<String, ResourceEntry>();
    public static final Map<String, IResourceType> RESOURCE_TYPES = new HashMap<String, IResourceType>();
    public static final IResourceType MISSING = new ResourceTypeMissing();

    public static void constructEntries() {
        for (ResourceEntry entry : RESOURCE_ENTRIES.values()) {
            try {
                PigResourceType type = new PigResourceType(entry);
                type.validate();
                if (PigResourceType.errors.containsKey((Object)entry.getId())) continue;
                RESOURCE_TYPES.put(type.getId(), type);
            }
            catch (Exception e) {
                ResourceHogs.LOG.error("Failed to load pig type {}.", new Object[]{entry.getId()});
                ResourceHogs.LOG.catching((Throwable)e);
            }
        }
        ResourceHogs.LOG.info("Successfully loaded {} resource types.", new Object[]{RESOURCE_TYPES.size()});
    }

    public static void loadResourceEntries() {
        if (!DIR_TYPES.exists()) {
            DIR_TYPES.mkdirs();
            return;
        }
        for (File file : DIR_TYPES.listFiles()) {
            String fileName = file.getName();
            if (fileName.endsWith(".json")) {
                try (FileReader json = new FileReader(file);){
                    ResourceEntry entry = (ResourceEntry)GSON.fromJson((Reader)json, ResourceEntry.class);
                    if (entry != null) {
                        RESOURCE_ENTRIES.put(entry.getId(), entry);
                        continue;
                    }
                    ResourceHogs.LOG.error("Could not load pig from {}.", new Object[]{fileName});
                }
                catch (Exception e) {
                    ResourceHogs.LOG.error("Unable to load file {}. Please make sure it's a valid json.", new Object[]{fileName});
                    ResourceHogs.LOG.catching((Throwable)e);
                }
                continue;
            }
            ResourceHogs.LOG.error("Found invalid file {} in the types folder. It must be a .json file!", new Object[]{fileName});
        }
        ResourceHogs.LOG.info("Loaded {} pig types.", new Object[]{RESOURCE_ENTRIES.size()});
    }

    public static IResourceType getRandomType() {
        ArrayList<IResourceType> valuesList = new ArrayList<IResourceType>(RESOURCE_TYPES.values());
        return (IResourceType)valuesList.get(Constants.RANDOM.nextInt(valuesList.size()));
    }

    public static IResourceType getType(String name) {
        return RESOURCE_TYPES.getOrDefault(name, MISSING);
    }
}

