/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.resourcehogs.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class TextureUtils {
    public static BufferedImage createTiledImage(BufferedImage texture, BufferedImage toTile) {
        for (int y = 0; y < toTile.getHeight(); ++y) {
            for (int x = 0; x < toTile.getWidth(); ++x) {
                toTile.setRGB(x, y, texture.getRGB(x % texture.getWidth(), y % texture.getWidth()));
            }
        }
        return toTile;
    }

    public static BufferedImage preserveMask(BufferedImage target, BufferedImage mask) {
        for (int y = 0; y < mask.getHeight(); ++y) {
            for (int x = 0; x < mask.getWidth(); ++x) {
                if (mask.getRGB(x, y) == -16777216) continue;
                target.setRGB(x, y, 0);
            }
        }
        return target;
    }

    public static BufferedImage getResourceAsBuffer(ResourceLocation resource) throws IOException {
        return ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b());
    }

    public static BufferedImage resizeBuffer(BufferedImage image, int factor) {
        if (factor == 1) {
            return image;
        }
        int resizedWidth = factor * image.getWidth();
        int resizedHeight = factor * image.getHeight();
        BufferedImage resizedBuffer = new BufferedImage(resizedWidth, resizedHeight, image.getType());
        for (int y = 0; y < resizedHeight; ++y) {
            for (int x = 0; x < resizedWidth; ++x) {
                resizedBuffer.setRGB(x, y, image.getRGB(x / factor, y / factor));
            }
        }
        return resizedBuffer;
    }

    public static BufferedImage getBufferedImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.func_94211_a();
        int iconHeight = textureAtlasSprite.func_94216_b();
        int frameCount = textureAtlasSprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, 6);
        for (int i = 0; i < frameCount; ++i) {
            int[][] frameTextureData = textureAtlasSprite.func_147965_a(i);
            int[] largestMipMapTextureData = frameTextureData[0];
            bufferedImage.setRGB(0, i * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
        }
        return bufferedImage;
    }

    public static BufferedImage deepCopy(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public static BufferedImage maskImage(BufferedImage sprite, BufferedImage sheepBase, BufferedImage mask) {
        BufferedImage overlay = TextureUtils.createTiledImage(sprite, new BufferedImage(sheepBase.getWidth(), sheepBase.getHeight(), 2));
        TextureUtils.preserveMask(overlay, mask);
        TextureUtils.addImage(sheepBase, overlay);
        return sheepBase;
    }

    public static void addImage(BufferedImage base, BufferedImage toAdd) {
        for (int y = 0; y < base.getHeight(); ++y) {
            for (int x = 0; x < base.getWidth(); ++x) {
                int pixelColor = toAdd.getRGB(x, y);
                if (pixelColor == 0) continue;
                base.setRGB(x, y, toAdd.getRGB(x, y));
            }
        }
    }

    public static Color averageColor(BufferedImage bi) {
        long sumr = 0L;
        long sumg = 0L;
        long sumb = 0L;
        int skipped = 0;
        for (int x = 0; x < bi.getWidth(); ++x) {
            for (int y = 0; y < bi.getHeight(); ++y) {
                if (bi.getRGB(x, y) != 0) {
                    Color pixel = new Color(bi.getRGB(x, y));
                    sumr += (long)pixel.getRed();
                    sumg += (long)pixel.getGreen();
                    sumb += (long)pixel.getBlue();
                    continue;
                }
                ++skipped;
            }
        }
        int num = bi.getWidth() * bi.getHeight() - skipped;
        return new Color((int)sumr / num, (int)sumg / num, (int)sumb / num);
    }

    public static int[][] copyGray(int[][] input) {
        int width = input.length;
        int height = input[0].length;
        int[][] output = new int[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int gray;
                int color = input[x][y];
                int red = color >> 16 & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color & 0xFF;
                int average = (red + green + blue) / 3;
                output[x][y] = gray = (average << 16) + (average << 8) + average;
            }
        }
        return output;
    }
}

