/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import rustic.common.Config;
import rustic.common.blocks.fluids.FluidBooze;
import rustic.common.crafting.BrewingBarrelRecipe;
import rustic.common.crafting.Recipes;
import rustic.common.inventory.ExternalItemHandler;
import rustic.common.items.ModItems;

public class TileEntityBrewingBarrel
extends TileEntity
implements ITickable {
    protected ItemStackHandler internalStackHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            IBlockState state = TileEntityBrewingBarrel.this.field_145850_b.func_180495_p(TileEntityBrewingBarrel.this.field_174879_c);
            TileEntityBrewingBarrel.this.field_145850_b.func_175641_c(TileEntityBrewingBarrel.this.field_174879_c, TileEntityBrewingBarrel.this.func_145838_q(), 1, 0);
            TileEntityBrewingBarrel.this.func_145831_w().func_184138_a(TileEntityBrewingBarrel.this.field_174879_c, state, state, 3);
            TileEntityBrewingBarrel.this.field_145850_b.func_175685_c(TileEntityBrewingBarrel.this.field_174879_c, TileEntityBrewingBarrel.this.func_145838_q(), true);
            TileEntityBrewingBarrel.this.func_70296_d();
        }
    };
    private ExternalItemHandler externalStackHandler = new ExternalItemHandler(this.internalStackHandler){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.isStackAllowedInSlot(slot, stack)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        private boolean isStackAllowedInSlot(int slot, ItemStack stack) {
            if (slot == 1) {
                return stack.func_77973_b() == Items.field_151069_bo;
            }
            if (slot == 2) {
                FluidStack fluid;
                if (FluidUtil.getFluidHandler((ItemStack)stack) != null && (fluid = FluidUtil.getFluidContained((ItemStack)stack)) != null && fluid.getFluid() != null) {
                    return fluid.getFluid() instanceof FluidBooze;
                }
                return stack.func_77973_b() == Items.field_151069_bo;
            }
            if (slot == 0) {
                return FluidUtil.getFluidHandler((ItemStack)stack) != null || stack.func_77973_b() instanceof UniversalBucket || stack.func_77973_b() instanceof ItemFluidContainer || stack.func_77973_b() == Items.field_151069_bo || stack.func_77973_b() instanceof ItemBucket;
            }
            return false;
        }
    };
    protected FluidTank input = new FluidTank(8000);
    protected FluidTank output = new FluidTank(8000);
    protected FluidTank auxiliary = new FluidTank(1000);
    protected int brewTime;
    protected BrewingBarrelRecipe recipe = null;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("items", (NBTBase)this.internalStackHandler.serializeNBT());
        NBTTagCompound inputTank = new NBTTagCompound();
        this.input.writeToNBT(inputTank);
        tag.func_74782_a("inputTank", (NBTBase)inputTank);
        NBTTagCompound outputTank = new NBTTagCompound();
        this.output.writeToNBT(outputTank);
        tag.func_74782_a("outputTank", (NBTBase)outputTank);
        NBTTagCompound auxTank = new NBTTagCompound();
        this.auxiliary.writeToNBT(auxTank);
        tag.func_74782_a("auxTank", (NBTBase)auxTank);
        tag.func_74768_a("brewTime", this.brewTime);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("items")) {
            this.internalStackHandler.deserializeNBT((NBTTagCompound)tag.func_74781_a("items"));
        }
        this.input.readFromNBT(tag.func_74775_l("inputTank"));
        this.output.readFromNBT(tag.func_74775_l("outputTank"));
        this.auxiliary.readFromNBT(tag.func_74775_l("auxTank"));
        if (tag.func_74764_b("brewTime")) {
            this.brewTime = tag.func_74762_e("brewTime");
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public String getName() {
        return "container.rustic.brewing_barrel";
    }

    public int getInputAmount() {
        return this.input.getFluidAmount();
    }

    public int getOutputAmount() {
        return this.output.getFluidAmount();
    }

    public int getAuxiliaryAmount() {
        return this.auxiliary.getFluidAmount();
    }

    public int getInputCapacity() {
        return this.input.getCapacity();
    }

    public int getOutputCapacity() {
        return this.output.getCapacity();
    }

    public int getAuxiliaryCapacity() {
        return this.auxiliary.getCapacity();
    }

    public FluidStack getInputFluid() {
        if (this.input.getFluid() != null) {
            return this.input.getFluid().copy();
        }
        return null;
    }

    public FluidStack getOutputFluid() {
        if (this.output.getFluid() != null) {
            return this.output.getFluid().copy();
        }
        return null;
    }

    public FluidStack getAuxiliaryFluid() {
        if (this.auxiliary.getFluid() != null) {
            return this.auxiliary.getFluid().copy();
        }
        return null;
    }

    public boolean slot0Empty() {
        return this.internalStackHandler.getStackInSlot(0).func_190926_b();
    }

    public boolean slot1Empty() {
        return this.internalStackHandler.getStackInSlot(1).func_190926_b();
    }

    public boolean slot2Empty() {
        return this.internalStackHandler.getStackInSlot(2).func_190926_b();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.externalStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.func_145843_s();
        if (this.internalStackHandler != null && !world.field_72995_K) {
            for (int i = 0; i < this.internalStackHandler.getSlots(); ++i) {
                if (this.internalStackHandler.getStackInSlot(i) == null) continue;
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.internalStackHandler.getStackInSlot(i));
            }
        }
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        int amount;
        ItemStack out;
        FluidStack fluid;
        int amount2;
        IFluidHandlerItem fluidHandlerDummy;
        ItemStack out2;
        ItemStack in;
        ItemStack stack;
        boolean fluidChanged = false;
        if (!this.internalStackHandler.getStackInSlot(0).func_190926_b() && !this.field_145850_b.field_72995_K) {
            stack = this.internalStackHandler.getStackInSlot(0);
            in = stack.func_77946_l();
            in.func_190920_e(1);
            if (stack.func_77973_b() == Items.field_151069_bo && this.input.getFluidAmount() > 0) {
                out2 = new ItemStack((Item)ModItems.FLUID_BOTTLE);
                fluidHandlerDummy = (IFluidHandlerItem)out2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                amount2 = fluidHandlerDummy.fill(this.input.getFluid(), true);
                out2 = fluidHandlerDummy.getContainer();
                if (amount2 > 0 && this.internalStackHandler.insertItem(3, out2, true).func_190926_b()) {
                    this.input.drain(amount2, true);
                    this.internalStackHandler.getStackInSlot(0).func_190918_g(1);
                    this.internalStackHandler.insertItem(3, out2, false);
                    fluidChanged |= true;
                }
            } else if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                fluid = FluidUtil.getFluidContained((ItemStack)in);
                if (fluid != null && fluid.getFluid() != null && this.input.fill(fluid, false) == fluid.amount) {
                    out = new ItemStack(in.func_77973_b());
                    IFluidHandlerItem fluidHandlerDummy2 = (IFluidHandlerItem)out.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    if (fluidHandlerDummy2 != null) {
                        fluidHandlerDummy2.drain(this.input.getCapacity() - this.input.getFluidAmount(), true);
                        out = fluidHandlerDummy2.getContainer();
                        if (out.func_77973_b() == ForgeModContainer.getInstance().universalBucket) {
                            out = new ItemStack(Items.field_151133_ar);
                        }
                        if (this.internalStackHandler.insertItem(3, out, true).func_190926_b()) {
                            this.input.fill(fluid, true);
                            this.internalStackHandler.getStackInSlot(0).func_190918_g(1);
                            this.internalStackHandler.insertItem(3, out, false);
                            fluidChanged |= true;
                        }
                    }
                } else if ((fluid == null || fluid.getFluid() == null) && this.input.getFluidAmount() > 0) {
                    out = new ItemStack(in.func_77973_b());
                    IFluidHandlerItem fluidHandlerDummy3 = (IFluidHandlerItem)out.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    amount = fluidHandlerDummy3.fill(this.input.getFluid(), true);
                    out = fluidHandlerDummy3.getContainer();
                    if (amount > 0 && this.internalStackHandler.insertItem(3, out, true).func_190926_b()) {
                        this.input.drain(amount, true);
                        this.internalStackHandler.getStackInSlot(0).func_190918_g(1);
                        this.internalStackHandler.insertItem(3, out, false);
                        fluidChanged |= true;
                    }
                }
            }
        }
        if (!this.internalStackHandler.getStackInSlot(1).func_190926_b() && !this.field_145850_b.field_72995_K) {
            stack = this.internalStackHandler.getStackInSlot(1);
            in = stack.func_77946_l();
            in.func_190920_e(1);
            if (stack.func_77973_b() == Items.field_151069_bo && this.output.getFluidAmount() > 0) {
                out2 = new ItemStack((Item)ModItems.FLUID_BOTTLE);
                fluidHandlerDummy = (IFluidHandlerItem)out2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                amount2 = fluidHandlerDummy.fill(this.output.getFluid(), true);
                out2 = fluidHandlerDummy.getContainer();
                if (amount2 > 0 && this.internalStackHandler.insertItem(4, out2, true).func_190926_b()) {
                    this.output.drain(amount2, true);
                    this.internalStackHandler.getStackInSlot(1).func_190918_g(1);
                    this.internalStackHandler.insertItem(4, out2, false);
                    fluidChanged |= true;
                }
            } else if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && ((fluid = FluidUtil.getFluidContained((ItemStack)in)) == null || fluid.getFluid() == null) && this.output.getFluidAmount() > 0) {
                out = new ItemStack(in.func_77973_b());
                IFluidHandlerItem fluidHandlerDummy4 = (IFluidHandlerItem)out.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                amount = fluidHandlerDummy4.fill(this.output.getFluid(), true);
                out = fluidHandlerDummy4.getContainer();
                if (amount > 0 && this.internalStackHandler.insertItem(4, out, true).func_190926_b()) {
                    this.output.drain(amount, true);
                    this.internalStackHandler.getStackInSlot(1).func_190918_g(1);
                    this.internalStackHandler.insertItem(4, out, false);
                    fluidChanged |= true;
                }
            }
        }
        if (!this.internalStackHandler.getStackInSlot(2).func_190926_b() && !this.field_145850_b.field_72995_K) {
            stack = this.internalStackHandler.getStackInSlot(2);
            in = stack.func_77946_l();
            in.func_190920_e(1);
            if (stack.func_77973_b() == Items.field_151069_bo && this.auxiliary.getFluidAmount() > 0) {
                NBTTagCompound fluidTag;
                out2 = new ItemStack((Item)ModItems.FLUID_BOTTLE);
                fluidHandlerDummy = (IFluidHandlerItem)out2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                int amount3 = fluidHandlerDummy.fill(this.auxiliary.getFluid(), true);
                out2 = fluidHandlerDummy.getContainer();
                if (out2.func_77942_o() && out2.func_77978_p().func_74764_b("Fluid") && !(fluidTag = out2.func_77978_p().func_74775_l("Fluid")).func_74764_b("Tag") && this.auxiliary.getFluid().tag != null) {
                    fluidTag.func_74782_a("Tag", (NBTBase)this.auxiliary.getFluid().tag);
                }
                if (amount3 > 0 && this.internalStackHandler.insertItem(5, out2, true).func_190926_b()) {
                    this.auxiliary.drain(amount3, true);
                    this.internalStackHandler.getStackInSlot(2).func_190918_g(1);
                    this.internalStackHandler.insertItem(5, out2, false);
                    fluidChanged |= true;
                }
            } else if (in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                fluid = FluidUtil.getFluidContained((ItemStack)in);
                if (fluid != null && fluid.getFluid() != null && fluid.getFluid() instanceof FluidBooze && this.auxiliary.fill(fluid, false) == fluid.amount) {
                    out = new ItemStack(in.func_77973_b());
                    IFluidHandlerItem fluidHandlerDummy5 = (IFluidHandlerItem)out.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    fluidHandlerDummy5.drain(this.auxiliary.getCapacity() - this.auxiliary.getFluidAmount(), true);
                    out = fluidHandlerDummy5.getContainer();
                    if (out.func_77973_b() == ForgeModContainer.getInstance().universalBucket) {
                        out = new ItemStack(Items.field_151133_ar);
                    }
                    if (this.internalStackHandler.insertItem(5, out, true).func_190926_b()) {
                        this.auxiliary.fill(fluid, true);
                        this.internalStackHandler.getStackInSlot(2).func_190918_g(1);
                        this.internalStackHandler.insertItem(5, out, false);
                        fluidChanged |= true;
                    }
                } else if ((fluid == null || fluid.getFluid() == null) && this.auxiliary.getFluidAmount() > 0) {
                    out = new ItemStack(in.func_77973_b());
                    IFluidHandlerItem fluidHandlerDummy6 = (IFluidHandlerItem)out.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    amount = fluidHandlerDummy6.fill(this.auxiliary.getFluid(), true);
                    out = fluidHandlerDummy6.getContainer();
                    if (amount > 0 && this.internalStackHandler.insertItem(5, out, true).func_190926_b()) {
                        this.auxiliary.drain(amount, true);
                        this.internalStackHandler.getStackInSlot(2).func_190918_g(1);
                        this.internalStackHandler.insertItem(5, out, false);
                        fluidChanged |= true;
                    }
                }
            }
        }
        if (fluidChanged) {
            this.brewTime = 0;
            if (this.recipe != null && !this.recipe.matches(this.input.getFluid(), this.auxiliary.getFluid())) {
                this.recipe = null;
            }
            this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
        }
        if (this.recipe == null && this.input.getFluidAmount() > 0) {
            this.recipe = this.getRecipe();
        }
        if (this.recipe != null && this.brewTime % 20 == 0) {
            this.recipe = this.getRecipe();
        }
        if (this.recipe != null) {
            ++this.brewTime;
            if (this.brewTime >= this.getMaxBrewTime()) {
                this.brew();
                this.brewTime = 0;
                this.recipe = null;
            }
        } else {
            this.brewTime = 0;
        }
    }

    private void brew() {
        this.brewTime = 0;
        int amount = this.output.getCapacity() - this.output.getFluidAmount();
        if ((amount = Math.min(amount, this.input.getFluidAmount())) > 0 && this.recipe.matches(this.input.getFluid(), this.auxiliary.getFluid()) && !this.field_145850_b.field_72995_K) {
            FluidStack out = this.recipe.getResult(this.input.getFluid(), this.auxiliary.getFluid());
            if (this.output.getFluidAmount() > 0 && this.output.getFluid().getFluid() == out.getFluid()) {
                out = this.output.getFluid().copy();
            }
            out.amount = amount;
            if (this.output.fill(out, false) == amount && this.input.drain((int)amount, (boolean)false).amount == amount) {
                this.output.fill(out, true);
                this.input.drain(amount, true);
                this.recipe = null;
            }
        }
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        this.func_70296_d();
    }

    private BrewingBarrelRecipe getRecipe() {
        if (this.input.getFluidAmount() > 0) {
            for (BrewingBarrelRecipe recipe : Recipes.brewingRecipes) {
                if (!recipe.matches(this.input.getFluid(), this.auxiliary.getFluid()) || this.output.getFluid() != null && (recipe.getResult(this.input.getFluid(), this.auxiliary.getFluid()).getFluid() != this.output.getFluid().getFluid() || this.output.getFluidAmount() >= this.output.getCapacity())) continue;
                return recipe;
            }
        }
        return null;
    }

    public boolean isBrewing() {
        return this.brewTime > 0;
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public int getMaxBrewTime() {
        return Config.MAX_BREW_TIME;
    }
}

