/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.crafttweaker;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import rustic.common.crafting.ICondenserRecipe;

public class CrTCondenserRecipe
implements ICondenserRecipe {
    private int time;
    private ItemStack output;
    private FluidStack fluid;
    private IIngredient bottle;
    private IIngredient modifier;
    private List<IIngredient> inputs;

    public CrTCondenserRecipe(@Nonnull ItemStack output, IIngredient[] inputs) {
        this(output, inputs, null);
    }

    public CrTCondenserRecipe(@Nonnull ItemStack output, IIngredient[] inputs, IIngredient modifier) {
        this(output, inputs, modifier, (IIngredient)CraftTweakerMC.getIItemStack((ItemStack)new ItemStack(Items.field_151069_bo)));
    }

    public CrTCondenserRecipe(@Nonnull ItemStack output, IIngredient[] inputs, IIngredient modifier, @Nonnull IIngredient bottle) {
        this(output, inputs, modifier, bottle, new FluidStack(FluidRegistry.WATER, 125));
    }

    public CrTCondenserRecipe(@Nonnull ItemStack output, IIngredient[] inputs, IIngredient modifier, @Nonnull IIngredient bottle, @Nonnull FluidStack fluid) {
        this(output, inputs, modifier, bottle, fluid, 400);
    }

    public CrTCondenserRecipe(@Nonnull ItemStack output, IIngredient[] inputs, IIngredient modifier, @Nonnull IIngredient bottle, @Nonnull FluidStack fluid, int time) {
        this.output = output;
        this.fluid = fluid;
        this.bottle = bottle;
        this.modifier = modifier;
        this.inputs = new ArrayList<IIngredient>();
        for (IIngredient ing : inputs) {
            this.inputs.add(ing);
        }
        this.time = Math.max(0, time);
    }

    @Override
    public boolean matches(Fluid fluid, ItemStack modifier, ItemStack bottle, ItemStack[] inputs) {
        if (fluid != this.fluid.getFluid()) {
            return false;
        }
        if (this.modifier != null && !this.modifier.matchesExact(CraftTweakerMC.getIItemStack((ItemStack)modifier)) || this.modifier == null && !modifier.func_190926_b()) {
            return false;
        }
        if (!this.bottle.matchesExact(CraftTweakerMC.getIItemStack((ItemStack)bottle))) {
            return false;
        }
        ArrayList<IIngredient> tempInputs = new ArrayList<IIngredient>(this.inputs);
        for (ItemStack stack : inputs) {
            if (stack == null || stack.func_190926_b()) continue;
            boolean stackNotInput = true;
            IItemStack input = CraftTweakerMC.getIItemStack((ItemStack)stack);
            for (IIngredient in : tempInputs) {
                if (in == null) {
                    tempInputs.remove(in);
                    continue;
                }
                if (!in.matchesExact(input)) continue;
                stackNotInput = false;
                tempInputs.remove(in);
                break;
            }
            if (!stackNotInput) continue;
            return false;
        }
        return tempInputs.size() == 0;
    }

    @Override
    public boolean isBasic() {
        return this.modifier == null && this.inputs.size() <= 2;
    }

    @Override
    public boolean isAdvanced() {
        return this.inputs.size() <= 3;
    }

    @Override
    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public List<ItemStack> getModifiers() {
        if (this.modifier != null) {
            return this.modifier.getItems().stream().map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
        }
        return new ArrayList<ItemStack>();
    }

    @Override
    public List<ItemStack> getBottles() {
        return this.bottle.getItems().stream().map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
    }

    @Override
    public List<List<ItemStack>> getInputs() {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        for (IIngredient input : this.inputs) {
            if (input == null) {
                inputs.add(new ArrayList());
                continue;
            }
            inputs.add(input.getItems().stream().map(CraftTweakerMC::getItemStack).collect(Collectors.toList()));
        }
        return inputs;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public int getModifierConsumption(ItemStack modifier) {
        if (this.modifier != null) {
            IItemStack mod = CraftTweakerMC.getIItemStack((ItemStack)modifier);
            for (IItemStack stack : this.modifier.getItems()) {
                if (!stack.matchesExact(mod)) continue;
                return stack.getAmount();
            }
        }
        return 0;
    }

    @Override
    public int getBottleConsumption(ItemStack bottle) {
        IItemStack btl = CraftTweakerMC.getIItemStack((ItemStack)bottle);
        for (IItemStack stack : this.bottle.getItems()) {
            if (!stack.matchesExact(btl)) continue;
            return stack.getAmount();
        }
        return 1;
    }

    @Override
    public int[] getInputConsumption(ItemStack[] inputs) {
        int[] consume = new int[inputs.length];
        ArrayList<IIngredient> tempInputs = new ArrayList<IIngredient>(this.inputs);
        block0: for (int i = 0; i < inputs.length; ++i) {
            consume[i] = 0;
            if (inputs[i] == null) continue;
            IItemStack current = CraftTweakerMC.getIItemStack((ItemStack)inputs[i]);
            for (IIngredient in : tempInputs) {
                for (IItemStack stack : in.getItems()) {
                    if (!stack.matchesExact(current)) continue;
                    consume[i] = stack.getAmount();
                    continue block0;
                }
            }
        }
        return consume;
    }

    @Override
    public ItemStack getResult() {
        return this.output.func_77946_l();
    }
}

