/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.distribution;

import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.data.numbers.world.WorldValueProvider;
import cofh.cofhworld.world.distribution.Distribution;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class DistributionCave
extends Distribution {
    private static final INumberProvider GROUND_LEVEL = new WorldValueProvider("GROUND_LEVEL");
    private final WorldGenerator worldGen;
    private final INumberProvider count;
    private INumberProvider groundLevel = GROUND_LEVEL;
    private final boolean ceiling;

    public DistributionCave(String name, WorldGenerator worldGen, boolean ceiling, INumberProvider count, boolean regen) {
        super(name, regen);
        this.worldGen = worldGen;
        this.count = count;
        this.ceiling = ceiling;
    }

    public void setGroundLevel(INumberProvider level) {
        this.groundLevel = level;
    }

    @Override
    public boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        INumberProvider.DataHolder data = new INumberProvider.DataHolder(pos);
        int count = this.count.intValue(world, random, data);
        this.worldGen.func_175904_e();
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            IBlockState state;
            int stopY;
            int z;
            int x = blockX + random.nextInt(16);
            if (!this.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random)) continue;
            int seaLevel = this.groundLevel.intValue(world, random, data.setPosition((Vec3i)new BlockPos(x, 64, z)));
            if (seaLevel < 20 && this.groundLevel == GROUND_LEVEL) {
                seaLevel = world.func_72800_K();
            }
            int y = stopY = random.nextInt(1 + seaLevel / 2);
            while (!(state = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)) && ++y < seaLevel) {
            }
            if (y == seaLevel) {
                y = 0;
                while (!(state = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)) && ++y < stopY) {
                }
                if (y == stopY) continue;
            }
            if (this.ceiling) {
                if (y < stopY) {
                    seaLevel = stopY + 1;
                }
                do {
                    state = world.func_180495_p(new BlockPos(x, ++y, z));
                } while (y < seaLevel && state.func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)));
                if (y == seaLevel) {
                    continue;
                }
            } else if (state.func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y - 1, z))) {
                --y;
                while ((state = world.func_180495_p(new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, new BlockPos(x, y, z)) && y-- > 0) {
                }
                if (y == -1) continue;
            }
            generated |= this.worldGen.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }
}

