/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.prestige.api;

import com.google.gson.annotations.Expose;
import com.jarhax.prestige.Prestige;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class Reward {
    @Expose
    private final String identifier;
    @Expose
    private String title;
    @Expose
    private String description;
    @Expose
    private String icon;
    @Expose
    private int x;
    @Expose
    private int y;
    @Expose
    private int cost;
    @Expose
    private int sellPrice;
    @Expose
    private final Set<String> parents = new HashSet<String>();
    @Expose
    private final Set<String> children = new HashSet<String>();
    @Expose
    private boolean placed;

    public Reward(String identifier, String title, int x, int y, int cost, int sellPrice, ItemStack icon, String description) {
        if (identifier == null || identifier.isEmpty()) {
            throw new IllegalArgumentException("Prestige reward identifier can not be null or empty!");
        }
        if (identifier.matches("\\s+")) {
            throw new IllegalArgumentException("Prestige reward identifiers can not contain white space!");
        }
        if (icon == null || icon.func_190926_b()) {
            throw new IllegalArgumentException("Prestige reward icon can not be a null or empty/air item!");
        }
        this.identifier = identifier.toLowerCase();
        this.title = title;
        this.description = description;
        this.setIcon(icon);
        this.x = x;
        this.y = y;
        this.cost = cost;
        this.sellPrice = sellPrice;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public ItemStack getIcon() {
        try {
            return new ItemStack(JsonToNBT.func_180713_a((String)this.icon));
        }
        catch (NBTException e) {
            Prestige.LOG.error("The reward \"{}\" has an invalid icon value of \"{}\".", (Object)this.identifier, (Object)this.icon);
            return new ItemStack(Blocks.field_180401_cv);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getCost() {
        return this.cost;
    }

    public int getSellPrice() {
        return this.sellPrice;
    }

    public void setSellPrice(int sellPrice) {
        this.sellPrice = sellPrice;
    }

    public Set<Reward> getChildren() {
        HashSet<Reward> rewards = new HashSet<Reward>();
        for (String s : this.children) {
            rewards.add(Prestige.REGISTRY.get(s));
        }
        return rewards;
    }

    public void addChild(Reward child) {
        if (this.children.contains(child.identifier)) {
            throw new IllegalArgumentException(String.format("The reward %s can not be a child of %s because it is a parent of %s.", child.getIdentifier(), this.identifier, this.identifier));
        }
        child.parents.add(this.getIdentifier());
        this.children.add(child.getIdentifier());
    }

    public void removeChild(Reward child) {
        this.children.remove(child.getIdentifier());
        child.parents.remove(this.getIdentifier());
    }

    public Set<Reward> getParents() {
        HashSet<Reward> rewards = new HashSet<Reward>();
        for (String s : this.parents) {
            rewards.add(Prestige.REGISTRY.get(s));
        }
        return rewards;
    }

    public void addParent(Reward parent) {
        if (this.children.contains(parent.identifier)) {
            throw new IllegalArgumentException(String.format("The reward %s can not be a parent of %s because it is a child of %s.", parent.getIdentifier(), this.identifier, this.identifier));
        }
        this.parents.add(parent.getIdentifier());
        parent.addChild(this);
    }

    public void clearParents() {
        for (Reward reward : this.getParents()) {
            reward.children.remove(this.getIdentifier());
        }
        this.parents.clear();
    }

    public void clearChildren() {
        for (Reward reward : this.getChildren()) {
            reward.parents.remove(this.getIdentifier());
        }
        this.children.clear();
    }

    public void removeParent(Reward parent) {
        this.parents.remove(parent.getIdentifier());
        parent.children.remove(this.getIdentifier());
    }

    public boolean isPlaced() {
        return this.placed;
    }

    public void setPlaced(boolean placed) {
        this.placed = placed;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIcon(ItemStack icon) {
        this.icon = icon.func_77955_b(new NBTTagCompound()).toString();
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }
}

