/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.prestige.client;

import com.jarhax.prestige.events.ClientEventHandler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.ARBShaderObjects;

public class ShaderHandler {
    public static final int VERT = 35633;
    public static final int FRAG = 35632;
    public static int SCREEN;
    public static int STAR;
    public static int RECTS;
    public static int SQUIGGLE_STAR;
    public static int FBM;
    public static int MAZE;
    public static int LAVA_LAMP;
    public static int WAVES;
    public static final List<Integer> SHADERS;

    public static void registerShaders() {
        try {
            SCREEN = ShaderHandler.create("/assets/prestige/shaders/screen");
            STAR = ShaderHandler.create("/assets/prestige/shaders/star");
            RECTS = ShaderHandler.create("/assets/prestige/shaders/rects");
            SQUIGGLE_STAR = ShaderHandler.create("/assets/prestige/shaders/squigglestar");
            FBM = ShaderHandler.create("/assets/prestige/shaders/fbm");
            MAZE = ShaderHandler.create("/assets/prestige/shaders/maze");
            LAVA_LAMP = ShaderHandler.create("/assets/prestige/shaders/lava_lamp");
            WAVES = ShaderHandler.create("/assets/prestige/shaders/waves");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unregisterShaders() {
        for (Integer shader : SHADERS) {
            ShaderHandler.deleteShader(shader);
        }
        SHADERS.clear();
    }

    public static void deleteShader(int id) {
        if (id != 0) {
            OpenGlHelper.func_153187_e((int)id);
        }
    }

    public static void useShader(int shader, Map<String, Object> data) {
        ShaderHandler.useShader(shader, Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d, data);
    }

    public static void useShader(int shader, int width, int height, Map<String, Object> data) {
        if (!ShaderHandler.useShaders()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            int time = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
            ARBShaderObjects.glUniform1fARB((int)time, (float)ClientEventHandler.totalTime);
            int res = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"resolution");
            ARBShaderObjects.glUniform3fARB((int)res, (float)width, (float)height, (float)0.0f);
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                int id = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)entry.getKey());
                if (entry.getValue() instanceof Float) {
                    ARBShaderObjects.glUniform1fARB((int)id, (float)((Float)entry.getValue()).floatValue());
                }
                if (!(entry.getValue() instanceof Integer)) continue;
                ARBShaderObjects.glUniform1iARB((int)id, (int)((Integer)entry.getValue()));
            }
        }
    }

    public static void userShader(int shader) {
        ShaderHandler.useShader(shader, new HashMap<String, Object>());
    }

    public static boolean useShaders() {
        return OpenGlHelper.field_148824_g;
    }

    public static void releaseShader() {
        ShaderHandler.useShader(0, new HashMap<String, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int create(String location) {
        int vertShader = 0;
        int fragShader = 0;
        int program = 0;
        try {
            vertShader = ShaderHandler.createShader(location + ".vert", 35633);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            int n = 0;
            return n;
        }
        try {
            fragShader = ShaderHandler.createShader(location + ".frag", 35632);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            int n = 0;
            return n;
        }
        program = ARBShaderObjects.glCreateProgramObjectARB();
        if (program == 0) {
            return 0;
        }
        if (vertShader != 0) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertShader);
        }
        if (fragShader != 0) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragShader);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            System.err.println(ShaderHandler.getLogInfo(program));
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            System.err.println(ShaderHandler.getLogInfo(program));
            return 0;
        }
        SHADERS.add(program);
        return program;
    }

    private static int createShader(String filename, int shaderType) throws Exception {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            InputStream stream = ShaderHandler.class.getResourceAsStream(filename);
            if (stream == null) {
                return 0;
            }
            String string = IOUtils.toString((InputStream)stream);
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)string);
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderHandler.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception exc) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            throw exc;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    static {
        SHADERS = new ArrayList<Integer>();
    }
}

