/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.prestige.client.gui;

import com.jarhax.prestige.Prestige;
import com.jarhax.prestige.api.Reward;
import com.jarhax.prestige.client.ShaderHandler;
import com.jarhax.prestige.client.gui.GuiPrestigeBase;
import com.jarhax.prestige.client.gui.objects.GuiObject;
import com.jarhax.prestige.client.gui.objects.GuiObjectBackGround;
import com.jarhax.prestige.client.gui.objects.GuiObjectBorder;
import com.jarhax.prestige.client.gui.objects.GuiObjectReward;
import com.jarhax.prestige.client.utils.RenderUtils;
import com.jarhax.prestige.config.Config;
import com.jarhax.prestige.packet.PacketGiveRewards;
import com.jarhax.prestige.packet.PacketRespec;
import com.jarhax.prestige.packet.PacketSellRewards;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiPrestige
extends GuiPrestigeBase {
    private GuiObjectBackGround backGround;
    private GuiObjectBorder border;
    private final int north = 0;
    private final int east = 1;
    private final int south = 2;
    private final int west = 3;
    private boolean respec;
    public GuiButtonExt confirmBtn;
    public GuiButtonExt cancelBtn;
    public GuiButtonExt respecBtn;

    public void generateRewards() {
        this.guiObjects.clear();
        LinkedList<Reward> values = new LinkedList<Reward>(Prestige.REGISTRY.values());
        values.sort(Comparator.comparing(Reward::getIdentifier));
        for (Reward reward : values) {
            if (!reward.isPlaced()) continue;
            GuiObjectReward rew = new GuiObjectReward(this, reward);
            if (Prestige.clientPlayerData.hasReward(reward)) {
                rew.setPurchased(true);
            }
            this.guiObjects.put(rew.getReward().getIdentifier(), rew);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        String[] rewards = new String[this.getRewardsToGive().size()];
        for (int i = 0; i < rewards.length; ++i) {
            rewards[i] = this.getRewardsToGive().get(i).getReward().getIdentifier();
        }
        Prestige.NETWORK.sendToServer((IMessage)new PacketGiveRewards(rewards));
        String[] sellActions = new String[this.getRewardsToSell().size()];
        for (int i = 0; i < sellActions.length; ++i) {
            sellActions[i] = this.getRewardsToSell().get(i).getReward().getIdentifier();
        }
        Prestige.NETWORK.sendToServer((IMessage)new PacketSellRewards(sellActions));
    }

    public void func_73866_w_() {
        this.guiWidth = this.field_146294_l - 40;
        this.guiHeight = this.field_146295_m - 40;
        super.func_73866_w_();
        this.left = this.field_146294_l / 2 - this.guiWidth / 2;
        this.top = this.field_146295_m / 2 - this.guiHeight / 2;
        this.player = this.field_146297_k.field_71439_g;
        this.guiObjects = new LinkedHashMap();
        this.backGround = new GuiObjectBackGround(this, this.left, this.top, this.guiWidth, this.guiHeight);
        this.border = new GuiObjectBorder(this, this.left, this.top, this.guiWidth, this.guiHeight);
        this.generateRewards();
        this.rewardsToGive = new LinkedList();
        this.rewardsToSell = new LinkedList();
        this.respecBtn = new GuiButtonExt(0, this.guiWidth - 46, this.guiHeight + 5, 50, this.field_146289_q.field_78288_b + 2, "Respec");
        this.confirmBtn = new GuiButtonExt(1, this.field_146294_l / 2 - 55, this.guiHeight / 2 + (this.field_146289_q.field_78288_b + 2) / 2, 50, this.field_146289_q.field_78288_b + 2, "Confirm");
        this.cancelBtn = new GuiButtonExt(2, this.field_146294_l / 2 + 5, this.guiHeight / 2 + (this.field_146289_q.field_78288_b + 2) / 2, 50, this.field_146289_q.field_78288_b + 2, "Cancel");
        if (Config.respecEnabled) {
            this.field_146292_n.add(this.respecBtn);
        }
        this.field_146292_n.add(this.confirmBtn);
        this.field_146292_n.add(this.cancelBtn);
        this.field_146292_n.add(new GuiButtonExt(-1, this.guiWidth - 96, this.top + 4, 100, this.field_146289_q.field_78288_b + 2, "Switch Background"));
        this.confirmBtn.field_146125_m = false;
        this.cancelBtn.field_146125_m = false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiObject object2 : this.guiObjects.values()) {
            object2.update();
        }
        this.guiObjects.values().forEach(object -> object.setVisible(true));
        for (GuiObject object2 : this.guiObjects.values()) {
            if (object2.isAlwaysVisible()) continue;
            if (this.backGround.collides(object2)) {
                object2.setVisible(true);
                continue;
            }
            object2.setVisible(false);
        }
        this.guiObjects.values().forEach(object -> object.setVisible(true));
        for (GuiObject object2 : this.guiObjects.values()) {
            if (!((GuiObjectReward)object2).isPlaced() || object2.isAlwaysVisible()) continue;
            if (this.backGround.collides(object2)) {
                object2.setVisible(true);
                continue;
            }
            object2.setVisible(false);
        }
        long sells = Prestige.clientPlayerData.getPrestige();
        for (Reward reward : Prestige.clientPlayerData.getUnlockedRewards()) {
            if (reward == null) continue;
            sells += (long)reward.getSellPrice();
        }
        long cost = Math.round((float)sells / 10.0f);
        this.confirmBtn.field_146124_l = Prestige.clientPlayerData.getPrestige() >= cost;
        if (Prestige.clientPlayerData.getRespTimer() >= 0L) {
            this.confirmBtn.field_146124_l = false;
            this.respecBtn.field_146124_l = false;
            this.respecBtn.field_146126_j = Prestige.clientPlayerData.getRespTimer() + "";
        } else {
            this.confirmBtn.field_146124_l = true;
            this.respecBtn.field_146124_l = true;
            this.respecBtn.field_146126_j = "Respec";
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179094_E();
        this.backGround.draw(this.left, this.top, mouseX, mouseY, partialTicks);
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("prestige", "textures/gui/gui_prestige_line.png"));
        ScaledResolution resolution = new ScaledResolution(this.field_146297_k);
        int scale = resolution.func_78325_e();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((this.left + 4) * scale), (int)((this.top - 1 + 4) * scale), (int)((this.guiWidth - 8) * scale), (int)((this.guiHeight + 1 - 8) * scale));
        for (GuiObjectReward parent : this.guiObjects.values()) {
            Vec3d start = new Vec3d((double)(parent.getX() + (float)(parent.getWidth() / 2)), (double)(parent.getY() + (float)(parent.getHeight() / 2)), 0.0);
            for (Reward child : parent.getReward().getChildren()) {
                Object childObject;
                if (child == null || (childObject = this.getObject(child.getIdentifier())) == null) continue;
                Vec3d end = new Vec3d((double)(((GuiObject)childObject).getX() + (float)(((GuiObject)childObject).getWidth() / 2)), (double)(((GuiObject)childObject).getY() + (float)(((GuiObject)childObject).getHeight() / 2)), 0.0);
                GlStateManager.func_179094_E();
                double angle = Math.atan2(((GuiObject)childObject).getY() - parent.getY(), ((GuiObject)childObject).getX() - parent.getX()) * 180.0 / Math.PI;
                GL11.glTranslated((double)(parent.getX() + (float)(parent.getWidth() / 2)), (double)(parent.getY() + (float)(parent.getHeight() / 2)), (double)0.0);
                GL11.glRotated((double)angle, (double)0.0, (double)0.0, (double)1.0);
                float length = (float)start.func_72438_d(end);
                RenderUtils.drawTexturedModalRect(0.0f, -2.0f, RenderUtils.remap((float)((double)System.nanoTime() / 1.0E9), 1.0f, 0.0f, 0.0f, 16.0f), 0.0f, length, 4.0f);
                GL11.glTranslated((double)(-(parent.getX() + (float)(parent.getWidth() / 2))), (double)(-(parent.getY() + (float)(parent.getHeight() / 2))), (double)0.0);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179094_E();
        for (GuiObject object : this.guiObjects.values()) {
            if (!object.isVisible()) continue;
            object.draw(this.left, this.top, mouseX, mouseY, partialTicks);
        }
        for (Object reward : this.guiObjects.values()) {
            if (!((GuiObject)reward).isVisible() || !(((GuiObject)reward).getY() >= (float)this.getTop()) || !(((GuiObject)reward).getY() + (float)((GuiObject)reward).getHeight() <= (float)(this.getTop() + this.getGuiHeight()))) continue;
            ((GuiObjectReward)reward).draw(this.left, this.top, mouseX, mouseY, partialTicks);
        }
        GL11.glDisable((int)3089);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)0.0, (double)0.0, (double)500.0);
        this.border.draw(this.left, this.top, mouseX, mouseY, partialTicks);
        this.field_146289_q.func_78276_b("Prestige points: " + Prestige.clientPlayerData.getPrestige(), this.left + 5, this.top + 5, 0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.0);
        GlStateManager.func_179121_F();
        for (Object reward : this.guiObjects.values()) {
            if (!((GuiObject)reward).isVisible() || !((GuiObject)reward).collides(mouseX, mouseY, mouseX, mouseY) || !(((GuiObject)reward).getY() >= (float)this.getTop()) || !(((GuiObject)reward).getY() + (float)((GuiObject)reward).getHeight() <= (float)(this.getTop() + this.getGuiHeight()))) continue;
            ((GuiObjectReward)reward).drawText(mouseX, mouseY);
        }
        boolean[] sides = new boolean[4];
        for (GuiObjectReward reward : this.guiObjects.values()) {
            if (!reward.isPlaced()) continue;
            if (sides[0] && sides[1] && sides[3] && sides[2]) break;
            if (!sides[3] && reward.getX() < (float)this.left) {
                sides[3] = true;
            }
            if (!sides[1] && reward.getX() > (float)(this.left + this.guiWidth)) {
                sides[1] = true;
            }
            if (!sides[0] && reward.getY() < (float)this.top) {
                sides[0] = true;
            }
            if (sides[2] || !(reward.getY() > (float)(this.top + this.guiHeight))) continue;
            sides[2] = true;
        }
        if (sides[0] || sides[1] || sides[3] || sides[2]) {
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("prestige", "textures/gui/gui_prestige_line.png"));
            if (sides[0]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 - 4, this.top + 25, this.left + this.guiWidth / 2, this.top + 20, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 + 4, this.top + 25, this.left + this.guiWidth / 2, this.top + 20, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 - 4, this.top + 25, this.left + this.guiWidth / 2 + 4, this.top + 25, 0.0f, 1.0f, 1.0f, 5.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179121_F();
            }
            if (sides[2]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 - 4, this.top + this.guiHeight - 25, this.left + this.guiWidth / 2, this.top + this.guiHeight - 20, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 + 4, this.top + this.guiHeight - 25, this.left + this.guiWidth / 2, this.top + this.guiHeight - 20, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth / 2 - 4, this.top + this.guiHeight - 25, this.left + this.guiWidth / 2 + 4, this.top + this.guiHeight - 25, 0.0f, 1.0f, 1.0f, 5.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179121_F();
            }
            if (sides[1]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth - 25, this.top + this.guiHeight / 2 - 4, this.left + this.guiWidth - 20, this.top + this.guiHeight / 2, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth - 25, this.top + this.guiHeight / 2 + 4, this.left + this.guiWidth - 20, this.top + this.guiHeight / 2, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + this.guiWidth - 25, this.top + this.guiHeight / 2 - 4, this.left + this.guiWidth - 25, this.top + this.guiHeight / 2 + 4, 0.0f, 1.0f, 1.0f, 5.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179121_F();
            }
            if (sides[3]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                RenderUtils.drawLineUntextured(this.left + 25, this.top + this.guiHeight / 2 - 4, this.left + 20, this.top + this.guiHeight / 2, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + 25, this.top + this.guiHeight / 2 + 4, this.left + 20, this.top + this.guiHeight / 2, 0.0f, 1.0f, 1.0f, 5.0f);
                RenderUtils.drawLineUntextured(this.left + 25, this.top + this.guiHeight / 2 - 4, this.left + 25, this.top + this.guiHeight / 2 + 4, 0.0f, 1.0f, 1.0f, 5.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1000.0f);
        if (Config.respecEnabled && this.respec) {
            int padding = 20;
            RenderUtils.drawRect(padding, padding, this.field_146294_l - padding, this.field_146295_m - padding, -1441722095);
            String text = "This action will remove all your unlocked rewards, are you sure you want to do this?";
            this.field_146289_q.func_78276_b(text, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(text) / 2, this.field_146295_m / 2 - 40 - this.field_146289_q.field_78288_b * 2, 0xFFFFFF);
            long sells = 0L;
            for (Reward reward : Prestige.clientPlayerData.getUnlockedRewards()) {
                sells += (long)reward.getSellPrice();
            }
            text = "By doing this, you will receive " + sells + " prestige points.";
            this.field_146289_q.func_78276_b(text, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(text) / 2, this.field_146295_m / 2 - 40 - this.field_146289_q.field_78288_b, 0xFFFFFF);
            long cost = (long)Math.ceil((float)(Prestige.clientPlayerData.getPrestige() + sells) / 10.0f);
            text = "You will need " + cost + " prestige points to complete this action.";
            this.field_146289_q.func_78276_b(text, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(text) / 2, this.field_146295_m / 2 - 40, 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1000.0f);
    }

    public void func_146278_c(int tint) {
        super.func_146278_c(tint);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.prevMX = mouseX;
        this.prevMY = mouseY;
        if (!this.respec) {
            if (mouseButton == 0) {
                boolean valid = true;
                for (GuiObject object : this.guiObjects.values()) {
                    if (object.collides(mouseX, mouseY, mouseX, mouseY)) {
                        valid = false;
                    }
                    object.mouseClicked(mouseX, mouseY, mouseButton);
                }
                if (valid) {
                    this.backGround.mouseClicked(mouseX, mouseY, mouseButton);
                }
            } else if (mouseButton == 1) {
                boolean valid = true;
                for (GuiObject object : this.guiObjects.values()) {
                    if (object.collides(mouseX, mouseY, mouseX, mouseY)) {
                        valid = false;
                    }
                    object.mouseClicked(mouseX, mouseY, mouseButton);
                }
                if (valid) {
                    this.backGround.mouseClicked(mouseX, mouseY, mouseButton);
                }
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == -1 && ShaderHandler.SHADERS.size() > 0) {
            Config.shaderIndex = (Config.shaderIndex + 1) % ShaderHandler.SHADERS.size();
            Config.config.save();
        } else if (button.field_146127_k == 0) {
            this.respec = true;
            this.respecBtn.field_146125_m = false;
            this.confirmBtn.field_146125_m = true;
            this.cancelBtn.field_146125_m = true;
        } else if (button.field_146127_k == 1) {
            this.respec = false;
            this.respecBtn.field_146125_m = true;
            this.confirmBtn.field_146125_m = false;
            this.cancelBtn.field_146125_m = false;
            long sells = 0L;
            for (Reward reward : Prestige.clientPlayerData.getUnlockedRewards()) {
                sells += (long)reward.getSellPrice();
            }
            long ceil = (long)Math.ceil((float)(Prestige.clientPlayerData.getPrestige() + sells) / 10.0f);
            long currentTime = Config.respecCooldown;
            Prestige.clientPlayerData.setRespTimer(currentTime);
            Prestige.clientPlayerData.addPrestige(sells -= ceil);
            this.getRewardsToGive().clear();
            for (GuiObjectReward value : this.guiObjects.values()) {
                if (!value.isPurchased()) continue;
                this.getRewardsToSell().add(value);
            }
            Prestige.clientPlayerData.getUnlockedRewards().clear();
            Prestige.NETWORK.sendToServer((IMessage)new PacketRespec());
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPrestige());
        } else if (button.field_146127_k == 2) {
            this.respec = false;
            this.respecBtn.field_146125_m = true;
            this.confirmBtn.field_146125_m = false;
            this.cancelBtn.field_146125_m = false;
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (!this.respec) {
            for (GuiObjectReward object : this.guiObjects.values()) {
                object.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
            }
            this.backGround.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
            this.prevMX = mouseX;
            this.prevMY = mouseY;
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (!this.respec) {
            this.prevMX = -1;
            this.prevMY = -1;
            this.backGround.mouseReleased(mouseX, mouseY, state);
            for (GuiObject object : this.guiObjects.values()) {
                object.mouseReleased(mouseX, mouseY, state);
            }
        }
    }

    public GuiObjectReward getObject(String identifier) {
        for (GuiObjectReward reward : this.guiObjects.values()) {
            if (!reward.getReward().getIdentifier().equals(identifier)) continue;
            return reward;
        }
        return null;
    }
}

