/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.prestige.client.gui.objects;

import com.jarhax.prestige.Prestige;
import com.jarhax.prestige.api.Reward;
import com.jarhax.prestige.client.gui.GuiPrestigeBase;
import com.jarhax.prestige.client.gui.objects.GuiObject;
import com.jarhax.prestige.client.utils.RenderUtils;
import com.jarhax.prestige.compat.crt.IRewardCondition;
import com.jarhax.prestige.config.Config;
import com.jarhax.prestige.packet.PacketAttemptPurchase;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiObjectReward
extends GuiObject {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("prestige", "textures/gui/gui_prestige_icons.png");
    private final Reward reward;
    private boolean purchased;
    private boolean purchasable;
    private ItemStack renderStack;

    public GuiObjectReward(GuiPrestigeBase parent, int x, int y, int width, int height, Reward reward) {
        super(parent, x, y, width, height);
        this.reward = reward;
        this.renderStack = reward.getIcon();
        List conditions = Prestige.REWARD_CONDITIONS.getOrDefault(reward.getIdentifier(), new ArrayList());
        boolean valid = true;
        for (IRewardCondition condition : conditions) {
            if (condition.process(CraftTweakerMC.getIWorld((World)this.mc.field_71441_e), CraftTweakerMC.getIPlayer((EntityPlayer)this.mc.field_71439_g))) continue;
            valid = false;
        }
        this.setPurchasable(valid);
    }

    public GuiObjectReward(GuiPrestigeBase parent, Reward reward) {
        super(parent, reward.getX(), reward.getY(), 32, 32);
        this.reward = reward;
        this.renderStack = reward.getIcon();
        List conditions = Prestige.REWARD_CONDITIONS.getOrDefault(reward.getIdentifier(), new ArrayList());
        boolean valid = true;
        for (IRewardCondition condition : conditions) {
            if (condition.process(CraftTweakerMC.getIWorld((World)this.mc.field_71441_e), CraftTweakerMC.getIPlayer((EntityPlayer)this.mc.field_71439_g))) continue;
            valid = false;
        }
        this.setPurchasable(valid);
    }

    @Override
    public void update() {
        super.update();
        List conditions = Prestige.REWARD_CONDITIONS.getOrDefault(this.reward.getIdentifier(), new ArrayList());
        boolean valid = true;
        for (IRewardCondition condition : conditions) {
            if (condition.process(CraftTweakerMC.getIWorld((World)this.mc.field_71441_e), CraftTweakerMC.getIPlayer((EntityPlayer)this.mc.field_71439_g))) continue;
            valid = false;
        }
        this.setPurchasable(valid);
    }

    @Override
    public void draw(int left, int top, int mouseX, int mouseY, float partialTicks) {
        this.mc.func_110434_K().func_110577_a(BACKGROUND);
        if (this.isPurchased()) {
            float[] argb = Config.getARGB(Config.purchasedColour);
            GlStateManager.func_179124_c((float)argb[1], (float)argb[2], (float)argb[3]);
        } else if (!Prestige.clientPlayerData.canPurchase(this.getReward()) || !this.isPurchasable()) {
            float[] argb = Config.getARGB(Config.unavailableColour);
            GlStateManager.func_179124_c((float)argb[1], (float)argb[2], (float)argb[3]);
        } else {
            float[] argb = Config.getARGB(Config.purchaseableColour);
            GlStateManager.func_179124_c((float)argb[1], (float)argb[2], (float)argb[3]);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        this.mc.func_110434_K().func_110577_a(BACKGROUND);
        RenderUtils.drawTexturedModalRect(this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight());
        if (this.isPurchased() || !Prestige.clientPlayerData.canPurchase(this.getReward())) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.renderIcon();
        if (this.collides(mouseX, mouseY, mouseX, mouseY)) {
            this.drawText(mouseX, mouseY);
        }
    }

    public void renderIcon() {
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glTranslated((double)(this.getX() + 8.0f), (double)(this.getY() + 8.0f), (double)-50.0);
        this.mc.func_175599_af().func_175042_a(this.renderStack, 0, 0);
        GL11.glTranslated((double)(-(this.getX() + 8.0f)), (double)(-(this.getY() + 8.0f)), (double)50.0);
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
    }

    public void drawText(int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179145_e();
        LinkedList<String> text = new LinkedList<String>();
        text.add(this.reward.getTitle());
        text.add("");
        for (String s : this.reward.getDescription().split("\\\\n")) {
            text.add("- " + s.replaceAll("\\\\t", "    "));
        }
        text.add("- costs: " + this.reward.getCost() + " prestige points");
        this.getParent().func_146283_a(text, mouseX, mouseY);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        GL11.glPopMatrix();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && this.collides(mouseX, mouseY, mouseX, mouseY) && Prestige.clientPlayerData.canPurchase(this.getReward()) && this.isPurchasable()) {
            this.setPurchased(true);
            this.parent.getRewardsToGive().add(this);
            this.parent.getRewardsToSell().remove(this);
            Prestige.NETWORK.sendToServer((IMessage)new PacketAttemptPurchase(this.getReward()));
        }
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.addX(-((float)this.getParent().getPrevMX() - (float)mouseX) / 1.5f);
        this.addY(-((float)this.getParent().getPrevMY() - (float)mouseY) / 1.5f);
        this.setX(Math.round(this.x));
        this.setY(Math.round(this.y));
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
    }

    public Reward getReward() {
        return this.reward;
    }

    public boolean isPlaced() {
        return this.reward.isPlaced();
    }

    public boolean isPurchased() {
        return this.purchased;
    }

    public void setPurchased(boolean purchased) {
        this.purchased = purchased;
    }

    public boolean isPurchasable() {
        return this.purchasable;
    }

    public void setPurchasable(boolean purchasable) {
        this.purchasable = purchasable;
    }
}

