/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.prestige.compat.crt;

import com.jarhax.prestige.Prestige;
import com.jarhax.prestige.compat.crt.IDisabledAction;
import com.jarhax.prestige.compat.crt.IEnabledAction;
import com.jarhax.prestige.compat.crt.IReward;
import com.jarhax.prestige.compat.crt.IRewardCondition;
import com.jarhax.prestige.compat.crt.ISellAction;
import com.jarhax.prestige.compat.crt.ITickingReward;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.potions.IPotionEffect;
import crafttweaker.mc1120.potions.MCPotionEfect;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.prestige.Rewards")
public class CRTRewards {
    @ZenMethod
    public static void registerReward(final String name, final IReward reward) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                List list = Prestige.REWARDS.getOrDefault(name, new LinkedList());
                list.add(reward);
                Prestige.REWARDS.put(name, list);
            }

            public String describe() {
                return "Adding reward: " + name + ".";
            }
        });
    }

    @ZenMethod
    public static void registerTickingReward(final String name, final ITickingReward reward) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                List list = Prestige.REWARDS.getOrDefault(name, new LinkedList());
                list.add(reward);
                Prestige.REWARDS.put(name, list);
            }

            public String describe() {
                return "Adding ticking reward: " + name + ".";
            }
        });
    }

    @ZenMethod
    public static void registerPotionReward(final String name, final IPotionEffect potion) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                List list = Prestige.REWARDS.getOrDefault(name, new LinkedList());
                list.add((world, player) -> {
                    if (!player.isPotionActive(potion.getPotion()) || (double)player.getActivePotionEffect(potion.getPotion()).getDuration() < Math.ceil(potion.getDuration() / 2)) {
                        player.addPotionEffect((IPotionEffect)new MCPotionEfect(new PotionEffect((Potion)potion.getPotion().getInternal(), potion.getDuration(), potion.getAmplifier(), potion.isAmbient(), potion.doesShowParticles())));
                    }
                });
                Prestige.REWARDS.put(name, list);
            }

            public String describe() {
                return "Adding potion reward: " + name + ".";
            }
        });
    }

    @ZenMethod
    public static void registerSellAction(final String name, final ISellAction reward) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                List list = Prestige.SELL_ACTIONS.getOrDefault(name, new LinkedList());
                list.add(reward);
                Prestige.SELL_ACTIONS.put(name, list);
            }

            public String describe() {
                return "Adding sell action: " + name + ".";
            }
        });
    }

    @ZenMethod
    public static void registerSellCommand(final String name, final String command) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                List list = Prestige.SELL_ACTIONS.getOrDefault(name, new LinkedList());
                list.add((world, player) -> {
                    EntityPlayer pl = (EntityPlayer)player.getInternal();
                    pl.func_184102_h().func_71187_D().func_71556_a((ICommandSender)pl.func_184102_h(), command.replace("@p", pl.getDisplayNameString()));
                });
                Prestige.SELL_ACTIONS.put(name, list);
            }

            public String describe() {
                return "Adding command sell: " + name + ".";
            }
        });
    }

    @ZenMethod
    public static void registerCommandReward(final String name, final String command) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                List list = Prestige.REWARDS.getOrDefault(name, new LinkedList());
                list.add((world, player) -> {
                    EntityPlayer pl = (EntityPlayer)player.getInternal();
                    pl.func_184102_h().func_71187_D().func_71556_a((ICommandSender)pl.func_184102_h(), command.replace("@p", pl.getDisplayNameString()));
                });
                Prestige.REWARDS.put(name, list);
            }

            public String describe() {
                return "Adding command reward: " + name + ".";
            }
        });
    }

    @ZenMethod
    public static void registerDisabledAction(final IDisabledAction reward) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                Prestige.DISABLED_ACTIONS.add(reward);
            }

            public String describe() {
                return "Adding disabled action.";
            }
        });
    }

    @ZenMethod
    public static void registerDisabledCommand(final String command) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                Prestige.DISABLED_ACTIONS.add((world, player) -> {
                    EntityPlayer pl = (EntityPlayer)player.getInternal();
                    pl.func_184102_h().func_71187_D().func_71556_a((ICommandSender)pl.func_184102_h(), command.replace("@p", pl.getDisplayNameString()));
                });
            }

            public String describe() {
                return "Adding disabled command.";
            }
        });
    }

    @ZenMethod
    public static void registerEnabledAction(final IEnabledAction reward) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                Prestige.ENABLED_ACTIONS.add(reward);
            }

            public String describe() {
                return "Adding enabled action.";
            }
        });
    }

    @ZenMethod
    public static void registerEnabledCommand(final String command) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                Prestige.ENABLED_ACTIONS.add((world, player) -> {
                    EntityPlayer pl = (EntityPlayer)player.getInternal();
                    pl.func_184102_h().func_71187_D().func_71556_a((ICommandSender)pl.func_184102_h(), command.replace("@p", pl.getDisplayNameString()));
                });
            }

            public String describe() {
                return "Adding enabled command.";
            }
        });
    }

    @ZenMethod
    public static void registerRewardCondition(final String name, final IRewardCondition condition) {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                List list = Prestige.REWARD_CONDITIONS.getOrDefault(name, new LinkedList());
                list.add(condition);
                Prestige.REWARD_CONDITIONS.put(name, list);
            }

            public String describe() {
                return "Adding reward condition for: " + name + ".";
            }
        });
    }
}

