/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.prestige.config;

import com.jarhax.prestige.Prestige;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static int unavailableColour = 0xCC0000;
    public static int purchasedColour = 52428;
    public static int purchaseableColour = 0xFFFFFF;
    public static int respecCooldown = 300;
    public static boolean respecEnabled = true;
    public static boolean newWorldMode;
    public static String prestigeButtonText;
    public static int shaderIndex;
    public static Configuration config;

    public static void init(File file) {
        config = new Configuration(file);
        config.load();
        unavailableColour = config.get("Colours", "Unavailable Colour", unavailableColour).getInt();
        purchasedColour = config.get("Colours", "Purchased Colour", purchasedColour).getInt();
        purchaseableColour = config.get("Colours", "Purchasable Colour", purchaseableColour).getInt();
        newWorldMode = config.getBoolean("NewWorldMode", "Gameplay", false, "Prestige window on a new world");
        prestigeButtonText = config.getString("PrestigeButtonText", "Gameplay", "Enable or Disable prestige for a specific world", "What text to show when hovering over the prestige button");
        Prestige.prestigeEnabled = config.getBoolean("Prestige Enabled Default", "Gameplay", true, "What is the default value for prestige?");
        respecCooldown = config.get("Respec", "Respec Cooldown", respecCooldown).getInt();
        respecEnabled = config.get("Respec", "Respec Enabled", respecEnabled).getBoolean();
        shaderIndex = config.get("Shaders", "Shader Index", shaderIndex).getInt();
        config.save();
    }

    public static float getRed(int hex) {
        return (float)(hex >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int hex) {
        return (float)(hex >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int hex) {
        return (float)(hex & 0xFF) / 255.0f;
    }

    public static float getAlpha(int hex) {
        return (float)(hex >> 24 & 0xFF) / 255.0f;
    }

    public static float[] getARGB(int hex) {
        return new float[]{Config.getAlpha(hex), Config.getRed(hex), Config.getGreen(hex), Config.getBlue(hex)};
    }

    static {
        shaderIndex = 0;
    }
}

