/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.prestige.data;

import com.jarhax.prestige.Prestige;
import com.jarhax.prestige.data.PlayerData;
import com.jarhax.prestige.packet.PacketSyncPrestige;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GlobalPrestigeData {
    private static final File SAVE_DIR = new File("prestige");
    private static final Map<UUID, PlayerData> CACHE = new HashMap<UUID, PlayerData>();

    public static PlayerData getPlayerData(UUID id) {
        return CACHE.computeIfAbsent(id, PlayerData::new);
    }

    public static PlayerData getPlayerData(EntityPlayer player) {
        return GlobalPrestigeData.getPlayerData(player.func_110124_au());
    }

    public static void saveAll() {
        for (PlayerData data : CACHE.values()) {
            GlobalPrestigeData.save(data);
        }
    }

    public static void save(EntityPlayer player) {
        PlayerData data = GlobalPrestigeData.getPlayerData(player);
        GlobalPrestigeData.save(data);
        if (player instanceof EntityPlayerMP) {
            Prestige.NETWORK.sendTo((IMessage)new PacketSyncPrestige(data), (EntityPlayerMP)player);
        }
    }

    public static void save(PlayerData data) {
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)data.save(), (File)new File(SAVE_DIR, data.getFileName()));
            Prestige.LOG.info("Saving data for {}.", (Object)data.getPlayerId().toString());
            CACHE.put(data.getPlayerId(), data);
        }
        catch (IOException e) {
            Prestige.LOG.trace("Could not save data for " + data.getPlayerId().toString(), (Throwable)e);
        }
    }

    public static void loadAll() {
        for (File file : SAVE_DIR.listFiles()) {
            PlayerData data = GlobalPrestigeData.load(file);
            if (data == null) continue;
            CACHE.put(data.getPlayerId(), data);
            Prestige.LOG.info("Successfully loaded data for {}. Confirmed: {} Unlocked: {}", (Object)data.getPlayerId().toString(), (Object)data.getPrestige(), (Object)data.getUnlockedRewards().size());
        }
    }

    public static PlayerData load(File file) {
        if (file.exists()) {
            try {
                return new PlayerData(CompressedStreamTools.func_74797_a((File)file));
            }
            catch (Exception e) {
                Prestige.LOG.trace("Could not load player data from " + file.getName(), (Throwable)e);
            }
        }
        return null;
    }

    static {
        if (!SAVE_DIR.exists()) {
            SAVE_DIR.mkdirs();
        }
    }
}

